/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.widgets.TableAndButtonsWidget;
import org.eclipse.tm4e.ui.internal.widgets.ThemeAssociationLabelProvider;
import org.eclipse.tm4e.ui.internal.wizards.CreateThemeAssociationWizard;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;

public final class ThemeAssociationsWidget
extends TableAndButtonsWidget {
    private final IThemeManager themeManager;
    private Button editButton = (Button)NullSafetyHelper.lazyNonNull();
    private Button removeButton = (Button)NullSafetyHelper.lazyNonNull();
    private @Nullable IGrammarDefinition definition;

    public ThemeAssociationsWidget(IThemeManager themeManager, Composite parent, int style) {
        super(parent, style, TMUIMessages.ThemeAssociationsWidget_description);
        this.themeManager = themeManager;
        super.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        super.setLabelProvider((IBaseLabelProvider)new ThemeAssociationLabelProvider());
        this.createButtons();
    }

    private void createButtons() {
        this.editButton = new Button(this.getButtonsArea(), 8);
        this.editButton.setText(TMUIMessages.Button_edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addListener(13, e -> {
            CreateThemeAssociationWizard wizard = new CreateThemeAssociationWizard(false);
            wizard.setInitialDefinition(this.definition);
            IStructuredSelection selection = super.getSelection();
            wizard.setInitialAssociation(selection.isEmpty() ? null : (IThemeAssociation)selection.getFirstElement());
            wizard.setThemeManager(this.themeManager);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                IThemeAssociation association = wizard.getCreatedThemeAssociation();
                this.refresh(association);
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(this.getButtonsArea(), 8);
        this.removeButton.setText(TMUIMessages.Button_remove);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addListener(13, e -> {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)TMUIMessages.ThemeAssociationsWidget_remove_dialog_title, (String)TMUIMessages.ThemeAssociationsWidget_remove_dialog_message)) {
                IStructuredSelection selection = super.getSelection();
                for (IThemeAssociation association : selection) {
                    this.themeManager.unregisterThemeAssociation(association);
                }
                this.refresh(null);
            }
        });
        this.removeButton.setEnabled(false);
    }

    public Button getNewButton() {
        return this.editButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public IThemeAssociation[] setGrammarDefinition(IGrammarDefinition definition) {
        this.definition = definition;
        return this.refresh(null);
    }

    private IThemeAssociation[] refresh(@Nullable IThemeAssociation association) {
        IGrammarDefinition definition = this.definition;
        if (definition == null) {
            return new IThemeAssociation[0];
        }
        IThemeAssociation[] themeAssociations = this.themeManager.getThemeAssociationsForScope(definition.getScopeName());
        super.setInput(themeAssociations);
        if (association == null && themeAssociations.length > 0) {
            association = themeAssociations[0];
        }
        if (association != null) {
            super.setSelection((IStructuredSelection)new StructuredSelection((Object)association));
        }
        return themeAssociations;
    }
}

