/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;

final class IncludeOnlyRule
extends Rule {
    final boolean hasMissingPatterns;
    final RuleId[] patterns;
    private @Nullable RegExpSourceList cachedCompiledPatterns;

    IncludeOnlyRule(RuleId id, @Nullable String name, @Nullable String contentName, CompilePatternsResult patterns) {
        super(id, name, contentName);
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
    }

    @Override
    public void collectPatterns(IRuleRegistry grammar, RegExpSourceList out) {
        RuleId[] ruleIdArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            RuleId pattern = ruleIdArray[n2];
            Rule rule = grammar.getRule(pattern);
            rule.collectPatterns(grammar, out);
            ++n2;
        }
    }

    @Override
    public CompiledRule compile(IRuleRegistry grammar, @Nullable String endRegexSource) {
        return this.getCachedCompiledPatterns(grammar).compile();
    }

    @Override
    public CompiledRule compileAG(IRuleRegistry grammar, @Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledPatterns(grammar).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledPatterns(IRuleRegistry grammar) {
        RegExpSourceList cachedCompiledPatterns = this.cachedCompiledPatterns;
        if (cachedCompiledPatterns == null) {
            cachedCompiledPatterns = new RegExpSourceList();
            this.collectPatterns(grammar, cachedCompiledPatterns);
            this.cachedCompiledPatterns = cachedCompiledPatterns;
        }
        return cachedCompiledPatterns;
    }
}

