/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.util;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.rse.internal.services.dstore.ServiceResources;

public class DownloadListener
implements IDomainListener {
    private DataElement _status;
    private IProgressMonitor _monitor;
    private DataStore _dataStore;
    private File _localFile;
    private boolean _networkDown = false;
    private boolean _isDone = false;
    private boolean _isCancelled = false;
    private long _totalBytesNotified = 0L;
    private long _totalLength;

    public DownloadListener(DataElement status, File localFile, String remotePath, long totalLength, IProgressMonitor monitor) {
        this._monitor = monitor;
        this._status = status;
        this._totalLength = totalLength;
        if (this._status == null) {
            System.out.println("Status is null!");
        }
        this._dataStore = this._status.getDataStore();
        this._dataStore.getDomainNotifier().addDomainListener((IDomainListener)this);
        this._localFile = localFile;
        if (this._status.getValue().equals("done")) {
            this.updateDownloadState();
            this.setDone(true);
        }
    }

    public long getTotalLength() {
        return this._totalLength;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    public DataElement getStatus() {
        return this._status;
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._status == null) {
            return false;
        }
        return this._status == event.getParent();
    }

    public void domainChanged(DomainEvent event) {
        if (this._status.getValue().equals("done")) {
            if (this._status == event.getParent()) {
                this.setDone(true);
            }
        } else {
            this.updateDownloadState();
        }
    }

    private void updateDownloadState() {
        long currentLength;
        long delta;
        if (this._monitor != null && (delta = (currentLength = this._localFile.length()) - this._totalBytesNotified) > 0L) {
            try {
                this._monitor.worked((int)delta);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                double percent = (double)currentLength * 1.0 / (double)this._totalLength;
                String str = MessageFormat.format(ServiceResources.DStore_Service_Percent_Complete_Message, new Long(currentLength / 1024L), new Long(this._totalLength / 1024L), new Double(percent));
                this._monitor.subTask(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._totalBytesNotified = currentLength;
        }
        if (!this._status.getDataStore().getStatus().getName().equals("okay")) {
            this._networkDown = true;
        }
    }

    public void setDone(boolean done) {
        this._isDone = done;
        if (done) {
            this.updateDownloadState();
            this._status.getDataStore().getDomainNotifier().removeDomainListener((IDomainListener)this);
        }
    }

    public boolean wasCancelled() {
        return this._isCancelled;
    }

    public DataElement waitForUpdate() throws InterruptedException {
        return this.waitForUpdate(0);
    }

    public DataElement waitForUpdate(int wait) throws InterruptedException {
        int WaitThreshold = 50;
        if (wait > 0) {
            WaitThreshold = wait * 10;
        } else if (wait == -1) {
            WaitThreshold = -1;
        }
        int initialWaitTheshold = WaitThreshold;
        while (!(this._isDone || this._isCancelled || this._networkDown)) {
            if (this._monitor != null && this._monitor.isCanceled()) {
                this.cancelDownload();
                this._isCancelled = true;
                this.setDone(true);
            } else if (this._networkDown) {
                this._isCancelled = true;
                this.setDone(true);
                throw new InterruptedException();
            }
            if (this.getStatus().getAttribute(2).equals("done")) {
                this.setDone(true);
                continue;
            }
            Thread.sleep(100L);
            this.updateDownloadState();
            if (WaitThreshold > 0) {
                --WaitThreshold;
                continue;
            }
            if (WaitThreshold != 0) continue;
            this.wakeupServer(this._status);
            WaitThreshold = initialWaitTheshold;
        }
        return this._status;
    }

    private void wakeupServer(DataElement status) {
        if (status != null) {
            DataElement cmdDescriptor = this._dataStore.findCommandDescriptor("C_NOTIFICATION");
            DataElement subject = status.getParent().get(0);
            if (cmdDescriptor != null) {
                this._dataStore.command(cmdDescriptor, subject);
            }
        }
    }

    public void cancelDownload() {
        DataElement status = this._status;
        if (status != null) {
            DataElement cmdDescriptor;
            DataElement command = status.getParent();
            DataStore dataStore = command.getDataStore();
            DataElement cancelDescriptor = dataStore.localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL");
            if (cancelDescriptor != null) {
                dataStore.command(cancelDescriptor, command);
            }
            this._localFile.delete();
        }
        if (this._monitor != null) {
            this._monitor.done();
        }
    }
}

