/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.CodePageConverterManager;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.rse.services";
    private static Boolean fTracingOn;

    static {
        fTracingOn = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerArchiveHandlers();
        this.registerCodePageConverters();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void registerArchiveHandlers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "archivehandlers");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            String ext = systemTypeExtensions[i].getAttribute("fileNameExtension");
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            String handlerType = systemTypeExtensions[i].getAttribute("class");
            try {
                String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)nameSpace);
                if (bundle.getState() != 1) {
                    Class handler = bundle.loadClass(handlerType);
                    ArchiveHandlerManager.getInstance().setRegisteredHandler(ext, handler);
                }
            }
            catch (ClassNotFoundException e) {
                this.logException(e);
            }
            ++i;
        }
    }

    private void registerCodePageConverters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(PLUGIN_ID, "codePageConverters");
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equalsIgnoreCase("codePageConverter")) {
                        try {
                            Object codePageConverter = element.createExecutableExtension("class");
                            if (codePageConverter != null && codePageConverter instanceof IFileServiceCodePageConverter) {
                                CodePageConverterManager.registerCodePageConverter((IFileServiceCodePageConverter)codePageConverter);
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void logException(Throwable t) {
        ILog log = this.getLog();
        String id = this.getBundle().getSymbolicName();
        Status status = new Status(4, id, 0, "Unexpected exception", t);
        log.log((IStatus)status);
    }

    public static boolean isTracingOn() {
        if (fTracingOn == null) {
            String id = plugin.getBundle().getSymbolicName();
            String val = Platform.getDebugOption((String)(String.valueOf(id) + "/debug"));
            fTracingOn = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        return fTracingOn;
    }

    public static String getTimestamp() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    public static void trace(String msg) {
        if (Activator.isTracingOn()) {
            String fullMsg = String.valueOf(Activator.getTimestamp()) + " | " + Thread.currentThread().getName() + " | " + msg;
            System.out.println(fullMsg);
            System.out.flush();
        }
    }
}

