/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.browser;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.eclipse.help.internal.base.HelpBasePlugin;

public class BrowserLog {
    private String logFileName;
    private boolean newSession;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy kk:mm:ss.SS").withZone(ZoneId.systemDefault());
    String LN = System.lineSeparator();

    private BrowserLog() {
        try {
            this.newSession = true;
            this.logFileName = HelpBasePlugin.getDefault().getStateLocation().append("browser.log").toOSString();
        }
        catch (Exception exception) {}
    }

    private static BrowserLog getInstance() {
        return LogHolder.instance;
    }

    public static synchronized void log(String message) {
        BrowserLog.getInstance().append(message);
    }

    private void append(String message) {
        if (this.logFileName == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, true), StandardCharsets.UTF_8));){
                if (this.newSession) {
                    this.newSession = false;
                    outWriter.write(this.LN + formatter.format(Instant.now()) + " NEW SESSION" + this.LN);
                }
                outWriter.write(formatter.format(Instant.now()) + " " + message + this.LN);
                ((Writer)outWriter).flush();
                ((Writer)outWriter).close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private static class LogHolder {
        static final BrowserLog instance = new BrowserLog();

        private LogHolder() {
        }
    }
}

