/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.debug.util.Preconditions;
import org.eclipse.lsp4j.debug.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * The event signals the end of the progress reporting with a final message.
 * <p>
 * This event should only be sent if the corresponding capability 'supportsProgressReporting' is true.
 * <p>
 * Represents the {@code body} of {@code ProgressEndEvent} defined in spec.
 */
@SuppressWarnings("all")
public class ProgressEndEventArguments {
  /**
   * The ID that was introduced in the initial 'ProgressStartEvent'.
   */
  @NonNull
  private String progressId;

  /**
   * More detailed progress message. If omitted, the previous message (if any) is used.
   * <p>
   * This is an optional property.
   */
  private String message;

  /**
   * The ID that was introduced in the initial 'ProgressStartEvent'.
   */
  @NonNull
  public String getProgressId() {
    return this.progressId;
  }

  /**
   * The ID that was introduced in the initial 'ProgressStartEvent'.
   */
  public void setProgressId(@NonNull final String progressId) {
    this.progressId = Preconditions.checkNotNull(progressId, "progressId");
  }

  /**
   * More detailed progress message. If omitted, the previous message (if any) is used.
   * <p>
   * This is an optional property.
   */
  public String getMessage() {
    return this.message;
  }

  /**
   * More detailed progress message. If omitted, the previous message (if any) is used.
   * <p>
   * This is an optional property.
   */
  public void setMessage(final String message) {
    this.message = message;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("progressId", this.progressId);
    b.add("message", this.message);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    ProgressEndEventArguments other = (ProgressEndEventArguments) obj;
    if (this.progressId == null) {
      if (other.progressId != null)
        return false;
    } else if (!this.progressId.equals(other.progressId))
      return false;
    if (this.message == null) {
      if (other.message != null)
        return false;
    } else if (!this.message.equals(other.message))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.progressId== null) ? 0 : this.progressId.hashCode());
    return prime * result + ((this.message== null) ? 0 : this.message.hashCode());
  }
}
