/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.graphical;

import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IRootFigure;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.draw2d.TargetFigureFindVisitor;
import org.eclipse.wb.internal.gef.core.AbstractEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.core.TargetEditPartFindVisitor;
import org.eclipse.wb.internal.gef.graphical.EditEventManager;
import org.eclipse.wb.internal.gef.graphical.RootEditPart;

public class GraphicalViewer
extends AbstractEditPartViewer {
    protected final FigureCanvas m_canvas;
    private final RootEditPart m_rootEditPart;
    private EditEventManager m_eventManager;

    public GraphicalViewer(Composite parent) {
        this(parent, 768);
    }

    public GraphicalViewer(Composite parent, int style) {
        this(new FigureCanvas(parent, style){

            @Override
            protected void setDefaultEventManager() {
            }
        });
    }

    protected GraphicalViewer(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_rootEditPart = new RootEditPart(this, this.getRootFigure());
        this.m_rootEditPart.activate();
        this.setRootEditPart(this.m_rootEditPart);
    }

    public FigureCanvas getControl() {
        return this.m_canvas;
    }

    @Override
    public int getHOffset() {
        return this.m_canvas.getHorizontalScrollModel().getSelection();
    }

    @Override
    public int getVOffset() {
        return this.m_canvas.getVerticalScrollModel().getSelection();
    }

    @Override
    public EditPart getRootEditPart() {
        return this.m_rootEditPart;
    }

    @Override
    public final IRootFigure getRootFigure() {
        return this.getRootFigureInternal();
    }

    protected final RootFigure getRootFigureInternal() {
        return this.m_canvas.getRootFigure();
    }

    @Override
    public Layer getLayer(String name) {
        return this.getRootFigure().getLayer(name);
    }

    @Override
    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.m_eventManager = new EditEventManager(this.m_canvas, domain, this);
        this.getRootFigureInternal().setEventManager(this.m_eventManager);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.m_eventManager.setOverrideCursor(cursor);
    }

    @Override
    public EditPart findTargetEditPart(int x, int y, Collection<EditPart> exclude, IEditPartViewer.IConditional conditional) {
        EditPart editPart = this.findTargetEditPart(x, y, exclude, conditional, "Menu Primary Layer");
        if (editPart == null) {
            editPart = this.findTargetEditPart(x, y, exclude, conditional, "Primary Layer");
        }
        return editPart;
    }

    @Override
    public EditPart findTargetEditPart(int x, int y, final Collection<EditPart> exclude, final IEditPartViewer.IConditional conditional, String layer) {
        TargetEditPartFindVisitor visitor = new TargetEditPartFindVisitor(this.m_canvas, x, y){

            @Override
            protected boolean acceptVisit(Figure figure) {
                for (EditPart editPart : exclude) {
                    GraphicalEditPart graphicalPart = (GraphicalEditPart)editPart;
                    if (!ObjectUtils.equals((Object)figure, (Object)graphicalPart.getFigure())) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected boolean acceptResult(Figure figure) {
                EditPart editPart = 2.extractEditPart(figure);
                return editPart != null && (conditional == null || conditional.evaluate(editPart));
            }
        };
        this.getLayer(layer).accept(visitor, false);
        return visitor.getTargetEditPart();
    }

    @Override
    public Handle findTargetHandle(Point location) {
        return this.findTargetHandle(location.x, location.y);
    }

    @Override
    public Handle findTargetHandle(int x, int y) {
        Handle target = this.findTargetHandle("Menu Handle Layer static", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Menu Handle Layer", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer Static", x, y);
        if (target != null) {
            return target;
        }
        target = this.findTargetHandle("Handle Layer", x, y);
        if (target != null) {
            return target;
        }
        return null;
    }

    private Handle findTargetHandle(String layer, int x, int y) {
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_canvas, x, y);
        this.getLayer(layer).accept(visitor, false);
        Figure targetFigure = visitor.getTargetFigure();
        return targetFigure instanceof Handle ? (Handle)targetFigure : null;
    }
}

