/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.ClasspathImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.DefaultImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.FileImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.NullImagePage;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageEvaluator;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginFileImagePage;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginImagesRoot;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;

public final class ImagePropertyEditor
extends TextDialogPropertyEditor
implements IClipboardSourceProvider {
    public static final PropertyEditor INSTANCE = new ImagePropertyEditor();

    private ImagePropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        if (property.getValue() != Property.UNKNOWN_VALUE) {
            Expression stringExpression;
            MethodInvocation invocation;
            ClassInstanceCreation creation;
            ITypeBinding creationBinding;
            Expression expression = ((GenericProperty)property).getExpression();
            if (expression instanceof NullLiteral) {
                return "(null)";
            }
            if (expression instanceof ClassInstanceCreation && AstNodeUtils.getFullyQualifiedName((ITypeBinding)(creationBinding = AstNodeUtils.getTypeBinding((Expression)(creation = (ClassInstanceCreation)expression))), (boolean)false).equals("org.eclipse.swt.graphics.Image")) {
                Expression streamExpression;
                String constructorSignature = AstNodeUtils.getCreationSignature((ClassInstanceCreation)creation);
                if ("<init>(org.eclipse.swt.graphics.Device,java.lang.String)".equals(constructorSignature)) {
                    Expression stringExpression2 = (Expression)DomGenerics.arguments((ClassInstanceCreation)creation).get(1);
                    return "File: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression2);
                }
                if ("<init>(org.eclipse.swt.graphics.Device,java.io.InputStream)".equals(constructorSignature) && AstNodeUtils.isMethodInvocation((ASTNode)(streamExpression = (Expression)DomGenerics.arguments((ClassInstanceCreation)creation).get(1)), (String)"java.lang.Class", (String)"getResourceAsStream(java.lang.String)")) {
                    MethodInvocation streamCreateInvocation = (MethodInvocation)streamExpression;
                    Expression stringExpression3 = (Expression)DomGenerics.arguments((MethodInvocation)streamCreateInvocation).get(0);
                    return "Classpath: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression3);
                }
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.SWTResourceManager", (String)"getImage(java.lang.String)")) {
                invocation = (MethodInvocation)expression;
                stringExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0);
                return "File: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression);
            }
            if (AstNodeUtils.isMethodInvocation((ASTNode)expression, (String)"org.eclipse.wb.swt.SWTResourceManager", (String)"getImage(java.lang.Class,java.lang.String)")) {
                invocation = (MethodInvocation)expression;
                stringExpression = (Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1);
                return "Classpath: " + JavaInfoEvaluationHelper.getValue((Expression)stringExpression);
            }
            String[] imageValue = ImageEvaluator.getPluginImageValue(property);
            if (imageValue != null) {
                return "Plugin: " + imageValue[0] + " " + imageValue[1];
            }
        }
        return null;
    }

    public String getClipboardSource(GenericProperty property) throws Exception {
        if (property.getValue() != Property.UNKNOWN_VALUE) {
            Expression expression = property.getExpression();
            if (expression instanceof NullLiteral) {
                return "null";
            }
            JavaInfo javaInfo = property.getJavaInfo();
            String[] imageValue = ImageEvaluator.getPluginImageValue((Property)property);
            if (imageValue == null) {
                IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
                boolean useResourceManager = preferences.getBoolean("useResourceManager");
                String text = this.getText((Property)property);
                if (text.startsWith("File: ")) {
                    String path = text.substring("File: ".length());
                    String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                    if (useResourceManager) {
                        return "org.eclipse.wb.swt.SWTResourceManager.getImage(" + pathSource + ")";
                    }
                    return "new org.eclipse.swt.graphics.Image(null, " + pathSource + ")";
                }
                if (text.startsWith("Classpath: ")) {
                    String path = text.substring("Classpath: ".length());
                    String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                    if (useResourceManager) {
                        return "org.eclipse.wb.swt.SWTResourceManager.getImage({wbp_classTop}, " + pathSource + ")";
                    }
                    return "new org.eclipse.swt.graphics.Image(null, {wbp_classTop}.getResourceAsStream(" + pathSource + "))";
                }
            } else {
                String symbolicName = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)imageValue[0]);
                String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)imageValue[1]);
                return "org.eclipse.wb.swt.ResourceManager.getPluginImage(" + symbolicName + ", " + pathSource + ")";
            }
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        IJavaProject javaProject = javaInfo.getEditor().getJavaProject();
        ImageDialog imageDialog = new ImageDialog(javaProject);
        String[] imageValue = ImageEvaluator.getPluginImageValue(property);
        if (imageValue == null) {
            String text = this.getText(property);
            if (text == null) {
                imageDialog.setInput("DEFAULT", null);
            } else if (text.equals("(null)")) {
                imageDialog.setInput("NULL", null);
            } else if (text.startsWith("File: ")) {
                path = text.substring("File: ".length());
                imageDialog.setInput("FILE", path);
            } else if (text.startsWith("Classpath: ")) {
                path = text.substring("Classpath: ".length());
                imageDialog.setInput("CLASSPATH", path);
            }
        } else {
            imageDialog.setInput("PLUGIN", imageValue);
        }
        if (imageDialog.open() == 0) {
            ImageInfo imageInfo = imageDialog.getImageInfo();
            String source = null;
            String pageId = imageInfo.getPageId();
            if (pageId != "DEFAULT") {
                if (pageId == "NULL") {
                    source = "null";
                } else {
                    IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
                    boolean useResourceManager = preferences.getBoolean("useResourceManager");
                    if (useResourceManager) {
                        ManagerUtils.ensure_SWTResourceManager(javaInfo);
                    }
                    if (pageId == "FILE") {
                        String path = (String)imageInfo.getData();
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                        source = useResourceManager ? "org.eclipse.wb.swt.SWTResourceManager.getImage(" + pathSource + ")" : "new org.eclipse.swt.graphics.Image(null, " + pathSource + ")";
                    } else if (pageId == "CLASSPATH") {
                        String path = "/" + imageInfo.getData();
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)path);
                        source = useResourceManager ? "org.eclipse.wb.swt.SWTResourceManager.getImage({wbp_classTop}, " + pathSource + ")" : "new org.eclipse.swt.graphics.Image(null, {wbp_classTop}.getResourceAsStream(" + pathSource + "))";
                    } else if (pageId == "PLUGIN") {
                        ManagerUtils.ensure_ResourceManager(javaInfo);
                        String[] data = (String[])imageInfo.getData();
                        String symbolicName = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)data[0]);
                        String pathSource = StringConverter.INSTANCE.toJavaSource(javaInfo, (Object)data[1]);
                        source = "org.eclipse.wb.swt.ResourceManager.getPluginImage(" + symbolicName + ", " + pathSource + ")";
                    }
                }
            }
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
    }

    private static final class ImageDialog
    extends AbstractImageDialog {
        private final IJavaProject m_javaProject;

        protected ImageDialog(IJavaProject javaProject) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)Activator.getDefault());
            this.m_javaProject = javaProject;
        }

        protected void addPages(Composite parent) {
            this.addPage((AbstractImagePage)new ClasspathImagePage(parent, 0, (AbstractImageDialog)this, this.m_javaProject));
            this.addPage((AbstractImagePage)new FileImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new NullImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new DefaultImagePage(parent, 0, (AbstractImageDialog)this));
            if (PluginImagesRoot.testPluginProject(this.m_javaProject.getProject())) {
                this.addPage((AbstractImagePage)PluginFileImagePage.createPage(parent, 0, this, this.m_javaProject.getProject()));
            }
        }
    }
}

