/*******************************************************************************
 * Copyright (c) 2011 Google, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Google, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.wb.internal.core.editor.palette.dialogs;

import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.palette.command.Command;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

/**
 * Abstract {@link TitleAreaDialog} for palette elements.
 *
 * @author scheglov_ke
 * @coverage core.editor.palette.ui
 */
public abstract class AbstractPaletteElementDialog extends AbstractPaletteDialog {
  ////////////////////////////////////////////////////////////////////////////
  //
  // Constructor
  //
  ////////////////////////////////////////////////////////////////////////////
  public AbstractPaletteElementDialog(Shell parentShell,
      String shellText,
      String titleText,
      Image titleImage,
      String titleMessage) {
    super(parentShell, shellText, titleText, titleImage, titleMessage);
    setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
  }

  ////////////////////////////////////////////////////////////////////////////
  //
  // Buttons
  //
  ////////////////////////////////////////////////////////////////////////////
  @Override
  protected void okPressed() {
    m_command = createCommand();
    super.okPressed();
  }

  /**
   * @return new {@link Command} for modifying {@link PaletteInfo}.
   */
  protected abstract Command createCommand();

  ////////////////////////////////////////////////////////////////////////////
  //
  // Access
  //
  ////////////////////////////////////////////////////////////////////////////
  private Command m_command;

  /**
   * @return the {@link Command} generated by this dialog.
   */
  public final Command getCommand() {
    return m_command;
  }
}
