/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.nonvisual;

import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.GefMessages;
import org.eclipse.wb.internal.core.gef.part.nonvisual.BeanFigure;
import org.eclipse.wb.internal.core.gef.part.nonvisual.NonVisualBeanEditPart;
import org.eclipse.wb.internal.core.gef.policy.nonvisual.NonVisualValidator;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public final class NonVisualLayoutEditPolicy
extends LayoutEditPolicy {
    private static final int SNAP_GRID_SIZE = 10;
    private final JavaInfo m_rootInfo;
    private final ILayoutRequestValidator m_validator;
    private Figure m_feedbackFigure;
    private Figure[] m_moveFeedbackFigures;

    public NonVisualLayoutEditPolicy(JavaInfo rootInfo) {
        this.m_rootInfo = rootInfo;
        this.m_validator = new NonVisualValidator(this.m_rootInfo);
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_validator;
    }

    protected Command getCreateCommand(final CreateRequest request) {
        final Point location = this.m_feedbackFigure.getLocation();
        return new EditCommand(this.m_rootInfo){

            protected void executeEdit() throws Exception {
                JavaInfo newInfo = (JavaInfo)((Object)request.getNewObject());
                NonVisualBeanContainerInfo.add(NonVisualLayoutEditPolicy.this.m_rootInfo, newInfo, location);
            }
        };
    }

    protected Command getPasteCommand(final PasteRequest request) {
        final Point location = this.m_feedbackFigure.getLocation();
        return new EditCommand(this.m_rootInfo){

            protected void executeEdit() throws Exception {
                List mementos = (List)request.getMemento();
                JavaInfoMemento memento = (JavaInfoMemento)mementos.get(0);
                JavaInfo newInfo = memento.create(NonVisualLayoutEditPolicy.this.m_rootInfo);
                NonVisualBeanContainerInfo.add(NonVisualLayoutEditPolicy.this.m_rootInfo, newInfo, location);
                memento.apply();
            }
        };
    }

    protected Command getMoveCommand(final ChangeBoundsRequest request) {
        return new EditCommand(this.m_rootInfo){

            protected void executeEdit() throws Exception {
                Point snapMoveDelta = NonVisualLayoutEditPolicy.applyGrid(request.getMoveDelta(), 10);
                for (NonVisualBeanEditPart part : request.getEditParts()) {
                    NonVisualBeanInfo nonVisualBeanInfo = part.getNonVisualInfo();
                    nonVisualBeanInfo.moveLocation(snapMoveDelta);
                }
            }
        };
    }

    protected void showLayoutTargetFeedback(Request request) {
        Object type = request.getType();
        if ("create child".equals(type)) {
            this.showCreationFeedback((CreateRequest)request);
        } else if ("paste".equals(type)) {
            this.showPasteFeedback((PasteRequest)request);
        } else if ("move".equals(type)) {
            this.showMoveFeedback((ChangeBoundsRequest)request);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.m_feedbackFigure != null) {
            this.removeFeedback(this.m_feedbackFigure);
            this.m_feedbackFigure = null;
        }
        if (this.m_moveFeedbackFigures != null) {
            Figure[] figureArray = this.m_moveFeedbackFigures;
            int n = this.m_moveFeedbackFigures.length;
            int n2 = 0;
            while (n2 < n) {
                Figure figure = figureArray[n2];
                this.removeFeedback(figure);
                ++n2;
            }
            this.m_moveFeedbackFigures = null;
        }
    }

    private void showCreationFeedback(CreateRequest request) {
        JavaInfo newInfo = (JavaInfo)((Object)request.getNewObject());
        Point location = request.getLocation();
        this.showFeedback(GefMessages.NonVisualLayoutEditPolicy_newFeedback, newInfo, location);
    }

    private void showPasteFeedback(PasteRequest request) {
        try {
            List mementos = (List)request.getMemento();
            JavaInfo newInfo = ((JavaInfoMemento)mementos.get(0)).create(this.m_rootInfo);
            Point location = request.getLocation();
            this.showFeedback(GefMessages.NonVisualLayoutEditPolicy_copyFeedback, newInfo, location);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    private void showFeedback(String prefix, JavaInfo info, Point location) {
        if (this.m_feedbackFigure == null) {
            BeanFigure figure = new BeanFigure(info.getDescription().getIcon());
            Class<?> componentClass = info.getDescription().getComponentClass();
            figure.update(String.valueOf(prefix) + ClassUtils.getShortClassName(componentClass), location);
            this.m_feedbackFigure = figure;
            this.addFeedback(figure);
        }
        Rectangle bounds = this.m_feedbackFigure.getBounds();
        Point snapLocation = NonVisualLayoutEditPolicy.applyGrid(location, 10);
        this.m_feedbackFigure.setLocation(new Point(snapLocation.x - bounds.width / 2, snapLocation.y - bounds.height));
    }

    private void showMoveFeedback(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        if (this.m_moveFeedbackFigures == null) {
            this.m_moveFeedbackFigures = new Figure[editParts.size()];
            int i = 0;
            while (i < this.m_moveFeedbackFigures.length) {
                NonVisualBeanEditPart part = (NonVisualBeanEditPart)((Object)editParts.get(i));
                final JavaInfo info = part.getNonVisualInfo().getJavaInfo();
                BeanFigure figure = new BeanFigure(info.getDescription().getIcon());
                String text = (String)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<String>(){

                    public String runObject() throws Exception {
                        return info.getVariableSupport().getTitle();
                    }
                }, null);
                figure.update(text, request.getLocation());
                this.m_moveFeedbackFigures[i] = figure;
                this.addFeedback(figure);
                ++i;
            }
        }
        Point snapMoveDelta = NonVisualLayoutEditPolicy.applyGrid(request.getMoveDelta(), 10);
        int i = 0;
        while (i < this.m_moveFeedbackFigures.length) {
            NonVisualBeanEditPart part = (NonVisualBeanEditPart)((Object)editParts.get(i));
            Point location = part.getNonVisualInfo().getLocation().getCopy();
            location.performTranslate(snapMoveDelta);
            this.m_moveFeedbackFigures[i].setLocation(location);
            ++i;
        }
    }

    private static Point applyGrid(Point point, int step) {
        return new Point(NonVisualLayoutEditPolicy.applyGrid(point.x, step), NonVisualLayoutEditPolicy.applyGrid(point.y, step));
    }

    private static int applyGrid(int value, int step) {
        return value / step * step;
    }
}

