/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.internal.core.utils.GenericsUtils;

public class DomGenerics {
    private DomGenerics() {
    }

    public static List<Comment> getCommentList(CompilationUnit unit) {
        return unit.getCommentList();
    }

    public static List<TagElement> tags(Javadoc javadoc) {
        return javadoc.tags();
    }

    public static List<ASTNode> fragments(TagElement tagElement) {
        return tagElement.fragments();
    }

    public static List<ImportDeclaration> imports(CompilationUnit unit) {
        return unit.imports();
    }

    public static List<TypeDeclaration> types(CompilationUnit unit) {
        return unit.types();
    }

    public static List<Type> superInterfaces(TypeDeclaration typeDeclaration) {
        return typeDeclaration.superInterfaceTypes();
    }

    public static List<BodyDeclaration> bodyDeclarations(TypeDeclaration typeDeclaration) {
        return typeDeclaration.bodyDeclarations();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Initializer> initializers(TypeDeclaration typeDeclaration, boolean aStatic) {
        ArrayList initializers = Lists.newArrayList();
        for (BodyDeclaration bodyDeclaration : DomGenerics.bodyDeclarations(typeDeclaration)) {
            void initializer;
            BodyDeclaration bodyDeclaration2 = bodyDeclaration;
            if (!(bodyDeclaration2 instanceof Initializer)) continue;
            Initializer cfr_ignored_0 = (Initializer)bodyDeclaration2;
            Initializer cfr_ignored_1 = (Initializer)bodyDeclaration2;
            boolean isStatic = Modifier.isStatic(initializer.getModifiers());
            if ((!aStatic || !isStatic) && (aStatic || isStatic)) continue;
            initializers.add(initializer);
        }
        return initializers;
    }

    public static List<Name> thrownExceptions(MethodDeclaration methodDeclaration) {
        return methodDeclaration.thrownExceptions();
    }

    public static List<BodyDeclaration> bodyDeclarations(AnonymousClassDeclaration anonymousDeclaration) {
        return anonymousDeclaration.bodyDeclarations();
    }

    public static List<MethodDeclaration> methodDeclarations(AnonymousClassDeclaration anonymousDeclaration) {
        List<BodyDeclaration> bodyDeclarations = DomGenerics.bodyDeclarations(anonymousDeclaration);
        return GenericsUtils.select(bodyDeclarations, MethodDeclaration.class);
    }

    public static List<Statement> statements(Block block) {
        return block.statements();
    }

    public static List<Statement> statements(MethodDeclaration method) {
        if (method == null) {
            return ImmutableList.of();
        }
        Block body = method.getBody();
        if (body == null) {
            return ImmutableList.of();
        }
        return DomGenerics.statements(body);
    }

    public static List<IExtendedModifier> modifiers(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.modifiers();
    }

    public static List<ASTNode> modifiersNodes(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.modifiers();
    }

    public static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    public static List<TypeParameter> typeParameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.typeParameters();
    }

    public static List<Expression> arguments(ASTNode node) {
        if (node instanceof MethodInvocation) {
            return DomGenerics.arguments((MethodInvocation)node);
        }
        if (node instanceof SuperMethodInvocation) {
            return DomGenerics.arguments((SuperMethodInvocation)node);
        }
        if (node instanceof ClassInstanceCreation) {
            return DomGenerics.arguments((ClassInstanceCreation)node);
        }
        if (node instanceof ConstructorInvocation) {
            return DomGenerics.arguments((ConstructorInvocation)node);
        }
        if (node instanceof SuperConstructorInvocation) {
            return DomGenerics.arguments((SuperConstructorInvocation)node);
        }
        throw new IllegalArgumentException(node + " does not have arguments.");
    }

    public static List<Expression> arguments(MethodInvocation invocation) {
        return invocation.arguments();
    }

    public static List<Expression> arguments(SuperMethodInvocation invocation) {
        return invocation.arguments();
    }

    public static List<Expression> arguments(ClassInstanceCreation creation) {
        return creation.arguments();
    }

    public static List<Expression> arguments(ConstructorInvocation invocation) {
        return invocation.arguments();
    }

    public static List<Expression> arguments(SuperConstructorInvocation invocation) {
        return invocation.arguments();
    }

    public static List<VariableDeclarationFragment> fragments(FieldDeclaration fieldDeclaration) {
        return fieldDeclaration.fragments();
    }

    public static List<VariableDeclarationFragment> fragments(VariableDeclarationStatement statement) {
        return statement.fragments();
    }

    public static List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    public static List<Expression> extendedOperands(InfixExpression infixExpression) {
        return infixExpression.extendedOperands();
    }

    public static List<Expression> allOperands(InfixExpression infixExpression) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        operands.add(infixExpression.getLeftOperand());
        operands.add(infixExpression.getRightOperand());
        operands.addAll(DomGenerics.extendedOperands(infixExpression));
        return operands;
    }

    public static List<Type> typeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.typeArguments();
    }

    public static List<Expression> dimensions(ArrayCreation arrayCreation) {
        return arrayCreation.dimensions();
    }

    public static List<EnumDeclaration> getEnums(TypeDeclaration typeDeclaration) {
        ArrayList enumDeclarations = Lists.newArrayList();
        List declarations = typeDeclaration.bodyDeclarations();
        for (Object object : declarations) {
            if (!(object instanceof EnumDeclaration)) continue;
            enumDeclarations.add((EnumDeclaration)object);
        }
        return enumDeclarations;
    }

    public static List<ASTNode> getEnumConstants(EnumDeclaration enumDeclaration) {
        return enumDeclaration.enumConstants();
    }

    public static List<CatchClause> catchClauses(TryStatement tryStatement) {
        return tryStatement.catchClauses();
    }

    public static Expression getExpression(Statement statement) {
        return ((ExpressionStatement)statement).getExpression();
    }
}

