/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout.form;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.layout.absolute.OrderingSupport;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImpl;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.actions.PredefinedAnchorsActions;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;
import org.eclipse.wb.internal.xwt.model.layout.CompositeClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.xwt.model.layout.form.FormDataInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class FormLayoutInfo
extends LayoutInfo
implements IFormLayoutInfo<ControlInfo> {
    private final FormLayoutInfoImpl<ControlInfo> impl;
    private final FormLayoutPreferences<ControlInfo> preferences;

    public FormLayoutInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.preferences = new FormLayoutPreferences((IFormLayoutInfo)this, description.getToolkit());
        this.addBroadcastListeners();
        this.impl = this.getPreferences().useClassic() ? new FormLayoutInfoImplClassic((IFormLayoutInfo)this) : new FormLayoutInfoImplAutomatic((IFormLayoutInfo)this);
    }

    private void addBroadcastListeners() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (FormLayoutInfo.this.isManagedObject(object)) {
                    ControlInfo control = (ControlInfo)object;
                    FormLayoutInfo.this.contributeControlContextMenu(manager, control);
                }
            }
        });
    }

    public static FormDataInfo getFormData(ControlInfo control) {
        return (FormDataInfo)FormLayoutInfo.getLayoutData(control);
    }

    private void contributeControlContextMenu(IMenuManager manager, final ControlInfo control) {
        List<ControlInfo> controls = this.getComposite().getChildrenControls();
        new OrderingSupport(controls, (IAbstractComponentInfo)control).contributeActions(manager);
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)control, "Autosize control", Activator.getImageDescriptor((String)"info/layout/FormLayout/fit_to_size.png")){

            protected void runEx() throws Exception {
                FormLayoutInfo.this.doAutoSize(control);
            }
        };
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IAction)action);
        MenuManager predefinedMenuManager = new MenuManager("Quick constraints");
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IContributionItem)predefinedMenuManager);
        new PredefinedAnchorsActions((IFormLayoutInfo)this).contributeActions((IControlInfo)control, (IContributionManager)predefinedMenuManager);
    }

    private void doAutoSize(ControlInfo control) throws Exception {
        this.doAutoSize(this.getAttachment(control, 1), this.getAttachment(control, 4));
        this.doAutoSize(this.getAttachment(control, 8), this.getAttachment(control, 32));
        FormDataInfo formData = FormLayoutInfo.getFormData(control);
        formData.getPropertyByTitle("width").setValue(Property.UNKNOWN_VALUE);
        formData.getPropertyByTitle("height").setValue(Property.UNKNOWN_VALUE);
    }

    private void doAutoSize(FormAttachmentInfo leading, FormAttachmentInfo trailing) throws Exception {
        if (!leading.isVirtual() && !trailing.isVirtual()) {
            if (leading.isParentTrailing() || trailing.getControl() != null && trailing.getOffset() <= 0) {
                leading.delete();
            } else {
                trailing.delete();
            }
        }
    }

    public void commandMove(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_MOVE(control, nextControl);
    }

    public void commandCreate(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_CREATE(control, nextControl);
    }

    @Override
    protected void clipboardCopy_addCompositeCommands(List<ClipboardCommand> commands) throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            if (FormLayoutInfo.isImplicitlyCreated(control)) continue;
            commands.add(new LayoutClipboardCommand<FormLayoutInfo>(control){
                private static final long serialVersionUID = 0L;

                @Override
                protected void add(FormLayoutInfo layout, ControlInfo control) throws Exception {
                    layout.command_CREATE(control, null);
                }
            });
        }
        List<ControlInfo> childrenControls = this.getComposite().getChildrenControls();
        int i = 0;
        while (i < childrenControls.size()) {
            ControlInfo control = childrenControls.get(i);
            if (!FormLayoutInfo.isImplicitlyCreated(control)) {
                FormDataInfo formData = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
                final FormAttachmentInfo.FormAttachmentClipboardInfo left = formData.getAttachment(1).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo right = formData.getAttachment(4).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo top = formData.getAttachment(8).getClipboardInfo();
                final FormAttachmentInfo.FormAttachmentClipboardInfo bottom = formData.getAttachment(32).getClipboardInfo();
                final int index = i;
                commands.add(new CompositeClipboardCommand(){
                    private static final long serialVersionUID = 0L;

                    @Override
                    protected void execute(CompositeInfo composite) throws Exception {
                        ControlInfo control = composite.getChildrenControls().get(index);
                        FormDataInfo _thisFormData = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
                        _thisFormData.getAttachment(1).applyClipboardInfo(control, left);
                        _thisFormData.getAttachment(4).applyClipboardInfo(control, right);
                        _thisFormData.getAttachment(8).applyClipboardInfo(control, top);
                        _thisFormData.getAttachment(32).applyClipboardInfo(control, bottom);
                    }
                });
            }
            ++i;
        }
    }

    private static boolean isImplicitlyCreated(ControlInfo control) {
        return control.getCreationSupport() instanceof IImplicitCreationSupport;
    }

    @Override
    public void onSet() throws Exception {
        super.onSet();
        List<ControlInfo> controls = this.getControls();
        Rectangle parentArea = this.getComposite().getClientArea();
        for (ControlInfo control : controls) {
            Rectangle controlBounds = control.getModelBounds();
            Dimension preferredSize = control.getPreferredSize();
            int x = controlBounds.x - parentArea.x;
            int y = controlBounds.y - parentArea.y;
            int width = controlBounds.width;
            int height = controlBounds.height;
            this.setAttachmentOffset(control, 1, x);
            this.setAttachmentOffset(control, 8, y);
            if (width != preferredSize.width) {
                this.setAttachmentOffset(control, 4, x + width);
            }
            if (height == preferredSize.height) continue;
            this.setAttachmentOffset(control, 32, y + height);
        }
        this.preferences.addPropertyChangeListener();
    }

    public void setAttachmentOffset(ControlInfo control, int side, int offset) throws Exception {
        FormDataInfo dataInfo = (FormDataInfo)FormLayoutInfo.getLayoutData(control);
        FormAttachmentInfo attachment = dataInfo.getAttachment(side);
        attachment.setNumerator(0);
        attachment.setDenominator(100);
        attachment.setOffset(offset);
        attachment.write();
    }

    public FormLayoutInfoImpl<ControlInfo> getImpl() {
        return this.impl;
    }

    private FormAttachmentInfo getAttachment(ControlInfo widget, int side) throws Exception {
        FormDataInfo layoutData = FormLayoutInfo.getFormData(widget);
        return layoutData.getAttachment(side);
    }

    public final Dimension getContainerSize() {
        CompositeInfo composite = this.getComposite();
        Rectangle compositeBounds = composite.getModelBounds().getCopy();
        Insets clientAreaInsets = composite.getClientAreaInsets();
        return compositeBounds.crop(clientAreaInsets).getSize();
    }

    public void setQuickAnchors(ControlInfo widget, int sides, boolean relative) throws Exception {
        this.setQuickAnchor(widget, 1, relative, (sides & 1) != 0);
        this.setQuickAnchor(widget, 4, relative, (sides & 4) != 0);
        this.setQuickAnchor(widget, 8, relative, (sides & 8) != 0);
        this.setQuickAnchor(widget, 32, relative, (sides & 0x20) != 0);
    }

    private void setQuickAnchor(ControlInfo widget, int side, boolean relative, boolean hasSide) throws Exception {
        if (hasSide) {
            this.anchorToParent(widget, side, side);
        } else if (relative) {
            this.anchorToParentAsPercent(widget, side);
        } else {
            FormAttachmentInfo attachment = this.getAttachment(widget, side);
            if (!attachment.isVirtual()) {
                attachment.delete();
            }
        }
    }

    public void anchorToParent(ControlInfo control, int controlSide, int parentSide) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(control, controlSide);
        attachment.setControl((ControlInfo)null);
        attachment.setDenominator(100);
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)controlSide);
        Transposer t = new Transposer(!isHorizontal);
        int margin = isHorizontal ? FormUtils.getLayoutMarginLeft((IFormLayoutInfo)this) : FormUtils.getLayoutMarginTop((IFormLayoutInfo)this);
        Rectangle controlBounds = t.t(control.getModelBounds());
        Dimension containerSize = t.t(this.getContainerSize());
        int offset = 0;
        if (!PlacementUtils.isTrailingSide((int)controlSide)) {
            if (PlacementUtils.isTrailingSide((int)parentSide)) {
                attachment.setNumerator(100);
                offset = -(containerSize.width - controlBounds.x) - margin;
            } else {
                attachment.setNumerator(0);
                offset = controlBounds.x - margin;
            }
        } else if (PlacementUtils.isTrailingSide((int)parentSide)) {
            attachment.setNumerator(100);
            offset = -(containerSize.width - controlBounds.right()) - margin;
        } else {
            attachment.setNumerator(0);
            offset = controlBounds.right() - margin;
        }
        attachment.setOffset(offset);
        attachment.write();
    }

    public void anchorToParentAsPercent(ControlInfo control, int controlSide) throws Exception {
        FormAttachmentInfo attachment = this.getAttachment(control, controlSide);
        attachment.setControl((ControlInfo)null);
        attachment.setDenominator(100);
        attachment.setOffset(0);
        boolean isHorizontal = PlacementUtils.isHorizontalSide((int)controlSide);
        Transposer t = new Transposer(!isHorizontal);
        int margin = isHorizontal ? FormUtils.getLayoutMarginLeft((IFormLayoutInfo)this) : FormUtils.getLayoutMarginTop((IFormLayoutInfo)this);
        Rectangle controlBounds = t.t(control.getModelBounds());
        Dimension containerSize = t.t(this.getContainerSize());
        if (!PlacementUtils.isTrailingSide((int)controlSide)) {
            attachment.setNumerator((int)(100.0 * (double)(controlBounds.x - margin) / (double)containerSize.width));
        } else {
            attachment.setNumerator((int)(100.0 * (double)(controlBounds.right() - margin) / (double)containerSize.width));
        }
        attachment.write();
    }

    public FormLayoutPreferences<ControlInfo> getPreferences() {
        return this.preferences;
    }

    public IResource getUnderlyingResource() throws Exception {
        return this.getContext().getFile();
    }
}

