/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.color;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.xwt.XWTMaps;
import org.eclipse.xwt.utils.NamedColorsUtil;

public class ColorSupport {
    private static ColorInfo[] m_systemColors;
    private static ColorInfo[] m_namedColors;

    public static synchronized ColorInfo[] getSystemColors() {
        if (m_systemColors == null) {
            String[] names = XWTMaps.getColorKeys().toArray(new String[0]);
            m_systemColors = new ColorInfo[names.length];
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                int id = XWTMaps.getColor((String)name);
                Color color = PlatformUI.getWorkbench().getDisplay().getSystemColor(id);
                name = StringUtils.removeStart((String)name, (String)"SWT.");
                ColorInfo colorInfo = new ColorInfo(name, color.getRGB());
                colorInfo.setData((Object)name);
                ColorSupport.m_systemColors[i] = colorInfo;
                ++i;
            }
        }
        return m_systemColors;
    }

    public static synchronized ColorInfo[] getNamedColors() {
        if (m_namedColors == null) {
            String[] names = NamedColorsUtil.getColorNames();
            m_namedColors = new ColorInfo[names.length];
            int i = 0;
            while (i < names.length) {
                String name = names[i];
                Color color = NamedColorsUtil.getColor((String)name);
                ColorInfo colorInfo = new ColorInfo(name, color.getRGB());
                colorInfo.setData((Object)name);
                ColorSupport.m_namedColors[i] = colorInfo;
                ++i;
            }
        }
        return m_namedColors;
    }

    private static int getRed(Color color) throws Exception {
        return color.getRed();
    }

    private static int getGreen(Color color) throws Exception {
        return color.getGreen();
    }

    private static int getBlue(Color color) throws Exception {
        return color.getBlue();
    }

    public static ColorInfo createInfo(Color color) throws Exception {
        return new ColorInfo(ColorSupport.getRed(color), ColorSupport.getGreen(color), ColorSupport.getBlue(color));
    }

    public static String toString(Color color) throws Exception {
        return String.valueOf(ColorSupport.getRed(color)) + "," + ColorSupport.getGreen(color) + "," + ColorSupport.getBlue(color);
    }
}

