/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets.menu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.menu.MenuVisualData;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlMenuMenuObject;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.swt.support.MenuSupport;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;
import org.eclipse.wb.internal.xwt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.xwt.model.widgets.XwtLiveManager;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuLiveManager;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuStylePresentation;

public final class MenuInfo
extends WidgetInfo
implements IAdaptable {
    private final MenuInfo m_this = this;
    private final IObjectPresentation m_presentation = new MenuStylePresentation(this);
    private final IMenuPopupInfo m_popupImpl = new MenuPopupImpl();
    private final IMenuInfo m_menuImpl = new MenuImpl();

    public MenuInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.addClipboardSupport();
    }

    private void addClipboardSupport() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                if (object == MenuInfo.this.m_this) {
                    for (MenuItemInfo item : MenuInfo.this.getItems()) {
                        final XmlObjectMemento itemMemento = XmlObjectMemento.createMemento((XmlObjectInfo)item);
                        commands.add(new ClipboardCommand(){
                            private static final long serialVersionUID = 0L;

                            public void execute(XmlObjectInfo object) throws Exception {
                                MenuItemInfo item = (MenuItemInfo)itemMemento.create(object);
                                IMenuPolicy policy = MenuObjectInfoUtils.getMenuInfo((Object)object).getPolicy();
                                policy.commandCreate((Object)item, null);
                                itemMemento.apply();
                            }
                        });
                    }
                }
            }
        });
    }

    public List<MenuItemInfo> getItems() {
        return this.getChildren(MenuItemInfo.class);
    }

    public boolean isBar() {
        return (this.getStyle() & 2) != 0;
    }

    public boolean isPopup() {
        return (this.getStyle() & 8) != 0;
    }

    protected void refresh_afterCreate() throws Exception {
        Object[] items = MenuSupport.getItems((Object)this.getObject());
        if (items.length == 0) {
            MenuSupport.addPlaceholder((Object)this.getObject());
        }
        super.refresh_afterCreate();
    }

    protected void refresh_fetch() throws Exception {
        if (this.getContext().isLiveComponent()) {
            return;
        }
        DisplayEventListener displayListener = (DisplayEventListener)this.getBroadcast(DisplayEventListener.class);
        MenuVisualData visualData = null;
        try {
            displayListener.beforeMessagesLoop();
            visualData = ToolkitSupport.fetchMenuVisualData((Object)this.getObject());
        }
        finally {
            displayListener.afterMessagesLoop();
        }
        this.setModelBounds(visualData.m_menuBounds);
        this.setBounds(visualData.m_menuBounds);
        this.setImage(visualData.m_menuImage);
        List<MenuItemInfo> items = this.getItems();
        int i = 0;
        while (i < items.size()) {
            MenuItemInfo itemInfo = items.get(i);
            itemInfo.setModelBounds((Rectangle)visualData.m_itemBounds.get(i));
            ++i;
        }
        super.refresh_fetch();
    }

    @Override
    protected XwtLiveManager getLiveComponentsManager() {
        return new MenuLiveManager(this);
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    public void commandCreate(WidgetInfo parent) throws Exception {
        Association association = this.isBar() ? Associations.property((String)"menuBar") : Associations.property((String)"menu");
        XmlObjectUtils.add((XmlObjectInfo)this, (Association)association, (XmlObjectInfo)parent, null);
    }

    public void commandMove(WidgetInfo parent) throws Exception {
        XmlObjectUtils.move((XmlObjectInfo)this, (Association)Associations.property((String)"menu"), (XmlObjectInfo)parent, null);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IMenuInfo.class)) {
            return adapter.cast(this.m_menuImpl);
        }
        if (adapter.isAssignableFrom(IMenuPopupInfo.class)) {
            return adapter.cast(this.m_popupImpl);
        }
        return null;
    }

    private abstract class MenuAbstractImpl
    extends XmlMenuMenuObject {
        public MenuAbstractImpl() {
            super((XmlObjectInfo)MenuInfo.this.m_this);
        }
    }

    private final class MenuImpl
    extends MenuAbstractImpl
    implements IMenuInfo,
    IMenuPolicy {
        private MenuImpl() {
        }

        public Object getModel() {
            return MenuInfo.this.isPopup() ? this : MenuInfo.this.m_this;
        }

        public ImageDescriptor getImageDescriptor() {
            return Optional.ofNullable(MenuInfo.this.m_this.getImage()).map(ImageDescriptor::createFromImage).orElse(null);
        }

        public Rectangle getBounds() {
            return MenuInfo.this.m_this.getBounds();
        }

        public boolean isHorizontal() {
            return MenuInfo.this.isBar();
        }

        public List<IMenuItemInfo> getItems() {
            ArrayList items = Lists.newArrayList();
            for (MenuItemInfo item : MenuInfo.this.m_this.getItems()) {
                items.add(MenuObjectInfoUtils.getMenuItemInfo((Object)((Object)item)));
            }
            return items;
        }

        public IMenuPolicy getPolicy() {
            return this;
        }

        public boolean validateCreate(Object newObject) {
            return newObject instanceof MenuItemInfo;
        }

        public boolean validatePaste(final Object mementoObject) {
            return (Boolean)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

                public Boolean runObject() throws Exception {
                    List mementos = (List)mementoObject;
                    for (XmlObjectMemento memento : mementos) {
                        XmlObjectInfo component = memento.create((XmlObjectInfo)((MenuImpl)MenuImpl.this).MenuInfo.this.m_this);
                        if (component instanceof MenuItemInfo) continue;
                        return false;
                    }
                    return true;
                }
            }, (Object)false);
        }

        /*
         * WARNING - void declaration
         */
        public boolean validateMove(Object object) {
            Object object2 = object;
            if (object2 instanceof MenuItemInfo) {
                void item;
                MenuItemInfo menuItemInfo = (MenuItemInfo)((Object)object2);
                MenuItemInfo cfr_ignored_0 = (MenuItemInfo)((Object)object2);
                return !item.isParentOf((ObjectInfo)MenuInfo.this.m_this);
            }
            return false;
        }

        public void commandCreate(Object newObject, Object nextObject) throws Exception {
            MenuItemInfo newItem = (MenuItemInfo)((Object)newObject);
            MenuItemInfo nextItem = (MenuItemInfo)((Object)nextObject);
            XmlObjectUtils.add((XmlObjectInfo)newItem, (Association)Associations.direct(), (XmlObjectInfo)MenuInfo.this.m_this, (XmlObjectInfo)nextItem);
            MenuObjectInfoUtils.setSelectingObject((Object)((Object)newItem));
        }

        public List<?> commandPaste(Object mementoObject, Object nextObject) throws Exception {
            ArrayList pastedObjects = Lists.newArrayList();
            List mementos = (List)mementoObject;
            for (XmlObjectMemento memento : mementos) {
                MenuItemInfo item = (MenuItemInfo)memento.create((XmlObjectInfo)MenuInfo.this.m_this);
                this.commandCreate((Object)item, nextObject);
                memento.apply();
                pastedObjects.add(item);
            }
            return pastedObjects;
        }

        public void commandMove(Object object, Object nextObject) throws Exception {
            MenuItemInfo item = (MenuItemInfo)((Object)object);
            MenuItemInfo nextItem = (MenuItemInfo)((Object)nextObject);
            XmlObjectUtils.move((XmlObjectInfo)item, (Association)Associations.direct(), (XmlObjectInfo)MenuInfo.this.m_this, (XmlObjectInfo)nextItem);
            MenuObjectInfoUtils.setSelectingObject((Object)((Object)item));
        }
    }

    private final class MenuPopupImpl
    extends MenuAbstractImpl
    implements IMenuPopupInfo {
        private MenuPopupImpl() {
        }

        public Object getModel() {
            return MenuInfo.this.m_this;
        }

        public ImageDescriptor getImageDescriptor() {
            return (ImageDescriptor)ExecutionUtils.runObjectLog(() -> MenuInfo.this.getPresentation().getIcon(), (Object)MenuInfo.this.getDescription().getIcon());
        }

        public Rectangle getBounds() {
            ImageData imageData = this.getImageDescriptor().getImageData(100);
            return new Rectangle(0, 0, imageData.width, imageData.height);
        }

        public IMenuInfo getMenu() {
            return MenuInfo.this.m_menuImpl;
        }

        public IMenuPolicy getPolicy() {
            return IMenuPolicy.NOOP;
        }
    }
}

