/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;

public final class BorderOfChildLayoutRequestValidator
implements ILayoutRequestValidator {
    public static final ILayoutRequestValidator INSTANCE = new BorderOfChildLayoutRequestValidator();

    private BorderOfChildLayoutRequestValidator() {
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        return BorderOfChildLayoutRequestValidator.isTargetingToHost_containerSelected(host, request);
    }

    @Override
    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        return BorderOfChildLayoutRequestValidator.isTargetingToHost_containerSelected(host, request);
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        if (request.isEraseFeedback()) {
            return true;
        }
        EditPart editPart = host;
        if (editPart instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
            GraphicalEditPart cfr_ignored_0 = (GraphicalEditPart)editPart;
            if (request.getEditParts().get(0).getParent() == host.getParent()) {
                void graphicalHost;
                return BorderOfChildLayoutRequestValidator.isTargeting_innerPartOfHost((GraphicalEditPart)graphicalHost, request);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isTargetingToHost_containerSelected(EditPart host, IDropRequest request) {
        EditPart editPart = host;
        if (editPart instanceof GraphicalEditPart) {
            void graphicalHost;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
            GraphicalEditPart cfr_ignored_0 = (GraphicalEditPart)editPart;
            if (BorderOfChildLayoutRequestValidator.isTransparentOnBorders((GraphicalEditPart)graphicalHost)) {
                return BorderOfChildLayoutRequestValidator.isTargeting_innerPartOfHost((GraphicalEditPart)graphicalHost, request);
            }
        }
        return true;
    }

    private static boolean isTargeting_innerPartOfHost(GraphicalEditPart host, IDropRequest request) {
        Figure hostFigure = host.getFigure();
        Point location = request.getLocation().getCopy();
        FigureUtils.translateAbsoluteToFigure2(hostFigure, (Translatable)location);
        Rectangle hostClientArea = hostFigure.getClientArea();
        return hostClientArea.getExpanded(-3, -3).contains(location);
    }

    private static boolean isTransparentOnBorders(GraphicalEditPart host) {
        Object hostModel = host.getModel();
        IParametersProvider provider = GlobalState.getParametersProvider();
        if (provider.hasTrueParameter(hostModel, "GEF.transparentOnBorders.always")) {
            return true;
        }
        return BorderOfChildLayoutRequestValidator.isChildOf_selectedEditPart(host);
    }

    private static boolean isChildOf_selectedEditPart(EditPart child) {
        List<EditPart> selectedEditParts = child.getViewer().getSelectedEditParts();
        return selectedEditParts.size() == 1 && BorderOfChildLayoutRequestValidator.areParentChild(selectedEditParts.get(0), child);
    }

    private static boolean areParentChild(EditPart parent, EditPart child) {
        EditPart part = child.getParent();
        while (part != null) {
            if (part == parent) {
                return true;
            }
            part = part.getParent();
        }
        return false;
    }
}

