/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.internal.draw2d.CustomTooltipManager;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.RootFigure;
import org.eclipse.wb.internal.draw2d.TargetFigureFindVisitor;

public class EventManager
implements MouseListener,
MouseMoveListener,
MouseTrackListener {
    public static final int ANY_BUTTON = 0x380000;
    private final FigureCanvas m_canvas;
    private final RootFigure m_root;
    private MouseEvent m_currentEvent;
    private Figure m_cursorFigure;
    private Figure m_captureFigure;
    private Figure m_targetFigure;
    private Cursor m_cursor;
    private static String FLAG_DELAY_EVENTS = "Flag that events to this Control should be delayed";
    private static String KEY_DELAYED_EVENTS = "List of delayed events";

    public EventManager(FigureCanvas canvas) {
        this.m_canvas = canvas;
        this.m_root = this.m_canvas.getRootFigure();
        new CustomTooltipManager(canvas, this);
        this.m_canvas.addMouseListener(this);
        this.m_canvas.addMouseMoveListener(this);
        this.m_canvas.addMouseTrackListener(this);
    }

    public void updateCursor() {
        if (this.m_cursorFigure == null) {
            this.setCursor(null);
        } else {
            this.setCursor(this.m_cursorFigure.getCursor());
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.m_cursor == null ? cursor == null : this.m_cursor == cursor || this.m_cursor.equals((Object)cursor)) {
            return;
        }
        this.m_cursor = cursor;
        this.m_canvas.setCursor(this.m_cursor);
    }

    protected void updateFigureToolTipText() {
        if (this.m_cursorFigure == null) {
            this.m_canvas.setToolTipText(null);
        } else {
            this.m_canvas.setToolTipText(this.m_cursorFigure.getToolTipText());
        }
    }

    private void setFigureUnderCursor(Figure figure, org.eclipse.swt.events.MouseEvent event) {
        if (this.m_cursorFigure != figure) {
            this.sendEvent(() -> this.m_targetFigure.handleMouseExited(this.m_currentEvent), event);
            this.m_cursorFigure = figure;
            this.sendEvent(() -> this.m_targetFigure.handleMouseEntered(this.m_currentEvent), event);
            this.updateCursor();
            this.updateFigureToolTipText();
        }
    }

    public final Figure getCursorFigure() {
        return this.m_cursorFigure;
    }

    protected final void updateFigureUnderCursor(org.eclipse.swt.events.MouseEvent event) {
        TargetFigureFindVisitor visitor = new TargetFigureFindVisitor(this.m_canvas, event.x, event.y);
        this.m_root.accept(visitor, false);
        this.setFigureUnderCursor(visitor.getTargetFigure(), event);
    }

    public void setCapture(Figure captureFigure) {
        this.m_captureFigure = captureFigure;
    }

    protected boolean isEventConsumed() {
        return this.m_currentEvent != null && this.m_currentEvent.isConsumed();
    }

    public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseDoubleClicked(this.m_currentEvent), event);
    }

    public void mouseDown(org.eclipse.swt.events.MouseEvent event) {
        if (this.m_canvas.getToolTipText() != null) {
            this.m_canvas.setToolTipText(null);
        }
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMousePressed(this.m_currentEvent), event);
    }

    public void mouseUp(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseReleased(this.m_currentEvent), event);
    }

    public void mouseMove(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseMoved(this.m_currentEvent), event);
    }

    private <T> void sendEvent(Runnable delayEvent, org.eclipse.swt.events.MouseEvent e) {
        this.m_currentEvent = null;
        Figure figure = this.m_targetFigure = this.m_captureFigure == null ? this.m_cursorFigure : this.m_captureFigure;
        if (this.m_targetFigure != null) {
            this.m_currentEvent = new MouseEvent(null, (IFigure)this.m_targetFigure, e);
            Rectangle bounds = this.m_targetFigure.getBounds();
            Point location = new Point(this.m_currentEvent.x - bounds.x, this.m_currentEvent.y - bounds.y);
            location.x += this.m_canvas.getHorizontalScrollModel().getSelection();
            location.y += this.m_canvas.getVerticalScrollModel().getSelection();
            FigureUtils.translateAbsoluteToFigure(this.m_targetFigure, (Translatable)location);
            this.m_currentEvent.x = location.x;
            this.m_currentEvent.y = location.y;
            EventManager.delayEvent(e.widget, delayEvent);
        }
    }

    public void mouseEnter(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseEntered(this.m_currentEvent), event);
    }

    public void mouseExit(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseExited(this.m_currentEvent), event);
    }

    public void mouseHover(org.eclipse.swt.events.MouseEvent event) {
        this.updateFigureUnderCursor(event);
        this.sendEvent(() -> this.m_targetFigure.handleMouseHover(this.m_currentEvent), event);
    }

    public static void delayEvents(Control control, boolean delay) {
        if (delay) {
            control.setData(FLAG_DELAY_EVENTS, (Object)Boolean.TRUE);
        } else {
            control.setData(FLAG_DELAY_EVENTS, null);
        }
    }

    private static void delayEvent(Widget widget, Runnable delayEvent) {
        if (widget.isDisposed() || widget.getData(FLAG_DELAY_EVENTS) == null) {
            delayEvent.run();
        } else {
            ArrayList<Runnable> eventQueue = (ArrayList<Runnable>)widget.getData(KEY_DELAYED_EVENTS);
            if (eventQueue == null) {
                eventQueue = new ArrayList<Runnable>();
                widget.setData(KEY_DELAYED_EVENTS, eventQueue);
            }
            eventQueue.add(delayEvent);
        }
    }

    public static void runDelayedEvents(Control control) {
        List eventQueue = (List)control.getData(KEY_DELAYED_EVENTS);
        control.setData(KEY_DELAYED_EVENTS, null);
        if (eventQueue != null) {
            for (Runnable event : eventQueue) {
                event.run();
            }
        }
    }
}

