/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.grid;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.generation.statement.PureFlatStatementGenerator;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.layout.GeneralLayoutData;
import org.eclipse.wb.internal.core.model.util.grid.GridAlignmentHelper;
import org.eclipse.wb.internal.core.model.variable.EmptyPureVariableSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataClipboardCommand;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutAssistant;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutConverter;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IPreferenceConstants;
import org.eclipse.wb.internal.swt.model.layout.grid.actions.SelectionActionsSupport;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.GridLayoutSupport;
import org.eclipse.wb.internal.swt.support.LabelSupport;

public class GridLayoutInfo
extends LayoutInfo
implements IPreferenceConstants,
IGridLayoutInfo<ControlInfo> {
    private boolean m_useObjectColumnCount;
    private final Set<Object> m_controlsImplicit = Sets.newHashSet();
    private boolean m_replaceWithFillers = true;
    private boolean m_removeEmptyColumnsRows = true;
    private GridDataInfo m_removingGridData;
    private final List<GridColumnInfo<ControlInfo>> m_columns = Lists.newArrayList();
    private final List<GridRowInfo<ControlInfo>> m_rows = Lists.newArrayList();
    public static final int VIRTUAL_SIZE = 25;
    public static final int VIRTUAL_GAP = 5;
    private IGridInfo m_gridInfo;
    private int[] m_columnOrigins;
    private int[] m_rowOrigins;
    private int[] m_columnWidths;
    private int[] m_rowHeights;
    static final BiMap<GeneralLayoutData.HorizontalAlignment, Integer> m_horizontalAlignmentMap = ImmutableBiMap.of((Object)GeneralLayoutData.HorizontalAlignment.LEFT, (Object)16384, (Object)GeneralLayoutData.HorizontalAlignment.CENTER, (Object)0x1000000, (Object)GeneralLayoutData.HorizontalAlignment.RIGHT, (Object)131072, (Object)GeneralLayoutData.HorizontalAlignment.FILL, (Object)4);
    static final BiMap<GeneralLayoutData.VerticalAlignment, Integer> m_verticalAlignmentMap = ImmutableBiMap.of((Object)GeneralLayoutData.VerticalAlignment.TOP, (Object)128, (Object)GeneralLayoutData.VerticalAlignment.CENTER, (Object)0x1000000, (Object)GeneralLayoutData.VerticalAlignment.BOTTOM, (Object)1024, (Object)GeneralLayoutData.VerticalAlignment.FILL, (Object)4);

    public GridLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        new GridLayoutAssistant(this);
        new SelectionActionsSupport<ControlInfo>(this);
    }

    @Override
    public void onSet() throws Exception {
        super.onSet();
        GridLayoutConverter.convert(this.getComposite(), this);
    }

    @Override
    protected void onDelete() throws Exception {
        for (ControlInfo control : this.getControls()) {
            if (!this.isFiller(control)) continue;
            control.delete();
        }
        super.onDelete();
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof ControlInfo) {
                    visible[0] = visible[0] & !GridLayoutInfo.this.isFiller((ControlInfo)object);
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildGraphical(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof ControlInfo) {
                    visible[0] = visible[0] & !GridLayoutInfo.this.isFiller((ControlInfo)object);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isManagedObject(Object object) {
        if (!super.isManagedObject(object)) {
            return false;
        }
        Object object2 = object;
        if (object2 instanceof ControlInfo) {
            void control;
            ControlInfo controlInfo = (ControlInfo)object2;
            ControlInfo cfr_ignored_0 = (ControlInfo)object2;
            if (GridLayoutInfo.getGridData((ControlInfo)control).getExclude()) {
                return false;
            }
        }
        return true;
    }

    public void refresh_dispose() throws Exception {
        this.m_gridInfo = null;
        super.refresh_dispose();
    }

    protected void refresh_afterCreate() throws Exception {
        super.refresh_afterCreate();
        this.prepareImplicitControls();
        this.fixEmptyColumns();
    }

    private void prepareImplicitControls() {
        Object[] controlsAll;
        this.m_controlsImplicit.clear();
        HashSet controlsWithModel = Sets.newHashSet();
        for (ControlInfo control : this.getControls()) {
            controlsWithModel.add(control.getObject());
        }
        Object compositeObject = this.getComposite().getObject();
        Object[] objectArray = controlsAll = ContainerSupport.getChildren(compositeObject);
        int n = controlsAll.length;
        int n2 = 0;
        while (n2 < n) {
            Object control = objectArray[n2];
            if (!controlsWithModel.contains(control)) {
                this.m_controlsImplicit.add(control);
            }
            ++n2;
        }
    }

    private void fixEmptyColumns() throws Exception {
        this.fetchGridDataValues();
        ControlInfo[][] grid = this.getControlsGrid();
        int columnCount = grid.length != 0 ? grid[0].length : 0;
        this.m_columnWidths = GridLayoutSupport.getColumnWidths(this.getObject());
        int column = 0;
        while (column < columnCount) {
            int width = this.m_columnWidths[column];
            if (width == 0) {
                int row = 0;
                while (row < grid.length) {
                    ControlInfo control = grid[row][column];
                    if (control != null && this.isFiller(control)) {
                        LabelSupport.setText(control.getObject(), "      ");
                    }
                    ++row;
                }
            }
            ++column;
        }
    }

    private void fetchGridDataValues() throws Exception {
        for (ControlInfo control : this.getControls()) {
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            gridData.refresh_fetch();
        }
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        Object layoutObject = this.getObject();
        this.m_columnOrigins = GridLayoutSupport.getColumnOrigins(layoutObject);
        this.m_rowOrigins = GridLayoutSupport.getRowOrigins(layoutObject);
        this.m_columnWidths = GridLayoutSupport.getColumnWidths(layoutObject);
        this.m_rowHeights = GridLayoutSupport.getRowHeights(layoutObject);
    }

    protected void refresh_finish() throws Exception {
        super.refresh_finish();
        try {
            this.m_useObjectColumnCount = true;
            this.fixGrid();
        }
        finally {
            this.m_useObjectColumnCount = false;
        }
    }

    void setRemoveEmptyColumnsRows(boolean removeEmptyColumnsRows) {
        this.m_removeEmptyColumnsRows = removeEmptyColumnsRows;
    }

    @Override
    protected Object getDefaultVirtualDataObject() throws Exception {
        return GridLayoutSupport.createGridData();
    }

    @Override
    protected void onControlRemoveBefore(ControlInfo control) throws Exception {
        this.m_removingGridData = GridLayoutInfo.getGridData(control);
        super.onControlRemoveBefore(control);
    }

    @Override
    protected void onControlRemoveAfter(ControlInfo control) throws Exception {
        if (this.m_replaceWithFillers && !this.isFiller(control)) {
            GridDataInfo gridData = this.m_removingGridData;
            int x = gridData.x;
            while (x < gridData.x + gridData.width) {
                int y = gridData.y;
                while (y < gridData.y + gridData.height) {
                    this.addFiller(x, y);
                    ++y;
                }
                ++x;
            }
            if (this.m_removeEmptyColumnsRows) {
                this.deleteEmptyColumnsRows(this.m_removingGridData);
            }
            this.m_removingGridData = null;
        }
        super.onControlRemoveAfter(control);
    }

    @Override
    public IGridDataInfo getGridData2(ControlInfo control) {
        return GridLayoutInfo.getGridData(control);
    }

    public static GridDataInfo getGridData(ControlInfo control) {
        return (GridDataInfo)GridLayoutInfo.getLayoutData(control);
    }

    void deleteEmptyColumnsRows(GridDataInfo removingData) throws Exception {
        this.deleteEmptyColumns(removingData);
        this.deleteEmptyRows(removingData);
    }

    private void deleteEmptyColumns(GridDataInfo removingData) throws Exception {
        ControlInfo[][] grid = this.getControlsGrid();
        boolean deleteOnlyIfIsRemovingColumn = false;
        int column = grid[0].length - 1;
        while (column >= 0) {
            boolean isRemovingColumn = removingData != null && removingData.x <= column && column < removingData.x + removingData.width;
            boolean isEmpty = true;
            int row = 0;
            while (row < grid.length) {
                ControlInfo control = grid[row][column];
                isEmpty &= this.isFiller(control);
                ++row;
            }
            if (isEmpty && (!deleteOnlyIfIsRemovingColumn || isRemovingColumn)) {
                this.command_deleteColumn(column, false);
            } else {
                deleteOnlyIfIsRemovingColumn = true;
            }
            --column;
        }
    }

    private void deleteEmptyRows(GridDataInfo removingData) throws Exception {
        ControlInfo[][] grid = this.getControlsGrid();
        boolean deleteOnlyIfIsRemovingRow = false;
        int row = grid.length - 1;
        while (row >= 0) {
            boolean isRemovingRow = removingData != null && removingData.y <= row && row < removingData.y + removingData.height;
            boolean isEmpty = true;
            int column = 0;
            while (column < grid[row].length) {
                ControlInfo control = grid[row][column];
                isEmpty &= this.isFiller(control);
                ++column;
            }
            if (isEmpty && (!deleteOnlyIfIsRemovingRow || isRemovingRow)) {
                this.command_deleteRow(row, false);
            } else {
                deleteOnlyIfIsRemovingRow = true;
            }
            --row;
        }
    }

    @Override
    public void command_deleteColumn(int column, boolean deleteEmptyDims) throws Exception {
        int columnCount = this.getControlsGridSize().width;
        this.m_replaceWithFillers = false;
        try {
            for (ControlInfo control : this.getControls()) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(control);
                if (gridData.x == column) {
                    control.delete();
                    continue;
                }
                if (gridData.x > column) {
                    --gridData.x;
                    continue;
                }
                if (gridData.x + gridData.width <= column) continue;
                gridData.setHorizontalSpan(gridData.width - 1);
            }
        }
        finally {
            this.m_replaceWithFillers = true;
        }
        if (columnCount >= 2) {
            this.getPropertyByTitle("numColumns").setValue((Object)(columnCount - 1));
        }
        if (deleteEmptyDims) {
            this.deleteEmptyColumnsRows(null);
        }
    }

    @Override
    public void command_deleteRow(int row, boolean deleteEmptyDims) throws Exception {
        this.m_replaceWithFillers = false;
        try {
            for (ControlInfo control : this.getControls()) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(control);
                if (gridData.y == row) {
                    control.delete();
                    continue;
                }
                if (gridData.y > row) {
                    --gridData.y;
                    continue;
                }
                if (gridData.y + gridData.height <= row) continue;
                gridData.setVerticalSpan(gridData.height - 1);
            }
        }
        finally {
            this.m_replaceWithFillers = true;
        }
        if (deleteEmptyDims) {
            this.deleteEmptyColumnsRows(null);
        }
    }

    @Override
    public void command_MOVE_COLUMN(int fromIndex, int toIndex) throws Exception {
        this.getColumns();
        GridColumnInfo<ControlInfo> column = this.m_columns.remove(fromIndex);
        if (fromIndex < toIndex) {
            this.m_columns.add(toIndex - 1, column);
        } else {
            this.m_columns.add(toIndex, column);
        }
        int i = 0;
        while (i < this.m_columns.size()) {
            this.m_columns.get(i).setIndex(i);
            ++i;
        }
        this.prepareCell(toIndex, true, -1, false);
        if (toIndex < fromIndex) {
            ++fromIndex;
        }
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            if (gridData.x != fromIndex) continue;
            this.command_setCells(control, new Rectangle(toIndex, gridData.y, 1, gridData.height), true);
        }
        this.command_deleteColumn(fromIndex, false);
        this.deleteEmptyColumnsRows(null);
    }

    @Override
    public void command_MOVE_ROW(int fromIndex, int toIndex) throws Exception {
        this.getRows();
        GridRowInfo<ControlInfo> row = this.m_rows.remove(fromIndex);
        if (fromIndex < toIndex) {
            this.m_rows.add(toIndex - 1, row);
        } else {
            this.m_rows.add(toIndex, row);
        }
        int i = 0;
        while (i < this.m_rows.size()) {
            this.m_rows.get(i).setIndex(i);
            ++i;
        }
        this.prepareCell(-1, false, toIndex, true);
        if (toIndex < fromIndex) {
            ++fromIndex;
        }
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            if (gridData.y != fromIndex) continue;
            this.command_setCells(control, new Rectangle(gridData.x, toIndex, gridData.width, 1), true);
        }
        this.command_deleteRow(fromIndex, false);
        this.deleteEmptyColumnsRows(null);
    }

    @Override
    public void command_normalizeSpanning() throws Exception {
        ExecutionUtils.run((ObjectInfo)this, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridLayoutInfo.this.command_normalizeSpanning0();
            }
        });
    }

    private void command_normalizeSpanning0() throws Exception {
        Dimension gridSize = this.getControlsGridSize();
        boolean[] filledColumns = new boolean[gridSize.width];
        boolean[] filledRows = new boolean[gridSize.height];
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            filledColumns[gridData.x] = true;
            filledRows[gridData.y] = true;
        }
        int column = filledColumns.length - 1;
        while (column >= 0) {
            if (!filledColumns[column]) {
                this.command_deleteColumn(column, false);
            }
            --column;
        }
        int row = filledRows.length - 1;
        while (row >= 0) {
            if (!filledRows[row]) {
                this.command_deleteRow(row, false);
            }
            --row;
        }
    }

    int getNumColumns() {
        if (this.getObject() == null) {
            return 1;
        }
        return GridLayoutSupport.getNumColumns(this.getObject());
    }

    @Override
    public List<GridColumnInfo<ControlInfo>> getColumns() {
        Dimension size = this.getControlsGridSize();
        if (this.m_columns.size() != size.width) {
            this.m_columns.clear();
            int i = 0;
            while (i < size.width) {
                GridColumnInfo<ControlInfo> column = new GridColumnInfo<ControlInfo>(this);
                column.setIndex(i);
                this.m_columns.add(column);
                ++i;
            }
        }
        return this.m_columns;
    }

    @Override
    public List<GridRowInfo<ControlInfo>> getRows() {
        Dimension size = this.getControlsGridSize();
        if (this.m_rows.size() != size.height) {
            this.m_rows.clear();
            int i = 0;
            while (i < size.height) {
                GridRowInfo<ControlInfo> row = new GridRowInfo<ControlInfo>(this);
                row.setIndex(i);
                this.m_rows.add(row);
                ++i;
            }
        }
        return this.m_rows;
    }

    @Override
    public boolean canChangeDimensions() {
        if (this.getCreationSupport() instanceof ConstructorCreationSupport) {
            return true;
        }
        return this.m_controlsImplicit.isEmpty();
    }

    @Override
    public boolean isExplicitRow(int row) {
        return row >= this.getImplicitGridSize().height;
    }

    @Override
    public void command_CREATE(ControlInfo newControl, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.command_CREATE(newControl, null);
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(newControl, new Rectangle(column, row, 1, 1), false);
            this.doAutomaticAlignment(newControl);
        }
        finally {
            this.endEdit();
        }
    }

    @Override
    public void command_MOVE(ControlInfo control, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(control, new Rectangle(column, row, 1, 1), true);
            this.deleteEmptyColumnsRows(null);
        }
        finally {
            this.endEdit();
        }
    }

    @Override
    public void command_ADD(ControlInfo control, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.command_MOVE(control, null);
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(control, new Rectangle(column, row, 1, 1), false);
        }
        finally {
            this.endEdit();
        }
    }

    void prepareCell(int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        int i;
        Dimension gridSize = this.getControlsGridSize();
        int columnCount = gridSize.width;
        int rowCount = gridSize.height;
        int newColumnCount = Math.max(columnCount, 1 + column);
        int newRowCount = Math.max(rowCount, 1 + row);
        int newRow = rowCount;
        while (newRow <= row) {
            int columnIndex = 0;
            while (columnIndex < newColumnCount) {
                this.addFiller(columnIndex, newRow);
                ++columnIndex;
            }
            ++newRow;
        }
        this.getPropertyByTitle("numColumns").setValue((Object)newColumnCount);
        int newColumn = columnCount;
        while (newColumn <= column) {
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                this.addFiller(newColumn, rowIndex);
                ++rowIndex;
            }
            ++newColumn;
        }
        columnCount = newColumnCount;
        rowCount = newRowCount;
        if (insertRow) {
            ++rowCount;
            boolean[] columnsToIgnore = new boolean[columnCount];
            for (ControlInfo control : this.getControls()) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(control);
                if (gridData.y >= row) {
                    ++gridData.y;
                    continue;
                }
                if (gridData.y + gridData.height <= row) continue;
                gridData.setVerticalSpan(gridData.height + 1);
                i = gridData.x;
                while (i < gridData.x + gridData.width) {
                    columnsToIgnore[i] = true;
                    ++i;
                }
            }
            int i2 = 0;
            while (i2 < columnCount) {
                if (!columnsToIgnore[i2]) {
                    this.addFiller(i2, row);
                }
                ++i2;
            }
        }
        if (insertColumn) {
            boolean[] rowsToIgnore = new boolean[rowCount];
            for (ControlInfo control : this.getControls()) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(control);
                if (gridData.x >= column) {
                    ++gridData.x;
                    continue;
                }
                if (gridData.x + gridData.width <= column) continue;
                gridData.setHorizontalSpan(gridData.width + 1);
                i = gridData.y;
                while (i < gridData.y + gridData.height) {
                    rowsToIgnore[i] = true;
                    ++i;
                }
            }
            this.getPropertyByTitle("numColumns").setValue((Object)(columnCount + 1));
            int i3 = 0;
            while (i3 < rowCount) {
                if (!rowsToIgnore[i3]) {
                    this.addFiller(column, i3);
                }
                ++i3;
            }
        }
    }

    @Override
    public void command_setCells(ControlInfo control, Rectangle cells, boolean forMove) throws Exception {
        Point cell;
        int y;
        int x;
        GridDataInfo gridData = GridLayoutInfo.getGridData(control);
        ControlInfo[][] grid = this.getControlsGrid();
        HashSet cellsToAddFillers = Sets.newHashSet();
        HashSet cellsToRemoveFillers = Sets.newHashSet();
        if (forMove) {
            x = gridData.x;
            while (x < gridData.x + gridData.width) {
                y = gridData.y;
                while (y < gridData.y + gridData.height) {
                    cell = new Point(x, y);
                    cellsToAddFillers.add(cell);
                    ++y;
                }
                ++x;
            }
        }
        x = cells.x;
        while (x < cells.right()) {
            y = cells.y;
            while (y < cells.bottom()) {
                cell = new Point(x, y);
                cellsToAddFillers.remove(cell);
                if (this.isFiller(grid[y][x])) {
                    cellsToRemoveFillers.add(cell);
                }
                ++y;
            }
            ++x;
        }
        this.startEdit();
        try {
            if (gridData.x != cells.x || gridData.y != cells.y) {
                gridData.x = cells.x;
                gridData.y = cells.y;
                ControlInfo reference = this.getReferenceControl(cells.y, cells.x, control);
                this.command_MOVE(control, reference);
            }
            gridData.setHorizontalSpan(cells.width);
            gridData.setVerticalSpan(cells.height);
            for (Point cell2 : cellsToRemoveFillers) {
                ControlInfo filler = grid[cell2.y][cell2.x];
                filler.delete();
            }
            for (Point cell3 : cellsToAddFillers) {
                this.addFiller(cell3.x, cell3.y);
            }
        }
        finally {
            this.endEdit();
        }
    }

    @Override
    public void command_setSizeHint(ControlInfo control, boolean horizontal, Dimension size) throws Exception {
        this.startEdit();
        try {
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            if (horizontal) {
                gridData.setWidthHint(size.width);
            } else {
                gridData.setHeightHint(size.height);
            }
        }
        finally {
            this.endEdit();
        }
    }

    private Dimension getControlsGridSize() {
        int columnCount = 0;
        int rowCount = 0;
        if (this.m_useObjectColumnCount) {
            columnCount = this.getNumColumns();
        }
        Dimension implicitGridSize = this.getImplicitGridSize();
        columnCount = Math.max(columnCount, implicitGridSize.width);
        rowCount = implicitGridSize.height;
        for (ControlInfo control : this.getControls()) {
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            columnCount = Math.max(columnCount, gridData.x + gridData.width);
            rowCount = Math.max(rowCount, gridData.y + gridData.height);
        }
        return new Dimension(columnCount, rowCount);
    }

    private Dimension getImplicitGridSize() {
        int columnCount = 0;
        int rowCount = 0;
        for (Object control : this.m_controlsImplicit) {
            Rectangle cells = this.getImplicitControlCells(control);
            columnCount = Math.max(columnCount, cells.right());
            rowCount = Math.max(rowCount, cells.bottom());
        }
        return new Dimension(columnCount, rowCount);
    }

    private Rectangle getImplicitControlCells(Object control) {
        Object layout = this.getObject();
        Point xy = GridLayoutSupport.getXY(layout, control);
        if (xy == null) {
            return new Rectangle();
        }
        Dimension wh = GridLayoutSupport.getWH(layout, control);
        return new Rectangle(xy.x, xy.y, wh.width, wh.height);
    }

    private ControlInfo[][] getControlsGrid() throws Exception {
        Dimension gridSize = this.getControlsGridSize();
        ControlInfo[][] grid = new ControlInfo[gridSize.height][];
        int rowIndex = 0;
        while (rowIndex < grid.length) {
            grid[rowIndex] = new ControlInfo[gridSize.width];
            ++rowIndex;
        }
        for (ControlInfo control : this.getControls()) {
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            Rectangle cells = new Rectangle(gridData.x, gridData.y, gridData.width, gridData.height);
            int x = cells.x;
            while (x < cells.right()) {
                int y = cells.y;
                while (y < cells.bottom()) {
                    if (x != -1 && y != -1) {
                        grid[y][x] = control;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return grid;
    }

    @Override
    public void fixGrid() throws Exception {
        if (JavaInfoUtils.isImplicitlyCreated((JavaInfo)this)) {
            return;
        }
        ControlInfo[][] grid = this.getControlsGrid();
        int row = 0;
        while (row < grid.length) {
            int column = 0;
            while (column < grid[row].length) {
                if (this.isEmptyCell(grid, row, column)) {
                    this.addFiller(column, row);
                }
                ++column;
            }
            ++row;
        }
    }

    private boolean isEmptyCell(ControlInfo[][] grid, int row, int column) {
        Object layoutObject = this.getObject();
        for (Object control : this.m_controlsImplicit) {
            Point point = GridLayoutSupport.getXY(layoutObject, control);
            if (point == null || point.x != column || point.y != row) continue;
            return false;
        }
        return grid[row][column] == null;
    }

    private ControlInfo getReferenceControl(int row, int column, ControlInfo exclude) throws Exception {
        for (ControlInfo control : this.getControls()) {
            if (control == exclude) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            if (gridData.y <= row && (gridData.y != row || gridData.x < column)) continue;
            return control;
        }
        return null;
    }

    private void addFiller(int column, int row) throws Exception {
        ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(null, false);
        ControlInfo filler = (ControlInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.getEditor(), LabelSupport.getLabelClass(), (CreationSupport)creationSupport);
        ControlInfo reference = this.getReferenceControl(row, column, null);
        JavaInfoUtils.add((JavaInfo)filler, (VariableSupport)new EmptyPureVariableSupport((JavaInfo)filler), (StatementGenerator)PureFlatStatementGenerator.INSTANCE, null, (JavaInfo)this.getComposite(), (JavaInfo)reference);
        GridDataInfo gridData = GridLayoutInfo.getGridData(filler);
        gridData.x = column;
        gridData.y = row;
    }

    private void doAutomaticAlignment(ControlInfo control) throws Exception {
        final IPreferenceStore preferences = this.getDescription().getToolkit().getPreferences();
        GridAlignmentHelper.doAutomaticAlignment((IAbstractComponentInfo)control, (GridAlignmentHelper.IAlignmentProcessor)new GridAlignmentHelper.IAlignmentProcessor<ControlInfo>(){

            public boolean grabEnabled() {
                return preferences.getBoolean("GridLayout.enableGrab");
            }

            public boolean rightEnabled() {
                return preferences.getBoolean("GridLayout.enableRightAlignment");
            }

            public ControlInfo getComponentAtLeft(ControlInfo component) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(component);
                return GridLayoutInfo.this.getControlAt(gridData.x - 1, gridData.y);
            }

            public ControlInfo getComponentAtRight(ControlInfo component) {
                GridDataInfo gridData = GridLayoutInfo.getGridData(component);
                return GridLayoutInfo.this.getControlAt(gridData.x + 1, gridData.y);
            }

            public void setGrabFill(ControlInfo component, boolean horizontal) throws Exception {
                GridDataInfo gridData = GridLayoutInfo.getGridData(component);
                if (horizontal) {
                    gridData.setHorizontalGrab(true);
                    gridData.setHorizontalAlignment(4);
                } else {
                    gridData.setVerticalGrab(true);
                    gridData.setVerticalAlignment(4);
                }
            }

            public void setRightAlignment(ControlInfo component) throws Exception {
                GridDataInfo gridData = GridLayoutInfo.getGridData(component);
                gridData.setHorizontalAlignment(131072);
            }
        });
    }

    private ControlInfo getControlAt(int x, int y) {
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            if (gridData.x != x || gridData.y != y) continue;
            return control;
        }
        return null;
    }

    @Override
    public IGridInfo getGridInfo() {
        if (this.m_gridInfo == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    GridLayoutInfo.this.createGridInfo();
                }
            });
        }
        return this.m_gridInfo;
    }

    public int[] getColumnOrigins() {
        return this.m_columnOrigins;
    }

    public int[] getRowOrigins() {
        return this.m_rowOrigins;
    }

    private void createGridInfo() throws Exception {
        Rectangle cells;
        final Interval[] columnIntervals = GridLayoutInfo.getIntervals(this.m_columnOrigins, this.m_columnWidths);
        final Interval[] rowIntervals = GridLayoutInfo.getIntervals(this.m_rowOrigins, this.m_rowHeights);
        final HashMap componentToCells = Maps.newHashMap();
        final HashMap occupiedCells = Maps.newHashMap();
        for (ControlInfo controlInfo : this.getControls()) {
            if (this.isFiller(controlInfo)) continue;
            GridDataInfo gridData = GridLayoutInfo.getGridData(controlInfo);
            cells = new Rectangle(gridData.x, gridData.y, gridData.width, gridData.height);
            componentToCells.put(controlInfo, cells);
            this.fillOccupiedCells(occupiedCells, controlInfo, cells);
        }
        for (Object object : this.m_controlsImplicit) {
            cells = this.getImplicitControlCells(object);
            this.fillOccupiedCells(occupiedCells, this.getComposite(), cells);
        }
        this.m_gridInfo = new IGridInfo(){

            public int getColumnCount() {
                return columnIntervals.length;
            }

            public int getRowCount() {
                return rowIntervals.length;
            }

            public Interval[] getColumnIntervals() {
                return columnIntervals;
            }

            public Interval[] getRowIntervals() {
                return rowIntervals;
            }

            public Rectangle getComponentCells(IAbstractComponentInfo component) {
                Assert.instanceOf(ControlInfo.class, (Object)component);
                return (Rectangle)componentToCells.get(component);
            }

            public Rectangle getCellsRectangle(Rectangle cells) {
                int x = columnIntervals[cells.x].begin();
                int y = rowIntervals[cells.y].begin();
                int w = columnIntervals[cells.right() - 1].end() - x;
                int h = rowIntervals[cells.bottom() - 1].end() - y;
                return new Rectangle(x, y, w, h);
            }

            public boolean isRTL() {
                return GridLayoutInfo.this.getComposite().isRTL();
            }

            public Insets getInsets() {
                return GridLayoutInfo.this.getComposite().getClientAreaInsets2();
            }

            public boolean hasVirtualColumns() {
                return true;
            }

            public int getVirtualColumnSize() {
                return 25;
            }

            public int getVirtualColumnGap() {
                return 5;
            }

            public boolean hasVirtualRows() {
                return true;
            }

            public int getVirtualRowSize() {
                return 25;
            }

            public int getVirtualRowGap() {
                return 5;
            }

            public IAbstractComponentInfo getOccupied(int column, int row) {
                return (IAbstractComponentInfo)occupiedCells.get(new Point(column, row));
            }
        };
    }

    private static Interval[] getIntervals(int[] origins, int[] sizes) {
        if (origins == null) {
            return new Interval[0];
        }
        Interval[] intervals = new Interval[origins.length];
        int i = 0;
        while (i < intervals.length) {
            intervals[i] = new Interval(origins[i], sizes[i]);
            ++i;
        }
        return intervals;
    }

    private void fillOccupiedCells(Map<Point, ControlInfo> occupiedCells, ControlInfo control, Rectangle cells) {
        int x = cells.x;
        while (x < cells.right()) {
            int y = cells.y;
            while (y < cells.bottom()) {
                occupiedCells.put(new Point(x, y), control);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public boolean isFiller(ControlInfo control) {
        return control != null && GridLayoutInfo.isLabel(control) && control.getCreationSupport() instanceof ConstructorCreationSupport && control.getVariableSupport() instanceof EmptyVariableSupport && control.getMethodInvocations().isEmpty();
    }

    private static boolean isLabel(ControlInfo control) {
        Class componentClass = control.getDescription().getComponentClass();
        return componentClass.getName().equals("org.eclipse.swt.widgets.Label");
    }

    @Override
    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
        if (!this.isFiller(control)) {
            GridDataInfo gridData = GridLayoutInfo.getGridData(control);
            final int column = gridData.x;
            final int row = gridData.y;
            commands.add((ClipboardCommand)new LayoutClipboardCommand<GridLayoutInfo>(control){
                private static final long serialVersionUID = 0L;

                @Override
                protected void add(GridLayoutInfo layout, ControlInfo control) throws Exception {
                    layout.command_CREATE(control, column, false, row, false);
                }
            });
            commands.add((ClipboardCommand)new LayoutDataClipboardCommand(this, control));
        }
    }

    @Override
    protected void storeLayoutData(ControlInfo control, LayoutDataInfo layoutData) throws Exception {
        GridDataInfo gridLayoutData = (GridDataInfo)layoutData;
        GeneralLayoutData generalLayoutData = new GeneralLayoutData();
        generalLayoutData.gridX = gridLayoutData.x;
        generalLayoutData.gridY = gridLayoutData.y;
        generalLayoutData.spanX = (Integer)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"horizontalSpan");
        generalLayoutData.spanY = (Integer)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"verticalSpan");
        generalLayoutData.horizontalGrab = (Boolean)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"grabExcessHorizontalSpace");
        generalLayoutData.verticalGrab = (Boolean)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"grabExcessVerticalSpace");
        generalLayoutData.horizontalAlignment = (GeneralLayoutData.HorizontalAlignment)GeneralLayoutData.getGeneralValue(m_horizontalAlignmentMap, (Object)((Integer)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"horizontalAlignment")));
        generalLayoutData.verticalAlignment = (GeneralLayoutData.VerticalAlignment)GeneralLayoutData.getGeneralValue(m_verticalAlignmentMap, (Object)((Integer)GeneralLayoutData.getLayoutPropertyValue((ObjectInfo)gridLayoutData, (String)"verticalAlignment")));
        generalLayoutData.putToInfo((ObjectInfo)control);
    }
}

