/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.annotations.AnnotationHandler;
import org.apache.commons.digester3.annotations.AnnotationHandlerFactory;
import org.apache.commons.digester3.annotations.DefaultAnnotationHandlerFactory;
import org.apache.commons.digester3.annotations.DigesterRule;
import org.apache.commons.digester3.annotations.DigesterRuleList;
import org.apache.commons.digester3.annotations.WithMemoryRulesBinder;
import org.apache.commons.digester3.annotations.reflect.MethodArgument;
import org.apache.commons.digester3.annotations.utils.AnnotationUtils;
import org.apache.commons.digester3.binder.AbstractRulesModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromAnnotationsRuleModule
extends AbstractRulesModule {
    private static final String JAVA_PACKAGE = "java";
    private static final AnnotationHandlerFactory DEFAULT_HANDLER_FACTORY = new DefaultAnnotationHandlerFactory();
    private AnnotationHandlerFactory annotationHandlerFactory = DEFAULT_HANDLER_FACTORY;
    private WithMemoryRulesBinder rulesBinder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void configure() {
        if (this.rulesBinder == null) {
            this.rulesBinder = new WithMemoryRulesBinder(this.rulesBinder());
        }
        try {
            this.configureRules();
        }
        finally {
            this.rulesBinder = null;
        }
    }

    protected abstract void configureRules();

    protected final void useAnnotationHandlerFactory(AnnotationHandlerFactory annotationHandlerFactory) {
        if (annotationHandlerFactory == null) {
            throw new IllegalArgumentException("Argument 'annotationHandlerFactory' must be not null");
        }
        this.annotationHandlerFactory = annotationHandlerFactory;
    }

    protected final void useDefaultAnnotationHandlerFactory() {
        this.useAnnotationHandlerFactory(DEFAULT_HANDLER_FACTORY);
    }

    protected final void bindRulesFrom(final Class<?> type) {
        if (type == null || type.getPackage().getName().startsWith(JAVA_PACKAGE) || this.rulesBinder.isAlreadyBound(type)) {
            return;
        }
        this.visitElements(type);
        if (!type.isInterface()) {
            this.visitElements((PrivilegedAction<AE[]>)new PrivilegedAction<Constructor<?>[]>(){

                @Override
                public Constructor<?>[] run() {
                    return type.getDeclaredConstructors();
                }
            });
            this.visitElements((PrivilegedAction<AE[]>)new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    return type.getDeclaredFields();
                }
            });
        }
        this.visitElements((PrivilegedAction<AE[]>)new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return type.getDeclaredMethods();
            }
        });
        this.rulesBinder.markAsBound(type);
        this.bindRulesFrom(type.getSuperclass());
    }

    private <AE extends AnnotatedElement> void visitElements(PrivilegedAction<AE[]> action) {
        AnnotatedElement[] annotatedElements = null;
        annotatedElements = System.getSecurityManager() != null ? (AnnotatedElement[])AccessController.doPrivileged(action) : (AnnotatedElement[])action.run();
        this.visitElements(annotatedElements);
    }

    private void visitElements(AnnotatedElement ... annotatedElements) {
        for (AnnotatedElement element : annotatedElements) {
            for (Annotation annotation : element.getAnnotations()) {
                this.handle(annotation, element);
            }
            if (!(element instanceof Method)) continue;
            Method method = (Method)element;
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.visitElements(new MethodArgument(i, parameterTypes[i], parameterAnnotations[i]));
            }
        }
    }

    private <A extends Annotation, E extends AnnotatedElement, R extends Rule> void handle(A annotation, E element) {
        block4: {
            Class<? extends Annotation> annotationType;
            block3: {
                annotationType = annotation.annotationType();
                if (!annotationType.isAnnotationPresent(DigesterRuleList.class)) break block3;
                Annotation[] annotations = AnnotationUtils.getAnnotationsArrayValue(annotation);
                if (annotations == null || annotations.length <= 0) break block4;
                for (Annotation ptr : annotations) {
                    this.handle(ptr, element);
                }
                break block4;
            }
            if (!annotationType.isAnnotationPresent(DigesterRule.class)) break block4;
            DigesterRule digesterRule = annotationType.getAnnotation(DigesterRule.class);
            Class<? extends AnnotationHandler<? extends Annotation, ? extends AnnotatedElement>> handlerType = digesterRule.handledBy();
            try {
                AnnotationHandler<? extends Annotation, ? extends AnnotatedElement> handler = this.annotationHandlerFactory.newInstance(handlerType);
                handler.handle(annotation, element, this.rulesBinder);
            }
            catch (Exception e) {
                this.rulesBinder.addError(e);
            }
        }
    }
}

