/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout.form;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.xwt.model.layout.form.FormAttachmentInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class ControlSelectionPropertyEditor
extends AbstractComboPropertyEditor {
    private final List<ControlInfo> m_controls = new ArrayList<ControlInfo>();

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        FormAttachmentInfo formAttachment = this.getAttachment(property);
        ControlInfo thisControl = (ControlInfo)formAttachment.getParent().getParent();
        CompositeInfo compositeInfo = (CompositeInfo)thisControl.getParent();
        List<ControlInfo> childrenControls = compositeInfo.getChildrenControls();
        for (ControlInfo controlInfo : childrenControls) {
            if (controlInfo == thisControl) continue;
            combo.add(controlInfo.getPresentation().getText());
            this.m_controls.add(controlInfo);
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        ControlInfo controlInfo = this.m_controls.get(index);
        ((GenericPropertyImpl)property).setExpression("", (Object)controlInfo);
    }

    protected String getText(Property property) throws Exception {
        FormAttachmentInfo attachment;
        XmlObjectInfo controlInfo;
        Object control = property.getValue();
        if (control != null && (controlInfo = (attachment = this.getAttachment(property)).getRootXML().getChildByObject(control)) != null) {
            return controlInfo.getPresentation().getText();
        }
        return null;
    }

    private FormAttachmentInfo getAttachment(Property property) {
        GenericProperty genericProperty = (GenericProperty)property;
        FormAttachmentInfo formAttachment = (FormAttachmentInfo)genericProperty.getObject();
        return formAttachment;
    }
}

