/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor.font;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.xwt.model.property.editor.font.FontPreviewShell;
import org.eclipse.wb.os.OSSupport;

public class FontSupport {
    private static final FontPreviewShell m_fontPreviewShell = new FontPreviewShell();

    public static String[] getFontFamilies() throws Exception {
        TreeSet<String> families = new TreeSet<String>();
        families.addAll(FontSupport.getFontFamilies(true));
        families.addAll(FontSupport.getFontFamilies(false));
        Object[] sortFamilies = families.toArray(new String[families.size()]);
        Arrays.sort(sortFamilies);
        return sortFamilies;
    }

    private static Set<String> getFontFamilies(boolean scalable) throws Exception {
        FontData[] fontList;
        TreeSet<String> families = new TreeSet<String>();
        FontData[] fontDataArray = fontList = Display.getDefault().getFontList(null, scalable);
        int n = fontList.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            families.add(fontData.getName());
            ++n2;
        }
        return families;
    }

    public static String getFontStyleText(int style) throws Exception {
        boolean italic;
        boolean bold = (style & 1) != 0;
        boolean bl = italic = (style & 2) != 0;
        if (bold && italic) {
            return "BOLD ITALIC";
        }
        if (bold) {
            return "BOLD";
        }
        if (italic) {
            return "ITALIC";
        }
        return "";
    }

    public static String getFontStyleSource(int style) throws Exception {
        boolean italic;
        boolean bold = (style & 1) != 0;
        boolean bl = italic = (style & 2) != 0;
        if (bold && italic) {
            return "BOLD | ITALIC";
        }
        if (bold) {
            return "BOLD";
        }
        if (italic) {
            return "ITALIC";
        }
        return "";
    }

    public static Image getFontPreview(Font font) throws Exception {
        m_fontPreviewShell.updateFont(font);
        return OSSupport.get().makeShot((Control)m_fontPreviewShell);
    }
}

