/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.event;

import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.event.EventsPropertyUtils;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.xwt.editor.XwtPairResourceProvider;
import org.eclipse.wb.internal.xwt.model.property.event.XwtListenerPropertyEditor;
import org.eclipse.wb.internal.xwt.model.util.NameSupport;

public final class XwtListenerProperty
extends AbstractListenerProperty {
    private final String m_name;
    private final String m_attribute;
    private AstEditor m_editor;
    private TypeDeclaration m_typeDeclaration;
    private IFile m_javaFile;

    public XwtListenerProperty(XmlObjectInfo object, String name) {
        super(object, name, (PropertyEditor)new XwtListenerPropertyEditor(name));
        this.m_name = name;
        this.m_attribute = name + "Event";
    }

    public boolean isModified() throws Exception {
        return this.m_object.getAttribute(this.m_attribute) != null;
    }

    public void setValue(Object value) throws Exception {
        if (value == UNKNOWN_VALUE && MessageDialog.openConfirm((Shell)DesignerPlugin.getShell(), (String)"Confirm", (String)("Do you really want delete event '" + this.m_name + "' and its method?"))) {
            this.removeListener();
        }
    }

    protected void removeListener() throws Exception {
        this.deleteMethodDeclaration();
        this.m_object.removeAttribute(this.m_attribute);
        ExecutionUtils.refresh((ObjectInfo)this.m_object);
    }

    private void deleteMethodDeclaration() throws Exception {
        this.prepareJavaFile();
        if (this.m_javaFile == null) {
            return;
        }
        try {
            this.prepareAST();
            MethodDeclaration method = this.getMethodDeclaration0(false);
            if (method != null) {
                this.m_editor.removeBodyDeclaration((BodyDeclaration)method);
                this.saveAST();
            }
        }
        finally {
            this.clearAST();
        }
    }

    protected void addListenerActions(IMenuManager manager, IMenuManager implementMenuManager) throws Exception {
        IAction[] actions = this.createListenerMethodActions();
        if (actions[0] != null) {
            manager.appendToGroup("org.eclipse.wb.popup.group.events", actions[0]);
        }
        implementMenuManager.add(actions[0] != null ? actions[0] : actions[1]);
    }

    private IAction[] createListenerMethodActions() {
        IAction[] actions = new IAction[2];
        String methodName = this.m_object.getAttribute(this.m_attribute);
        if (methodName != null) {
            actions[0] = new ObjectInfoAction((ObjectInfo)this.m_object){

                protected void runEx() throws Exception {
                    XwtListenerProperty.this.openListener();
                }
            };
            actions[0].setText(this.m_name + " -> " + methodName);
            actions[0].setImageDescriptor(EventsPropertyUtils.LISTENER_METHOD_IMAGE_DESCRIPTOR);
        }
        actions[1] = new ObjectInfoAction((ObjectInfo)this.m_object){

            protected void runEx() throws Exception {
                XwtListenerProperty.this.openListener();
            }
        };
        actions[1].setText(this.m_name);
        actions[1].setImageDescriptor(EventsPropertyUtils.LISTENER_METHOD_IMAGE_DESCRIPTOR);
        return actions;
    }

    protected void openListener() throws Exception {
        MethodDeclaration method = this.getMethodDeclaration();
        if (method != null) {
            this.openMethod_inEditor(method);
        }
    }

    private void prepareAST() throws Exception {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)this.m_javaFile);
        this.m_editor = new AstEditor(unit);
        this.m_typeDeclaration = (TypeDeclaration)DomGenerics.types((CompilationUnit)this.m_editor.getAstUnit()).get(0);
    }

    private void saveAST() throws Exception {
        this.m_editor.saveChanges(false);
    }

    private void clearAST() {
        this.m_editor = null;
        this.m_typeDeclaration = null;
    }

    private MethodDeclaration getMethodDeclaration() throws Exception {
        this.prepareJavaFile();
        if (this.m_javaFile == null) {
            return null;
        }
        try {
            this.prepareAST();
            MethodDeclaration methodDeclaration = this.getMethodDeclaration0(true);
            return methodDeclaration;
        }
        finally {
            this.clearAST();
        }
    }

    private void prepareJavaFile() {
        IFile xwtFile = this.m_object.getContext().getFile();
        this.m_javaFile = XwtPairResourceProvider.INSTANCE.getPair(xwtFile);
    }

    private MethodDeclaration getMethodDeclaration0(boolean addNew) throws Exception {
        String methodName = this.m_object.getAttribute(this.m_attribute);
        if (methodName != null) {
            return AstNodeUtils.getMethodByName((TypeDeclaration)this.m_typeDeclaration, (String)methodName);
        }
        if (!addNew) {
            return null;
        }
        Object baseName = "on";
        String objectName = NameSupport.getName(this.m_object);
        if (objectName != null) {
            baseName = (String)baseName + StringUtils.capitalize((String)objectName);
        }
        baseName = (String)baseName + this.m_name;
        methodName = this.m_editor.getUniqueMethodName((String)baseName);
        MethodDeclaration method = this.m_editor.addMethodDeclaration("public void " + methodName + "(org.eclipse.swt.widgets.Event event)", Collections.emptyList(), new BodyDeclarationTarget(this.m_typeDeclaration, false));
        this.saveAST();
        this.m_object.setAttribute(this.m_attribute, methodName);
        ExecutionUtils.refresh((ObjectInfo)this.m_object);
        return method;
    }

    private void openMethod_inEditor(MethodDeclaration method) throws Exception {
        IEditorPart javaEditor = IDE.openEditor((IWorkbenchPage)DesignerPlugin.getActivePage(), (IFile)this.m_javaFile);
        if (javaEditor instanceof ITextEditor) {
            ((ITextEditor)javaEditor).selectAndReveal(method.getStartPosition(), 0);
        }
    }
}

