/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.util;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.NamespacesHelper;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class NameSupport {
    private NameSupport() {
    }

    public static void decoratePresentationWithName(XmlObjectInfo root) {
        root.addBroadcastListener((Object)new ObjectInfoPresentationDecorateText(){

            /*
             * WARNING - void declaration
             */
            public void invoke(ObjectInfo object, String[] text) throws Exception {
                ObjectInfo objectInfo = object;
                if (objectInfo instanceof XmlObjectInfo) {
                    void xObject;
                    XmlObjectInfo xmlObjectInfo = (XmlObjectInfo)objectInfo;
                    XmlObjectInfo cfr_ignored_0 = (XmlObjectInfo)objectInfo;
                    String name = NameSupport.getName((XmlObjectInfo)xObject);
                    if (name != null) {
                        text[0] = text[0] + " - " + name;
                    }
                }
            }
        });
    }

    public static String getName(XmlObjectInfo object) {
        String nameAttribute = NameSupport.getNamePrefix(object) + "Name";
        return object.getAttribute(nameAttribute);
    }

    public static String ensureName(XmlObjectInfo object) {
        String name = NameSupport.getName(object);
        if (name == null) {
            name = NameSupport.generateName(object);
            NameSupport.setName(object, name);
        }
        return name;
    }

    public static void setName(XmlObjectInfo object, String name) {
        String nameAttribute = NameSupport.getNamePrefix(object) + "Name";
        object.setAttribute(nameAttribute, name);
    }

    private static String getNamePrefix(XmlObjectInfo object) {
        String namespaceName = NamespacesHelper.ensureName((DocumentElement)object.getElement(), (String)"http://www.eclipse.org/xwt", (String)"x");
        return namespaceName + ":";
    }

    private static String generateName(XmlObjectInfo object) {
        String baseName = NameSupport.getBaseName(object);
        Set<String> existingNames = NameSupport.getExistingNames(object);
        String uniqueName = CodeUtils.generateUniqueName((String)baseName, name -> !existingNames.contains(name));
        return uniqueName;
    }

    private static Set<String> getExistingNames(XmlObjectInfo object) {
        final TreeSet<String> resultSet = new TreeSet<String>();
        object.getRootXML().accept(new ObjectInfoVisitor(){

            /*
             * WARNING - void declaration
             */
            public void endVisit(ObjectInfo object) throws Exception {
                ObjectInfo objectInfo = object;
                if (objectInfo instanceof XmlObjectInfo) {
                    void xmlObject;
                    XmlObjectInfo xmlObjectInfo = (XmlObjectInfo)objectInfo;
                    XmlObjectInfo cfr_ignored_0 = (XmlObjectInfo)objectInfo;
                    if (XmlObjectUtils.isImplicit((XmlObjectInfo)xmlObject)) {
                        return;
                    }
                    String name = NameSupport.getName((XmlObjectInfo)xmlObject);
                    if (name != null) {
                        resultSet.add(name);
                    }
                }
            }
        });
        return resultSet;
    }

    private static String getBaseName(XmlObjectInfo object) {
        ComponentDescription description = object.getDescription();
        NamesManager.ComponentNameDescription nameDescription = NamesManager.getNameDescription((ToolkitDescription)description.getToolkit(), (String)description.getComponentClass().getName());
        if (nameDescription != null) {
            return nameDescription.getName();
        }
        String name = XmlObjectUtils.getParameter((XmlObjectInfo)object, (String)"variable.name");
        if (!StringUtils.isEmpty((String)name)) {
            return name;
        }
        return NamesManager.getDefaultName((String)description.getComponentClass().getName());
    }
}

