/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectPresentation;
import org.eclipse.wb.internal.xwt.model.widgets.WidgetInfo;
import org.osgi.framework.Bundle;

public abstract class StylePresentation
extends XmlObjectPresentation {
    protected final WidgetInfo m_widget;
    private static final Map<Class<?>, Map<Integer, ImageDescriptor>> m_images = new HashMap();

    public StylePresentation(WidgetInfo widget) {
        super((XmlObjectInfo)widget);
        this.m_widget = widget;
    }

    public ImageDescriptor getIcon() throws Exception {
        int style = this.m_widget.getStyle();
        for (Map.Entry<Integer, ImageDescriptor> entry : this.getImages().entrySet()) {
            int keyStyle = entry.getKey();
            if ((style & keyStyle) != keyStyle) continue;
            return entry.getValue();
        }
        return super.getIcon();
    }

    protected abstract void initImages() throws Exception;

    private Map<Integer, ImageDescriptor> getImages() throws Exception {
        Map<Integer, ImageDescriptor> images = m_images.get(((Object)((Object)this)).getClass());
        if (images == null) {
            images = new HashMap<Integer, ImageDescriptor>();
            m_images.put(((Object)((Object)this)).getClass(), images);
            this.initImages();
        }
        return images;
    }

    protected final void addImage(int style, String imagePath) throws Exception {
        Bundle bundle = this.m_widget.getDescription().getToolkit().getBundle();
        URL imageURL = bundle.getEntry(imagePath);
        Assert.isNotNull((Object)imageURL, (String)("Can't find image: " + imagePath + " in " + bundle.getSymbolicName()));
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
        this.getImages().put(style, image);
    }
}

