/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets.menu;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddBefore;
import org.eclipse.wb.internal.core.model.menu.AbstractMenuObject;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetExpression;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAdd;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectClipboardCopy;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.widgets.ItemInfo;
import org.eclipse.wb.internal.xwt.model.widgets.XwtLiveManager;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuInfo;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuItemLiveManager;
import org.eclipse.wb.internal.xwt.model.widgets.menu.MenuItemStylePresentation;

public final class MenuItemInfo
extends ItemInfo
implements IAdaptable {
    private final MenuItemInfo m_this = this;
    private final IObjectPresentation m_presentation = new MenuItemStylePresentation(this);
    private final Object m_stylePropertyListener = new GenericPropertySetExpression(){

        public void invoke(GenericPropertyImpl property, String[] expression, Object[] value, boolean[] shouldSet) throws Exception {
            if (property.getObject() == MenuItemInfo.this.m_this && !XmlObjectMemento.isApplying((XmlObjectInfo)MenuItemInfo.this.m_this) && "Style".equals(property.getTitle())) {
                boolean becomesSeparator;
                boolean wasCascade = ((Integer)property.getValue() & 0x40) != 0;
                boolean wasSeparator = ((Integer)property.getValue() & 2) != 0;
                final boolean becomesCascade = expression[0].indexOf("CASCADE") != -1;
                boolean bl = becomesSeparator = expression[0].indexOf("SEPARATOR") != -1;
                if (wasCascade == becomesCascade && wasSeparator == becomesSeparator) {
                    return;
                }
                ExecutionUtils.run((ObjectInfo)MenuItemInfo.this.m_this, (RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        if (becomesCascade) {
                            MenuItemInfo.this.addSubMenu();
                        } else {
                            MenuItemInfo.this.deleteSubMenu();
                        }
                        if (becomesSeparator) {
                            MenuItemInfo.this.getPropertyByTitle("text").setValue(Property.UNKNOWN_VALUE);
                        }
                    }
                });
            }
        }
    };
    private final IMenuItemInfo m_itemImpl = new MenuItemImpl();

    public MenuItemInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        this.addBroadcastListeners();
    }

    private void addBroadcastListeners() {
        this.addBroadcastListener(this.m_stylePropertyListener);
        this.manageItemStyle_hasSubMenu();
        this.addClipboardSupport();
        this.addBroadcastListener(new XmlObjectAdd(){

            public void after(ObjectInfo parent, XmlObjectInfo child) throws Exception {
                if (child == MenuItemInfo.this.m_this) {
                    if (XmlObjectUtils.hasTrueParameter((XmlObjectInfo)MenuItemInfo.this.m_this, (String)"MenuItem.createCascadeMenu")) {
                        MenuItemInfo.this.addSubMenu();
                    }
                    MenuItemInfo.this.removeBroadcastListener((Object)this);
                }
            }
        });
    }

    private void addClipboardSupport() {
        this.addBroadcastListener(new XmlObjectClipboardCopy(){

            public void invoke(XmlObjectInfo object, List<ClipboardCommand> commands) throws Exception {
                MenuInfo menu;
                if (object == MenuItemInfo.this.m_this && (menu = MenuItemInfo.this.getSubMenu()) != null) {
                    final XmlObjectMemento menuMemento = XmlObjectMemento.createMemento((XmlObjectInfo)menu);
                    commands.add(new ClipboardCommand(){
                        private static final long serialVersionUID = 0L;

                        public void execute(XmlObjectInfo object) throws Exception {
                            MenuInfo menu = (MenuInfo)menuMemento.create(object);
                            menu.commandCreate((MenuItemInfo)object);
                            menuMemento.apply();
                        }
                    });
                }
            }
        });
    }

    public MenuInfo getSubMenu() {
        List subMenus = this.getChildren(MenuInfo.class);
        Assert.isLegal((subMenus.size() <= 1 ? 1 : 0) != 0);
        return !subMenus.isEmpty() ? (MenuInfo)((Object)subMenus.get(0)) : null;
    }

    private void addSubMenu() throws Exception {
        if (this.getSubMenu() == null) {
            MenuInfo subMenu = (MenuInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), Menu.class, (CreationSupport)new ElementCreationSupport());
            subMenu.commandCreate(this);
        }
    }

    private void deleteSubMenu() throws Exception {
        MenuInfo subMenu = this.getSubMenu();
        if (subMenu != null) {
            subMenu.delete();
        }
    }

    @Override
    protected XwtLiveManager getLiveComponentsManager() {
        return new MenuItemLiveManager(this);
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    private void manageItemStyle_hasSubMenu() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void childRemoveAfter(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (parent == MenuItemInfo.this.m_this && child instanceof MenuInfo) {
                    MenuItemInfo.this.setStyleSource(null);
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildAddBefore(){

            public void invoke(ObjectInfo parent, ObjectInfo child, ObjectInfo[] nextChild) throws Exception {
                if (GlobalState.isParsing()) {
                    return;
                }
                if (parent == MenuItemInfo.this.m_this && child instanceof MenuInfo) {
                    MenuItemInfo.this.setStyleSource("CASCADE");
                }
            }
        });
    }

    private void setStyleSource(String source) throws Exception {
        this.removeBroadcastListener(this.m_stylePropertyListener);
        try {
            GenericProperty styleProperty = (GenericProperty)this.getPropertyByTitle("Style");
            styleProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
        finally {
            this.addBroadcastListener(this.m_stylePropertyListener);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IMenuItemInfo.class)) {
            return adapter.cast(this.m_itemImpl);
        }
        return null;
    }

    private final class MenuItemImpl
    extends AbstractMenuObject
    implements IMenuItemInfo,
    IMenuPolicy {
        public MenuItemImpl() {
            super((ObjectInfo)MenuItemInfo.this.m_this);
        }

        public Object getModel() {
            return MenuItemInfo.this.m_this;
        }

        public ImageDescriptor getImageDescriptor() {
            return Optional.ofNullable(MenuItemInfo.this.m_this.getImage()).map(ImageDescriptor::createFromImage).orElse(null);
        }

        public Rectangle getBounds() {
            return MenuItemInfo.this.m_this.getBounds();
        }

        public IMenuInfo getMenu() {
            MenuInfo subMenu = MenuItemInfo.this.getSubMenu();
            return MenuObjectInfoUtils.getMenuInfo((Object)((Object)subMenu));
        }

        public IMenuPolicy getPolicy() {
            return this;
        }

        public boolean validateCreate(Object object) {
            return false;
        }

        public boolean validatePaste(Object mementoObject) {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public boolean validateMove(Object object) {
            Object object2 = object;
            if (object2 instanceof MenuInfo) {
                void menuInfo;
                MenuInfo menuInfo2 = (MenuInfo)((Object)object2);
                MenuInfo cfr_ignored_0 = (MenuInfo)((Object)object2);
                return !menuInfo.isParentOf((ObjectInfo)MenuItemInfo.this.m_this);
            }
            return false;
        }

        public void commandCreate(Object object, Object nextObject) throws Exception {
        }

        public List<?> commandPaste(Object mementoObject, Object nextObject) throws Exception {
            return Collections.emptyList();
        }

        public void commandMove(Object object, Object nextObject) throws Exception {
            MenuInfo menuInfo = (MenuInfo)((Object)object);
            menuInfo.commandMove(MenuItemInfo.this.m_this);
            MenuObjectInfoUtils.setSelectingObject((Object)((Object)menuInfo));
        }
    }
}

