/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;

public class ToolUtilities {
    public static List<EditPart> getSelectionWithoutDependants(IEditPartViewer viewer) {
        ArrayList<EditPart> operationSet = new ArrayList<EditPart>();
        List<EditPart> selectedParts = viewer.getSelectedEditParts();
        for (EditPart part : selectedParts) {
            if (ToolUtilities.isAncestorContainedIn(selectedParts, part)) continue;
            operationSet.add(part);
        }
        EditPart commonParent = null;
        for (EditPart editPart : operationSet) {
            if (commonParent == null) {
                commonParent = editPart.getParent();
                continue;
            }
            if (editPart.getParent() == commonParent) continue;
            return Collections.emptyList();
        }
        return operationSet;
    }

    private static boolean isAncestorContainedIn(List<EditPart> container, EditPart part) {
        EditPart parent = part.getParent();
        while (parent != null) {
            if (container.contains((Object)parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

