/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.policies;

import java.util.Iterator;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.IEditPartDecorationListener;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.GroupRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;

public abstract class LayoutEditPolicy
extends GraphicalEditPolicy {
    private final EditPartListener m_listener = new EditPartListener.Stub(){

        public void childAdded(org.eclipse.gef.EditPart child, int index) {
            LayoutEditPolicy.this.decorateChild((EditPart)child);
        }

        public void removingChild(org.eclipse.gef.EditPart child, int index) {
            LayoutEditPolicy.this.undecorateChild((EditPart)child);
        }
    };

    @Override
    public void activate() {
        this.getHost().addEditPartListener(this.m_listener);
        for (EditPart child : this.getHost().getChildren()) {
            this.decorateChild(child);
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        for (EditPart child : this.getHost().getChildren()) {
            this.undecorateChild(child);
        }
        this.getHost().removeEditPartListener(this.m_listener);
        this.eraseLayoutTargetFeedback(null);
        super.deactivate();
    }

    protected void decorateChild(EditPart child) {
        this.fire_decorateChild(child);
    }

    protected void undecorateChild(EditPart child) {
        this.fire_undecorateChild(child);
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ILayoutRequestValidator.TRUE;
    }

    protected boolean isRequestCondition(Request request) {
        Object type = request.getType();
        ILayoutRequestValidator validator = this.getRequestValidator();
        GraphicalEditPart host = this.getHost();
        if (type == "create child") {
            return validator.validateCreateRequest(host, (CreateRequest)request);
        }
        if (type == "paste") {
            return validator.validatePasteRequest(host, (PasteRequest)request);
        }
        if (type == "move") {
            return validator.validateMoveRequest(host, (ChangeBoundsRequest)request);
        }
        if (type == "add children") {
            return validator.validateAddRequest(host, (ChangeBoundsRequest)request);
        }
        return false;
    }

    @Override
    public boolean understandsRequest(Request request) {
        return this.isRequestCondition(request);
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        return this.isRequestCondition(request) ? this.getHost() : null;
    }

    @Override
    public Command getCommand(Request request) {
        Object type = request.getType();
        if (type == "create child") {
            return this.getCreateCommand((CreateRequest)request);
        }
        if (type == "paste") {
            return this.getPasteCommand((PasteRequest)request);
        }
        if (type == "move") {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        if (type == "add children") {
            return this.getAddCommand((ChangeBoundsRequest)request);
        }
        if (type == "orphan") {
            return this.getOrphanCommand((GroupRequest)request);
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getPasteCommand(PasteRequest request) {
        return null;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        return null;
    }

    protected Command getOrphanCommand(GroupRequest request) {
        return null;
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (this.isRequestCondition(request)) {
            this.showLayoutTargetFeedback(request);
        }
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        this.eraseLayoutTargetFeedback(request);
    }

    protected void showLayoutTargetFeedback(Request request) {
    }

    protected void eraseLayoutTargetFeedback(Request request) {
    }

    public void addEditPartListener(IEditPartDecorationListener listener) {
        this.getEnsureEventTable().addListener(IEditPartDecorationListener.class, (Object)listener);
    }

    public void removeEditPartListener(IEditPartDecorationListener listener) {
        this.getEnsureEventTable().removeListener(IEditPartDecorationListener.class, (Object)listener);
    }

    private void fire_decorateChild(EditPart child) {
        Iterator<IEditPartDecorationListener> listeners = this.getListeners(IEditPartDecorationListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.decorate(child));
        }
    }

    private void fire_undecorateChild(EditPart child) {
        Iterator<IEditPartDecorationListener> listeners = this.getListeners(IEditPartDecorationListener.class);
        if (listeners != null) {
            listeners.forEachRemaining(listener -> listener.undecorate(child));
        }
    }
}

