/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.errors.report2.EclipseLogEntryFileReportInfo;
import org.eclipse.wb.internal.core.editor.errors.report2.EnvironmentFileReportInfo;
import org.eclipse.wb.internal.core.editor.errors.report2.FileReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.IErrorReport;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntriesProvider;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.Messages;
import org.eclipse.wb.internal.core.editor.errors.report2.PreferencesFileReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.ProjectReportEntry;
import org.eclipse.wb.internal.core.editor.errors.report2.ScreenshotFileReportEntry;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

public final class ZipFileErrorReport
implements IErrorReport {
    private final List<IReportEntry> m_entries = new ArrayList<IReportEntry>();
    private final IProject m_project;
    private final IReportEntry m_sourceFileReport;
    private final ProjectReportEntry m_projectFileReport;
    private final EnvironmentFileReportInfo m_environmentFileReport;
    private Map<String, IReportEntry> m_screenshotsMap;
    private final Image m_defaultScreenShot;
    private Map<String, IReportEntry> m_filesMap;

    public ZipFileErrorReport(Image defaultScreenShot, IProject project, IReportEntry sourceFileReport) {
        this.m_defaultScreenShot = defaultScreenShot;
        this.m_project = project;
        this.m_sourceFileReport = sourceFileReport;
        this.m_projectFileReport = new ProjectReportEntry(project);
        this.m_environmentFileReport = new EnvironmentFileReportInfo(project);
        this.setupScreenshots();
        this.setupFiles();
        this.m_entries.add(this.m_environmentFileReport);
        this.m_entries.add(new PreferencesFileReportEntry());
        this.m_entries.add(new EclipseLogEntryFileReportInfo());
        if (this.m_sourceFileReport != null) {
            this.m_entries.add(this.m_sourceFileReport);
        }
        this.addExternalReportEntries();
    }

    public void reportProblem(IProgressMonitor monitor) throws Exception {
        String reportFileName = this.createZipReport(monitor);
        Program.launch((String)new Path(reportFileName).removeLastSegments(1).toOSString());
    }

    private String createZipReport(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(Messages.ZipFileErrorReport_taskTitle, this.m_entries.size());
        File tempDir = ZipFileErrorReport.getReportTemporaryDirectory();
        String fileName = "report-" + DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd-HHmmss") + ".zip";
        File tempFile = new File(tempDir, fileName);
        tempFile.deleteOnExit();
        ZipOutputStream zipStream = null;
        try {
            zipStream = new ZipOutputStream(new FileOutputStream(tempFile));
            zipStream.setLevel(9);
            for (IReportEntry reportInfo : this.m_entries) {
                try {
                    reportInfo.write(zipStream);
                }
                catch (Throwable e) {
                    DesignerPlugin.log(e);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zipStream);
        return tempFile.getAbsolutePath();
    }

    public static File getReportTemporaryDirectory() {
        Object tmpDirPath = System.getProperty("java.io.tmpdir");
        tmpDirPath = (String)tmpDirPath + File.separator + "wbp-report";
        File tempDir = new File((String)tmpDirPath);
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        return tempDir;
    }

    @Override
    public boolean hasDefaultScreenshot() {
        return this.m_defaultScreenShot != null;
    }

    @Override
    public boolean hasScreenshot(String filePath) {
        return this.m_screenshotsMap.get(filePath) != null;
    }

    @Override
    public void includeScreenshot(String filePath, boolean include) {
        if (include) {
            this.addScreenshot(filePath);
        } else {
            IReportEntry removed = this.m_screenshotsMap.remove(filePath);
            this.m_entries.remove(removed);
        }
    }

    private void addScreenshot(String filePath) {
        if (!this.hasScreenshot(filePath)) {
            ScreenshotFileReportEntry reportInfo = new ScreenshotFileReportEntry(filePath);
            this.m_screenshotsMap.put(filePath, reportInfo);
            this.m_entries.add(reportInfo);
        }
    }

    public void setupScreenshots() {
        this.removeEntries(this.m_screenshotsMap);
        this.m_screenshotsMap = new TreeMap<String, IReportEntry>();
        if (this.hasDefaultScreenshot()) {
            this.addScreenshot("default-screenshot.png");
        }
    }

    @Override
    public boolean hasFile(String filePath) {
        return this.m_filesMap.get(filePath) != null;
    }

    @Override
    public void includeFile(String filePath, boolean include) {
        if (include) {
            this.addFile(filePath);
        } else {
            IReportEntry removed = this.m_filesMap.remove(filePath);
            this.m_entries.remove(removed);
        }
    }

    private void addFile(String filePath) {
        if (!this.hasFile(filePath)) {
            FileReportEntry reportInfo = new FileReportEntry(filePath){

                @Override
                public String getName() {
                    return "files/" + FilenameUtils.getName((String)this.getFilePath());
                }
            };
            this.m_filesMap.put(filePath, reportInfo);
            this.m_entries.add(reportInfo);
        }
    }

    public void setupFiles() {
        this.removeEntries(this.m_filesMap);
        this.m_filesMap = new TreeMap<String, IReportEntry>();
    }

    public String getComputerInfo() {
        try {
            String contents = IOUtils2.readString(this.m_environmentFileReport.getContents());
            return "<html><body><pre>" + contents + "</pre></body></html>";
        }
        catch (Throwable e) {
            return Messages.ZipFileErrorReport_errorMessage;
        }
    }

    @Override
    public boolean hasSourceFile() {
        return this.m_sourceFileReport != null && this.m_entries.indexOf(this.m_sourceFileReport) != -1;
    }

    private void addExternalReportEntries() {
        List<IReportEntriesProvider> providers = ExternalFactoriesHelper.getElementsInstances(IReportEntriesProvider.class, "org.eclipse.wb.core.errorReportEntriesProviders", "provider");
        for (IReportEntriesProvider provider : providers) {
            provider.addEntries(this);
        }
    }

    @Override
    public IProject getProject() {
        return this.m_project;
    }

    @Override
    public void addEntry(IReportEntry entry) {
        if (this.m_entries.indexOf(entry) == -1) {
            this.m_entries.add(entry);
        }
    }

    @Override
    public void removeEntry(IReportEntry entry) {
        this.m_entries.remove(entry);
    }

    public void setIncludeSourceFile(boolean include) {
        this.checkInclude(this.m_sourceFileReport, include);
    }

    public void setIncludeProject(boolean include) {
        this.checkInclude(this.m_projectFileReport, include);
    }

    private void removeEntries(Map<String, IReportEntry> map) {
        if (map != null) {
            for (Map.Entry<String, IReportEntry> entry : map.entrySet()) {
                this.m_entries.remove(entry.getValue());
            }
        }
    }

    private void checkInclude(IReportEntry report, boolean include) {
        if (include) {
            this.addEntry(report);
        } else {
            this.removeEntry(report);
        }
    }
}

