/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.HasSourcePosition;
import org.eclipse.wb.core.model.IJavaInfoInitializationParticipator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.broadcast.EvaluationEventListener;
import org.eclipse.wb.core.model.broadcast.ExecutionFlowEnterFrame;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetAssociationBefore;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetVariable;
import org.eclipse.wb.core.model.broadcast.JavaInfosetObjectBefore;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConfigurablePropertyDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.presentation.DefaultJavaInfoPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyFactory;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.event.EventsProperty;
import org.eclipse.wb.internal.core.model.property.hierarchy.ComponentClassProperty;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.model.util.ImportantPropertiesDialog;
import org.eclipse.wb.internal.core.model.util.PlaceholderUtils;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.PropertyUtils2;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.VisitedNodes;

public class JavaInfo
extends ObjectInfo
implements HasSourcePosition {
    private final JavaInfo m_this = this;
    public static final String FLAG_MANUAL_COMPONENT = "manuallyCreatedComponent";
    public static final String FLAG_DONT_COMMIT_EDITOR = "don't commit ASTEditor source";
    private final ComponentDescription m_description;
    private final AstEditor m_editor;
    private Map<String, String> m_templateArguments = null;
    private Association m_association;
    private boolean m_initialized;
    private boolean m_objectReady = false;
    private List<GenericPropertyImpl> m_descriptionBasedProperties;
    private List<Property> m_configurableProperties;
    private final ComponentClassProperty m_componentClassProperty;
    private final EventsProperty m_eventsProperty;
    private CreationSupport m_creationSupport;
    private VariableSupport m_variableSupport;
    private final IObjectPresentation m_presentation = new DefaultJavaInfoPresentation(this);
    private final List<ASTNode> m_nodes = new LinkedList<ASTNode>();
    private JavaInfoEvaluationHelper m_evaluationHelper;
    private Object m_object;

    public JavaInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        this.m_editor = editor;
        this.m_description = description;
        this.m_creationSupport = creationSupport;
        this.setBroadcastSupport(EditorState.get(this.m_editor).getBroadcast());
        this.m_description.visit(this, 0);
        this.scheduleSendingObjectReady();
        this.m_creationSupport.setJavaInfo(this);
        Class<?> componentClass = description.getComponentClass();
        if (componentClass == null) {
            this.m_componentClassProperty = null;
            this.m_eventsProperty = null;
        } else {
            IJavaProject javaProject = editor.getJavaProject();
            this.m_componentClassProperty = new ComponentClassProperty(javaProject, componentClass);
            this.m_eventsProperty = new EventsProperty(this);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append(this.m_creationSupport.toString());
        buffer.append("}");
        if (this.m_variableSupport != null) {
            buffer.append(" {");
            buffer.append(this.m_variableSupport.toString());
            buffer.append("}");
        }
        this.appendNodes(buffer, this.getRelatedNodes());
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void appendNodes(StringBuffer buffer, List<ASTNode> nodes) {
        buffer.append(" {");
        boolean first = true;
        for (ASTNode node : nodes) {
            if (!first) {
                buffer.append(" ");
            }
            first = false;
            ASTNode sourceNode = JavaInfo.getRelatedNodeForSource(node);
            String source = this.getEditor().getSource(sourceNode);
            ASTNode aSTNode = sourceNode;
            if (aSTNode instanceof ClassInstanceCreation) {
                void creation;
                ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)aSTNode;
                ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode;
                if (creation.getAnonymousClassDeclaration() != null) {
                    source = StringUtils.substringBefore((String)source, (String)"{").trim();
                }
            }
            buffer.append("/");
            buffer.append(source);
            buffer.append("/");
        }
        buffer.append("}");
    }

    public static ASTNode getRelatedNodeForSource(ASTNode node) {
        ASTNode sourceNode = node;
        if (node.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
            sourceNode = node.getParent();
        }
        if (node.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
            sourceNode = node.getParent();
        }
        if (node.getLocationInParent() == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            sourceNode = node.getParent();
        }
        if (node.getLocationInParent() == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            sourceNode = node.getParent();
        }
        if (node.getLocationInParent() == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            sourceNode = node.getParent();
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            QualifiedName qualifiedName = (QualifiedName)node.getParent();
            sourceNode = qualifiedName;
            if (qualifiedName.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                sourceNode = qualifiedName.getParent();
            }
        }
        return sourceNode;
    }

    public final AstEditor getEditor() {
        return this.m_editor;
    }

    protected final void saveEdit() throws Exception {
        if (this.getArbitraryValue(FLAG_DONT_COMMIT_EDITOR) == null) {
            this.m_editor.commitChanges();
        }
    }

    public final ComponentDescription getDescription() {
        return this.m_description;
    }

    public boolean canBeRoot() {
        return false;
    }

    public Map<String, String> getTemplateArguments() {
        return this.m_templateArguments != null ? Collections.unmodifiableMap(this.m_templateArguments) : this.m_templateArguments;
    }

    public void putTemplateArgument(String name, String value) {
        if (this.m_templateArguments == null) {
            this.m_templateArguments = new HashMap<String, String>();
        }
        this.m_templateArguments.put(name, value);
    }

    public void putTemplateArguments(Map<String, String> templateArguments) {
        if (templateArguments != null && !templateArguments.isEmpty()) {
            for (Map.Entry<String, String> argument : templateArguments.entrySet()) {
                this.putTemplateArgument(argument.getKey(), argument.getValue());
            }
        }
    }

    public final JavaInfo getParentJava() {
        return (JavaInfo)this.getParent();
    }

    public final JavaInfo getRootJava() {
        return (JavaInfo)this.getRoot();
    }

    public final List<JavaInfo> getChildrenJava() {
        return this.getChildren(JavaInfo.class);
    }

    public Association getAssociation() {
        return this.m_association;
    }

    public void setAssociation(Association association) throws Exception {
        ((JavaInfoSetAssociationBefore)this.getBroadcast(JavaInfoSetAssociationBefore.class)).invoke(this, association);
        this.m_association = association;
        if (this.m_association != null) {
            this.m_association.setJavaInfo(this);
        }
    }

    public final JavaEventListener getBroadcastJava() {
        return (JavaEventListener)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<JavaEventListener>(){

            public JavaEventListener runObject() throws Exception {
                return (JavaEventListener)JavaInfo.this.getBroadcast(JavaEventListener.class);
            }
        });
    }

    protected void initialize() throws Exception {
        this.m_initialized = true;
        if (this.m_object != null) {
            this.createExposedChildren();
        }
        ImportantPropertiesDialog.scheduleImportantProperties(this);
        List participators = ExternalFactoriesHelper.getElementsInstances(IJavaInfoInitializationParticipator.class, (String)"org.eclipse.wb.core.java.javaInfoInitializationParticipators", (String)"participator");
        for (IJavaInfoInitializationParticipator participator : participators) {
            participator.process(this);
        }
    }

    public void createExposedChildren() throws Exception {
    }

    private void scheduleSendingObjectReady() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void refreshDispose() throws Exception {
                JavaInfo.this.m_objectReady = false;
            }
        });
        String objectReadyScript = JavaInfoUtils.getParameter(this, "objectReadyValidator");
        if (objectReadyScript != null) {
            this.addBroadcastListener(new EvaluationEventListener(){

                @Override
                public void evaluateAfter(EvaluationContext context, ASTNode node) throws Exception {
                    if (JavaInfo.this.getObject() != null) {
                        JavaInfo.this.processObjectReady();
                    }
                }
            });
        } else {
            this.addBroadcastListener(new JavaInfoSetObjectAfter(){

                @Override
                public void invoke(JavaInfo target, Object o) throws Exception {
                    if (target == JavaInfo.this.m_this && !JavaInfo.this.m_this.isDeleted()) {
                        JavaInfo.this.processObjectReady();
                    }
                }
            });
        }
    }

    public final boolean isObjectReady() {
        return this.m_objectReady;
    }

    protected void processObjectReady() throws Exception {
        if (this.m_objectReady) {
            return;
        }
        String objectReadyScript = JavaInfoUtils.getParameter(this, "objectReadyValidator");
        if (StringUtils.isEmpty((String)objectReadyScript)) {
            this.processObjectReadyInternal();
        } else {
            Boolean result = (Boolean)JavaInfoUtils.executeScript(this.m_this, objectReadyScript);
            if (result != null && result.booleanValue()) {
                this.processObjectReadyInternal();
            }
        }
    }

    protected final void processObjectReadyInternal() throws Exception {
        this.m_objectReady = true;
        this.m_description.visit(this.m_this, 1);
    }

    /*
     * WARNING - void declaration
     */
    protected List<Property> getPropertyList() throws Exception {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (this.m_descriptionBasedProperties == null) {
            this.m_descriptionBasedProperties = new ArrayList<GenericPropertyImpl>();
            for (GenericPropertyDescription description : this.getDescription().getProperties()) {
                GenericPropertyImpl property = PropertyUtils2.createGenericPropertyImpl(this, description);
                this.m_descriptionBasedProperties.add(property);
            }
        }
        properties.addAll(this.m_descriptionBasedProperties);
        this.addConfigurableProperties(properties);
        if (PropertyUtils.getChildren((Property)this.m_eventsProperty).length != 0) {
            properties.add((Property)this.m_eventsProperty);
        }
        this.m_creationSupport.addProperties(properties);
        this.m_variableSupport.addProperties(properties);
        this.m_association.addProperties(properties);
        if (this.m_componentClassProperty != null) {
            properties.add(this.m_componentClassProperty);
        }
        ((ObjectInfoAddProperties)this.getBroadcast(ObjectInfoAddProperties.class)).invoke((ObjectInfo)this, properties);
        ((JavaInfoAddProperties)this.getBroadcast(JavaInfoAddProperties.class)).invoke(this, properties);
        Iterator I = properties.iterator();
        while (I.hasNext()) {
            void genericProperty;
            Property property = (Property)I.next();
            Property property2 = property;
            if (!(property2 instanceof GenericPropertyImpl)) continue;
            GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property2;
            GenericPropertyImpl cfr_ignored_1 = (GenericPropertyImpl)property2;
            if (!genericProperty.getAccessors().isEmpty()) continue;
            I.remove();
        }
        return properties;
    }

    private void addConfigurableProperties(List<Property> properties) throws Exception {
        if (this.m_configurableProperties == null) {
            this.m_configurableProperties = new ArrayList<Property>();
            for (ConfigurablePropertyDescription description : this.getDescription().getConfigurableProperties()) {
                String id = description.getId();
                IConfigurablePropertyFactory factory = JavaInfo.getConfigurablePropertyFactory(id);
                Assert.isNotNull((Object)factory, (String)"Can not find IConfigurablePropertyFactory for %s.", (Object[])new Object[]{id});
                Property property = factory.create(this, description);
                Assert.isNotNull((Object)property, (String)"Property for for %s and %s was not created.", (Object[])new Object[]{id, this});
                this.m_configurableProperties.add(property);
            }
        }
        properties.addAll(this.m_configurableProperties);
    }

    private static IConfigurablePropertyFactory getConfigurablePropertyFactory(String id) {
        List factoryElements = ExternalFactoriesHelper.getElements((String)"org.eclipse.wb.core.configurablePropertyFactories", (String)"factory");
        for (IConfigurationElement factofyElement : factoryElements) {
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)factofyElement, (String)"id").equals(id)) continue;
            return (IConfigurablePropertyFactory)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)factofyElement, (String)"class");
        }
        return null;
    }

    public final void setCreationSupport(CreationSupport creationSupport) throws Exception {
        this.m_creationSupport = creationSupport;
        this.m_creationSupport.setJavaInfo(this);
    }

    public final CreationSupport getCreationSupport() {
        return this.m_creationSupport;
    }

    public void bindToExpression(Expression expression) {
        EditorState.get(this.m_editor).getJavaInfoResolver().bind(this, expression);
    }

    public int getSourcePosition() {
        return this.getCreationSupport().getNode().getStartPosition();
    }

    public final VariableSupport getVariableSupport() {
        return this.m_variableSupport;
    }

    public final void setVariableSupport(VariableSupport variableSupport) throws Exception {
        VariableSupport oldVariable = this.m_variableSupport;
        this.m_variableSupport = variableSupport;
        ((JavaInfoSetVariable)this.getBroadcastSupport().getListener(JavaInfoSetVariable.class)).invoke(this.m_this, oldVariable, this.m_variableSupport);
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    public final void addRelatedNode(ASTNode node) {
        if (node != null && !this.m_nodes.contains(node)) {
            this.m_nodes.add(node);
        }
    }

    public final void addRelatedNodes(ASTNode start) {
        start.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY || node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    return;
                }
                if (JavaInfo.this.isRepresentedBy(node)) {
                    JavaInfo.this.addRelatedNode(node);
                }
            }

            public void endVisit(MethodInvocation node) {
                if (node.getExpression() == null && JavaInfo.this.isRepresentedBy(null)) {
                    JavaInfo.this.addRelatedNode((ASTNode)node);
                }
            }
        });
    }

    public final List<ASTNode> getRelatedNodes() {
        AstNodeUtils.removeDanglingNodes(this.m_nodes);
        return this.m_nodes;
    }

    public final boolean canDelete() {
        boolean canDeleteBoolean = (Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                Object canDeleteObject = JavaInfoUtils.executeScriptParameter(JavaInfo.this.m_this, "canDelete");
                if (canDeleteObject == null) {
                    return true;
                }
                if (canDeleteObject instanceof Boolean) {
                    return (boolean)((Boolean)canDeleteObject);
                }
                return false;
            }
        }, (Object)false);
        if (!canDeleteBoolean) {
            return false;
        }
        if (!this.m_creationSupport.canDelete()) {
            return false;
        }
        if (!this.m_association.canDelete()) {
            return false;
        }
        this.putArbitraryValue("we are in process of deleting", Boolean.TRUE);
        try {
            for (ObjectInfo child : this.getChildren()) {
                if (child.canDelete()) continue;
                return false;
            }
        }
        finally {
            this.removeArbitraryValue("we are in process of deleting");
        }
        return true;
    }

    public void delete() throws Exception {
        final ObjectInfo parent = this.getParent();
        ObjectInfo hierarchyObject = parent != null ? parent : this;
        ExecutionUtils.run((ObjectInfo)hierarchyObject, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                JavaInfo.this.putArbitraryValue("we are in process of deleting", Boolean.TRUE);
                try {
                    ObjectInfoDelete deleteBroadcast = (ObjectInfoDelete)JavaInfo.this.getBroadcast(ObjectInfoDelete.class);
                    deleteBroadcast.before(parent, (ObjectInfo)JavaInfo.this.m_this);
                    JavaInfo.this.m_association.remove();
                    VariableSupport variableSupport = JavaInfo.this.m_variableSupport;
                    variableSupport.deleteBefore();
                    JavaInfo.this.m_creationSupport.delete();
                    variableSupport.deleteAfter();
                    deleteBroadcast.after(parent, (ObjectInfo)JavaInfo.this.m_this);
                }
                finally {
                    JavaInfo.this.removeArbitraryValue("we are in process of deleting");
                }
            }
        });
    }

    protected StatementTarget getMethodInvocationTarget(String newSignature) throws Exception {
        MethodDescription newDescription = this.getDescription().getMethod(newSignature);
        if (newDescription != null) {
            return newDescription.getOrder().getTarget(this, newSignature);
        }
        return this.getDescription().getDefaultMethodOrder().getTarget(this, newSignature);
    }

    public final MethodInvocation getMethodInvocation(ASTNode relatedNode) {
        if (relatedNode.getLocationInParent() == MethodInvocation.EXPRESSION_PROPERTY) {
            return (MethodInvocation)relatedNode.getParent();
        }
        if (relatedNode instanceof MethodInvocation && ((MethodInvocation)relatedNode).getExpression() == null && this.isRepresentedBy(null)) {
            return (MethodInvocation)relatedNode;
        }
        return null;
    }

    public final List<MethodInvocation> getMethodInvocations() {
        ArrayList<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
        for (ASTNode node : this.getRelatedNodes()) {
            MethodInvocation invocation = this.getMethodInvocation(node);
            if (invocation == null) continue;
            invocations.add(invocation);
        }
        return invocations;
    }

    public final List<MethodInvocation> getMethodInvocations(String signature) {
        ArrayList<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
        for (ASTNode node : this.getRelatedNodes()) {
            String methodSignature;
            MethodInvocation invocation = this.getMethodInvocation(node);
            if (invocation == null || !signature.equals(methodSignature = AstNodeUtils.getMethodSignature(invocation)) || !this.isRepresentedBy((ASTNode)invocation.getExpression())) continue;
            invocations.add(invocation);
        }
        return invocations;
    }

    public final MethodInvocation getMethodInvocation(String signature) {
        List<MethodInvocation> invocations = this.getMethodInvocations(signature);
        return (MethodInvocation)GenericsUtils.getFirstOrNull(invocations);
    }

    public final MethodInvocation addMethodInvocation(String signature, String arguments) throws Exception {
        StatementTarget target = this.getMethodInvocationTarget(signature);
        return this.addMethodInvocation(target, signature, arguments);
    }

    public final MethodInvocation addMethodInvocation(StatementTarget target, String signature, String arguments) throws Exception {
        String methodName = StringUtils.substringBefore((String)signature, (String)"(");
        String invocationSource = TemplateUtils.format("{0}.{1}({2})", new Object[]{this, methodName, arguments});
        return (MethodInvocation)this.addExpressionStatement(target, invocationSource);
    }

    public final void removeMethodInvocations(String signature) throws Exception {
        List<MethodInvocation> invocations = this.getMethodInvocations(signature);
        for (MethodInvocation invocation : invocations) {
            this.m_editor.removeEnclosingStatement((ASTNode)invocation);
        }
    }

    public final Expression addExpressionStatement(String expressionSource) throws Exception {
        StatementTarget target = this.m_variableSupport.getStatementTarget();
        return this.addExpressionStatement(target, expressionSource);
    }

    public final Expression addExpressionStatement(StatementTarget target, String expressionSource) throws Exception {
        expressionSource = TemplateUtils.resolve(target, expressionSource);
        String statementSource = expressionSource + ";";
        ExpressionStatement statement = (ExpressionStatement)this.m_editor.addStatement(statementSource, target);
        Expression expression = statement.getExpression();
        this.addRelatedNodes((ASTNode)statement);
        return expression;
    }

    public final Expression replaceExpression(Expression expression, String source) throws Exception {
        Statement targetStatement = AstNodeUtils.getEnclosingStatement((ASTNode)expression);
        StatementTarget target = new StatementTarget(targetStatement, true);
        source = TemplateUtils.resolve(target, source);
        return this.getEditor().replaceExpression(expression, source);
    }

    public final List<Assignment> getFieldAssignments() {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        for (ASTNode node : this.getRelatedNodes()) {
            Expression fieldAccess = AstNodeUtils.getFieldAssignment(node);
            if (fieldAccess == null) continue;
            Assignment assignment = (Assignment)fieldAccess.getParent();
            assignments.add(assignment);
        }
        return assignments;
    }

    public final List<Assignment> getFieldAssignments(String fieldName) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        for (Assignment assignment : this.getFieldAssignments()) {
            Expression fieldAccess = assignment.getLeftHandSide();
            String fieldAccessName = AstNodeUtils.getFieldAccessName(fieldAccess).getIdentifier();
            if (!fieldName.equals(fieldAccessName)) continue;
            assignments.add(assignment);
        }
        return assignments;
    }

    public final Assignment getFieldAssignment(String fieldName) {
        List<Assignment> assignments = this.getFieldAssignments(fieldName);
        return (Assignment)GenericsUtils.getFirstOrNull(assignments);
    }

    public final Assignment addFieldAssignment(String fieldName, String source) throws Exception {
        String assignmentSource = TemplateUtils.format("{0}.{1} = {2}", new Object[]{this, fieldName, source});
        return (Assignment)this.addExpressionStatement(assignmentSource);
    }

    public final void removeFieldAssignments(String fieldName) throws Exception {
        List<Assignment> assignments = this.getFieldAssignments(fieldName);
        for (Assignment assignment : assignments) {
            if (AstNodeUtils.isDanglingNode((ASTNode)assignment)) continue;
            this.m_editor.removeEnclosingStatement((ASTNode)assignment);
        }
    }

    public boolean isRepresentedBy(ASTNode node) {
        return this.getChildRepresentedBy(node) == this;
    }

    public JavaInfo getChildRepresentedBy(ASTNode node) {
        if (node == null || node instanceof Expression) {
            JavaInfoResolver resolver = EditorState.get(this.m_editor).getJavaInfoResolver();
            return resolver.getJavaInfo((Expression)node);
        }
        return null;
    }

    public void refresh_dispose() throws Exception {
        this.m_object = null;
        super.refresh_dispose();
    }

    public void refresh_beforeCreate() throws Exception {
        if (this.isRoot()) {
            GlobalStateJava.activate(this);
        }
        super.refresh_beforeCreate();
    }

    public void refresh_create() throws Exception {
        ExecutionFlowDescription flowDescription = EditorState.get(this.m_editor).getFlowDescription();
        final EditorState editorState = EditorState.get(this.m_editor);
        editorState.getBadRefreshNodes().clear();
        editorState.setTmp_visitingContext(new ExecutionFlowUtils.VisitingContext(false));
        editorState.getTmp_InterceptedMethods().clear();
        editorState.setExecuting(true);
        final VisitedNodes visitedNodes = editorState.getVisitedNodes();
        visitedNodes.clear();
        final EvaluationEventListener evaluationListener = (EvaluationEventListener)this.getBroadcast(EvaluationEventListener.class);
        this.m_evaluationHelper = null;
        ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor = new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            public void postVisit(ASTNode node) {
                visitedNodes.add(node);
                try {
                    EvaluationContext context;
                    JavaInfoEvaluationHelper evaluationHelper = JavaInfo.this.getEvaluationHelper(this);
                    if (this.shouldNotifyAboutEvaluate(node)) {
                        context = JavaInfo.this.getEvaluationHelper(this).getContext();
                        evaluationListener.evaluateBefore(context, node);
                    }
                    evaluationHelper.evaluate(node);
                    if (this.shouldNotifyAboutEvaluate(node)) {
                        context = JavaInfo.this.getEvaluationHelper(this).getContext();
                        evaluationListener.evaluateAfter(context, node);
                    }
                }
                catch (Throwable e) {
                    if (node instanceof Expression && JavaInfo.this.getChildRepresentedBy(node) != null) {
                        ReflectionUtils.propagate((Throwable)e);
                    }
                    editorState.getBadRefreshNodes().add(node, e);
                }
            }

            private boolean shouldNotifyAboutEvaluate(ASTNode node) {
                return node instanceof ClassInstanceCreation || node instanceof MethodInvocation || node instanceof Statement;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean enterFrame(final ASTNode node) {
                ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ((ExecutionFlowEnterFrame)editorState.getBroadcast().getListener(ExecutionFlowEnterFrame.class)).invoke(node);
                    }
                });
                ASTNode aSTNode = node;
                if (aSTNode instanceof MethodDeclaration) {
                    void methodDeclaration;
                    MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
                    MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
                    if (FactoryDescriptionHelper.isFactoryMethod((MethodDeclaration)methodDeclaration)) {
                        return false;
                    }
                }
                return super.enterFrame(node);
            }

            @Override
            public void leaveFrame(final ASTNode node) {
                super.leaveFrame(node);
                ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        ((EvaluationEventListener)editorState.getBroadcast().getListener(EvaluationEventListener.class)).leaveFrame(node);
                    }
                });
            }
        };
        if (!this.getCreationSupport().canBeEvaluated()) {
            this.getEvaluationHelper(visitor).evaluateJavaInfoUsingCreationSupport(this);
        }
        ExecutionFlowUtils.visit(editorState.getTmp_visitingContext(), flowDescription, visitor);
        editorState.setExecuting(false);
        this.highlightVisitedNodes(visitedNodes);
    }

    private void highlightVisitedNodes(VisitedNodes visitedNodes) throws JavaModelException {
        if (EnvironmentUtils.DEVELOPER_HOST && EnvironmentUtils.isTestingTime()) {
            return;
        }
        DesignPageSite site = DesignPageSite.Helper.getSite((ObjectInfo)this);
        if (site != null) {
            AstEditor editor = this.getEditor();
            String editorSource = editor.getSource();
            String unitSource = editor.getModelUnit().getSource();
            boolean bl = editorSource.equals(unitSource);
        }
    }

    private JavaInfoEvaluationHelper getEvaluationHelper(ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) {
        if (this.m_evaluationHelper == null) {
            this.m_evaluationHelper = new JavaInfoEvaluationHelper(this.m_editor, visitor){

                @Override
                protected JavaInfo getRootJavaInfo() {
                    return JavaInfo.this.m_this;
                }

                @Override
                protected JavaInfo getJavaInfoRepresentedBy(Expression expression) {
                    return JavaInfo.this.m_this.getChildRepresentedBy((ASTNode)expression);
                }

                @Override
                protected void thisJavaInfoNodeProcessed(JavaInfo javaInfo, ASTNode node) throws Exception {
                }
            };
        }
        return this.m_evaluationHelper;
    }

    protected void refresh_afterCreate() throws Exception {
        super.refresh_afterCreate();
        if (!this.isPlaceholder()) {
            JavaInfoUtils.executeScriptParameter(this, "refresh_afterCreate");
        }
    }

    public final boolean isPlaceholder() {
        return PlaceholderUtils.isPlaceholder(this);
    }

    public final Object getObject() {
        return this.m_object;
    }

    public void setObject(Object object) throws Exception {
        Object[] objectRef = new Object[]{object};
        ((JavaInfosetObjectBefore)this.getBroadcast(JavaInfosetObjectBefore.class)).invoke(this, objectRef);
        this.m_object = object = objectRef[0];
        if (!this.m_initialized && !this.isPlaceholder()) {
            this.initialize();
        }
        ((JavaInfoSetObjectAfter)this.getBroadcast(JavaInfoSetObjectAfter.class)).invoke(this, object);
    }

    public final JavaInfo getChildByObject(final Object o) {
        if (o == null) {
            return null;
        }
        final JavaInfo[] result = new JavaInfo[1];
        this.accept(new ObjectInfoVisitor(){

            /*
             * WARNING - void declaration
             */
            public boolean visit(ObjectInfo objectInfo) throws Exception {
                ObjectInfo objectInfo2;
                if (result[0] == null && (objectInfo2 = objectInfo) instanceof JavaInfo) {
                    void javaInfo;
                    JavaInfo javaInfo2 = (JavaInfo)objectInfo2;
                    JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo2;
                    if (javaInfo.getObject() == o) {
                        result[0] = javaInfo;
                    }
                }
                return result[0] == null;
            }
        });
        return result[0];
    }

    public boolean shouldEvaluateInvocation(MethodInvocation invocation) {
        IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
        MethodDescription methodDescription = this.getDescription().getMethod(methodBinding);
        return methodDescription != null && methodDescription.isExecutable();
    }
}

