/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.beans;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.ObserveComparator;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.model.reference.StringReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.decorate.IObserveDecorator;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.swing.databinding.Activator;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.ElPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.ObjectPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.PropertiesObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.decorate.BeanDecorationInfo;
import org.eclipse.wb.internal.swing.databinding.model.decorate.DecorationUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.utils.SwingImageUtils;

public final class BeanSupport {
    private final Map<Class<?>, ImageDescriptor> m_classToImage = new HashMap();
    private boolean m_addELProperty = true;
    private boolean m_addSelfProperty = true;
    private final Map<Class<?>, List<PropertyDescriptor>> m_classToDescriptors = new HashMap();
    private final IDecorationProvider m_decorationProviderOverInfo = new IDecorationProvider(){

        @Override
        public IObserveDecorator getDecorator(BeanDecorationInfo decorationInfo, IGenericType propertyType, String propertyName, PropertyDescriptor descriptor) {
            return decorationInfo.getDecorator(propertyName);
        }
    };
    private final IDecorationProvider m_decorationProviderOverType = new IDecorationProvider(){

        @Override
        public IObserveDecorator getDecorator(BeanDecorationInfo decorationInfo, IGenericType propertyType, String propertyName, PropertyDescriptor descriptor) {
            if (descriptor.isPreferred()) {
                return IObserveDecorator.BOLD;
            }
            if (descriptor.isExpert()) {
                return IObserveDecorator.ITALIC;
            }
            if (descriptor.isHidden()) {
                return IObserveDecorator.HIDDEN;
            }
            Class<?> propertyClass = propertyType.getRawType();
            if (propertyClass == null || propertyClass == Class.class || propertyClass == Object.class) {
                return IObserveDecorator.HIDDEN;
            }
            if (propertyClass == String.class || Collection.class.isAssignableFrom(propertyClass)) {
                return IObserveDecorator.BOLD;
            }
            if (propertyClass.isArray()) {
                return IObserveDecorator.ITALIC;
            }
            return IObserveDecorator.DEFAULT;
        }
    };

    public void doAddELProperty(boolean addElProperty) {
        this.m_addELProperty = addElProperty;
    }

    public void doAddSelfProperty(boolean addSelfProperty) {
        this.m_addSelfProperty = addSelfProperty;
    }

    public List<PropertyDescriptor> getLocalPropertyDescriptors(Class<?> beanClass) throws Exception {
        List<PropertyDescriptor> descriptors = this.m_classToDescriptors.get(beanClass);
        if (descriptors == null) {
            descriptors = BeanSupport.getPropertyDescriptors(beanClass);
            this.m_classToDescriptors.put(beanClass, descriptors);
            Collections.sort(descriptors, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor descriptor1, PropertyDescriptor descriptor2) {
                    return descriptor1.getName().compareTo(descriptor2.getName());
                }
            });
        }
        return descriptors;
    }

    public List<ObserveInfo> createProperties(ObserveInfo parent, IGenericType objectType) {
        try {
            Class superClass;
            ParameterizedType superType;
            Class<?> objectClass = objectType.getRawType();
            BeanDecorationInfo decorationInfo = DecorationUtils.getDecorationInfo(objectClass);
            IDecorationProvider decorationProvider = decorationInfo == null ? this.m_decorationProviderOverType : this.m_decorationProviderOverInfo;
            ArrayList<ObserveInfo> properties = new ArrayList<ObserveInfo>();
            TypeVariable<Class<Object>> superTypeParameter = null;
            Type superTypeParameterClass = null;
            if (objectClass.getTypeParameters().length == 1 && objectType.getSubTypes().size() == 1) {
                superTypeParameter = objectClass.getTypeParameters()[0];
                superTypeParameterClass = objectType.getSubTypes().get(0).getRawType();
            } else if (objectClass.getGenericSuperclass() instanceof ParameterizedType && (superType = (ParameterizedType)objectClass.getGenericSuperclass()).getActualTypeArguments().length == 1 && superType.getActualTypeArguments()[0] instanceof Class && superType.getRawType() instanceof Class && (superClass = (Class)superType.getRawType()).getTypeParameters().length == 1) {
                superTypeParameter = superClass.getTypeParameters()[0];
                superTypeParameterClass = superType.getActualTypeArguments()[0];
            }
            for (PropertyDescriptor descriptor : this.getLocalPropertyDescriptors(objectClass)) {
                String name = descriptor.getName();
                IGenericType propertyType = GenericUtils.getObjectType(superTypeParameter, superTypeParameterClass, descriptor);
                properties.add(new BeanPropertyObserveInfo(this, parent, name, propertyType, (IReferenceProvider)new StringReferenceProvider(name), decorationProvider.getDecorator(decorationInfo, propertyType, name, descriptor)));
            }
            if (JTextComponent.class.isAssignableFrom(objectClass)) {
                BeanSupport.replaceProperty(properties, "text", new PropertiesObserveInfo(this, parent, "text", ClassGenericType.STRING_CLASS, (IReferenceProvider)new StringReferenceProvider("text"), IObserveDecorator.BOLD, new String[]{"text", "text_ON_ACTION_OR_FOCUS_LOST", "text_ON_FOCUS_LOST"}));
            } else if (JTable.class.isAssignableFrom(objectClass)) {
                this.addElementProperties(properties, parent);
                Collections.sort(properties, ObserveComparator.INSTANCE);
            } else if (JSlider.class.isAssignableFrom(objectClass)) {
                BeanSupport.replaceProperty(properties, "value", new PropertiesObserveInfo(this, parent, "value", ClassGenericType.INT_CLASS, (IReferenceProvider)new StringReferenceProvider("value"), IObserveDecorator.BOLD, new String[]{"value", "value_IGNORE_ADJUSTING"}));
            } else if (JList.class.isAssignableFrom(objectClass)) {
                this.addElementProperties(properties, parent);
                Collections.sort(properties, ObserveComparator.INSTANCE);
            }
            if (this.m_addELProperty && !objectClass.isPrimitive()) {
                properties.add(0, new ElPropertyObserveInfo(parent, objectType));
            }
            if (this.m_addSelfProperty && (parent == null || !(parent instanceof BeanPropertyObserveInfo))) {
                properties.add(0, new ObjectPropertyObserveInfo(objectType));
            }
            return properties;
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            return Collections.emptyList();
        }
    }

    private void addElementProperties(List<ObserveInfo> properties, ObserveInfo parent) throws Exception {
        properties.add(new PropertiesObserveInfo(this, parent, "selectedElement", ClassGenericType.OBJECT_CLASS, (IReferenceProvider)new StringReferenceProvider("selectedElement"), IObserveDecorator.BOLD, new String[]{"selectedElement", "selectedElement_IGNORE_ADJUSTING"}));
        properties.add(new PropertiesObserveInfo(this, parent, "selectedElements", ClassGenericType.LIST_CLASS, (IReferenceProvider)new StringReferenceProvider("selectedElements"), IObserveDecorator.BOLD, new String[]{"selectedElements", "selectedElements_IGNORE_ADJUSTING"}));
    }

    private static void replaceProperty(List<ObserveInfo> properties, String reference, ObserveInfo property) throws Exception {
        int count = properties.size();
        int i = 0;
        while (i < count) {
            if (reference.equals(properties.get(i).getReference())) {
                properties.set(i, property);
                return;
            }
            ++i;
        }
    }

    public static BeanPropertyObserveInfo getProperty(BindingInfo binding, boolean isTarget, String property) throws Exception {
        IObserveInfo component = isTarget ? binding.getTarget() : binding.getModel();
        for (IObserveInfo iobserve : component.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable)) {
            ObserveInfo observe = (ObserveInfo)iobserve;
            if (!property.equals(observe.getReference())) continue;
            return (BeanPropertyObserveInfo)observe;
        }
        return null;
    }

    public static List<PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass) throws Exception {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) {
            List interfaces = CoreUtils.cast((List)ClassUtils.getAllInterfaces(beanClass));
            for (Class i : interfaces) {
                BeanInfo beanInfo = Introspector.getBeanInfo(i);
                BeanSupport.addDescriptors(descriptors, beanInfo.getPropertyDescriptors());
            }
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        BeanSupport.addDescriptors(descriptors, beanInfo.getPropertyDescriptors());
        return descriptors;
    }

    private static void addDescriptors(List<PropertyDescriptor> descriptors, PropertyDescriptor[] newDescriptors) {
        int count = descriptors.size();
        if (count > 0) {
            int i = 0;
            while (i < newDescriptors.length) {
                PropertyDescriptor newDescriptor = newDescriptors[i];
                if (newDescriptor.getPropertyType() != null) {
                    String name = newDescriptor.getName();
                    boolean addDescriptor = true;
                    int j = 0;
                    while (j < count) {
                        PropertyDescriptor descriptor = descriptors.get(j);
                        if (name.equals(descriptor.getName())) {
                            addDescriptor = false;
                            break;
                        }
                        ++j;
                    }
                    if (addDescriptor) {
                        descriptors.add(newDescriptor);
                    }
                }
                ++i;
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = newDescriptors;
            int n = newDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                if (descriptor.getPropertyType() != null) {
                    descriptors.add(descriptor);
                }
                ++n2;
            }
        }
    }

    public ImageDescriptor getBeanImageDescriptor(Class<?> beanClass, JavaInfo javaInfo, boolean useDefault) throws Exception {
        if (javaInfo != null) {
            return null;
        }
        ImageDescriptor beanImage = this.m_classToImage.get(beanClass);
        if (beanImage == null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                Image awtBeanIcon = beanInfo.getIcon(1);
                beanImage = awtBeanIcon == null ? (useDefault ? Activator.getImageDescriptor("javabean.gif") : null) : SwingImageUtils.convertImage_AWT_to_SWT((Image)awtBeanIcon);
            }
            catch (Throwable e) {
                beanImage = useDefault ? Activator.getImageDescriptor("javabean.gif") : null;
            }
            this.m_classToImage.put(beanClass, beanImage);
        }
        return beanImage;
    }

    private static interface IDecorationProvider {
        public IObserveDecorator getDecorator(BeanDecorationInfo var1, IGenericType var2, String var3, PropertyDescriptor var4);
    }
}

