/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.actions;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.DeleteAction;
import org.eclipse.wb.internal.core.editor.actions.assistant.LayoutAssistantAction;
import org.eclipse.wb.internal.core.xml.editor.actions.CopyAction;
import org.eclipse.wb.internal.core.xml.editor.actions.CutAction;
import org.eclipse.wb.internal.core.xml.editor.actions.PasteAction;
import org.eclipse.wb.internal.core.xml.editor.actions.RefreshAction;
import org.eclipse.wb.internal.core.xml.editor.actions.TestAction;

public final class DesignPageActions {
    private final IEditPartViewer m_viewer;
    private final IActionBars m_actionBars;
    private final IAction m_cutAction;
    private final IAction m_copyAction;
    private final IAction m_pasteAction;
    private final IAction m_deleteAction;
    private final TestAction m_testAction;
    private final IAction m_refreshAction;
    private final LayoutAssistantAction m_assistantAction;
    private final Map<String, IAction> m_originalActions = new TreeMap<String, IAction>();

    public DesignPageActions(IEditorPart editor, IEditPartViewer viewer) {
        this.m_viewer = viewer;
        this.m_actionBars = editor.getEditorSite().getActionBars();
        this.m_cutAction = new CutAction(this.m_viewer);
        this.m_copyAction = new CopyAction(this.m_viewer);
        this.m_pasteAction = new PasteAction(this.m_viewer);
        this.m_deleteAction = new DeleteAction(this.m_viewer);
        this.m_testAction = new TestAction();
        this.m_refreshAction = new RefreshAction();
        this.m_assistantAction = new LayoutAssistantAction(editor, viewer);
    }

    public void setRoot(ObjectInfo root) {
        this.m_testAction.setRoot(root);
        this.m_assistantAction.setRoot(root);
    }

    public IAction getCutAction() {
        return this.m_cutAction;
    }

    public IAction getCopyAction() {
        return this.m_copyAction;
    }

    public IAction getPasteAction() {
        return this.m_pasteAction;
    }

    public IAction getDeleteAction() {
        return this.m_deleteAction;
    }

    public IAction getTestAction() {
        return this.m_testAction;
    }

    public IAction getRefreshAction() {
        return this.m_refreshAction;
    }

    public LayoutAssistantAction getAssistantAction() {
        return this.m_assistantAction;
    }

    public void installActions() {
        this.m_assistantAction.showWindow();
        this.installAction(this.m_cutAction);
        this.installAction(this.m_copyAction);
        this.installAction(this.m_pasteAction);
        this.installAction(this.m_deleteAction);
        this.installAction(this.m_refreshAction);
        this.m_actionBars.updateActionBars();
    }

    private void installAction(IAction action) {
        String id = action.getId();
        IAction oldAction = this.m_actionBars.getGlobalActionHandler(id);
        if (!this.m_originalActions.containsKey(id)) {
            this.m_originalActions.put(id, oldAction);
            this.m_actionBars.setGlobalActionHandler(id, action);
        }
    }

    public void uninstallActions() {
        this.m_assistantAction.hideWindow();
        for (Map.Entry<String, IAction> entry : this.m_originalActions.entrySet()) {
            String id = entry.getKey();
            IAction action = entry.getValue();
            this.m_actionBars.setGlobalActionHandler(id, action);
        }
        this.m_originalActions.clear();
        this.m_actionBars.updateActionBars();
    }

    public void dispose() {
        this.m_assistantAction.closeWindow();
    }
}

