/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.wizards.autobindings;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.PropertyAdapter;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.AbstractDescriptor;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.AutomaticDatabindingFirstPage;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.DescriptorContainer;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IAutomaticDatabindingProvider;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.PropertiesFilter;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;

public abstract class DefaultAutomaticDatabindingProvider
implements IAutomaticDatabindingProvider {
    private final DescriptorContainer m_widgetContainer;
    private final DescriptorContainer m_strategyContainer;
    protected final Map<PropertyAdapter, AbstractDescriptor[]> m_propertyToEditor = new HashMap<PropertyAdapter, AbstractDescriptor[]>();
    protected final Map<IJavaProject, ClassLoader> m_classLoaders = new HashMap<IJavaProject, ClassLoader>();
    protected ClassLoader m_classLoader;
    protected Class<?> m_beanClass;
    protected IJavaProject m_javaProject;
    protected ICompleteListener m_pageListener;
    protected final ViewerFilter m_propertiesFilter;
    protected CheckboxTableViewer m_propertiesViewer;
    protected Composite m_widgetComposite;
    protected Label m_editorLabel;
    protected Label m_strategyLabel;
    protected CheckboxTableViewer m_editorsViewer;
    protected CheckboxTableViewer m_strategiesViewer;

    public DefaultAutomaticDatabindingProvider(DescriptorContainer widgetContainer, DescriptorContainer strategyContainer) {
        this.m_widgetContainer = widgetContainer;
        this.m_strategyContainer = strategyContainer;
        this.m_propertiesFilter = new PropertiesFilter(this.m_widgetContainer);
    }

    @Override
    public void setCurrentWizardData(AutomaticDatabindingFirstPage firstPage, ICompleteListener pageListener) {
        this.m_javaProject = firstPage.getJavaProject();
        this.m_pageListener = pageListener;
        try {
            this.m_classLoader = this.m_classLoaders.get(this.m_javaProject);
            if (this.m_classLoader == null) {
                this.m_classLoader = ProjectClassLoader.create(null, (IJavaProject)this.m_javaProject);
                this.m_classLoaders.put(this.m_javaProject, this.m_classLoader);
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return CoreUtils.load(this.m_classLoader, className);
    }

    @Override
    public List<PropertyAdapter> getProperties(Class<?> choosenClass) throws Exception {
        this.m_beanClass = choosenClass;
        this.m_propertyToEditor.clear();
        this.setWidgetCompositeEnabled(false);
        return this.getProperties0(this.m_beanClass);
    }

    protected abstract List<PropertyAdapter> getProperties0(Class<?> var1) throws Exception;

    @Override
    public void configurePropertiesViewer(CheckboxTableViewer viewer) {
        this.m_propertiesViewer = viewer;
        this.m_propertiesViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DefaultAutomaticDatabindingProvider.this.handlePropertySelection();
            }
        });
    }

    @Override
    public ViewerFilter getPropertiesViewerFilter() {
        return this.m_propertiesFilter;
    }

    @Override
    public boolean getPropertiesViewerFilterInitState() {
        return true;
    }

    @Override
    public void fillWidgetComposite(Composite widgetComposite) {
        this.m_widgetComposite = widgetComposite;
        GridLayoutFactory.create((Composite)widgetComposite).columns(this.m_strategyContainer == null ? 1 : 2).noMargins();
        this.m_editorLabel = new Label(widgetComposite, 0);
        this.m_editorLabel.setText(Messages.DefaultAutomaticDatabindingProvider_editorLabel);
        if (this.m_strategyContainer != null) {
            this.m_strategyLabel = new Label(widgetComposite, 0);
            this.m_strategyLabel.setText(Messages.DefaultAutomaticDatabindingProvider_strategyLabel);
        }
        this.m_editorsViewer = CheckboxTableViewer.newCheckList((Composite)widgetComposite, (int)68352);
        GridDataFactory.create((Control)this.m_editorsViewer.getControl()).hintVC(20).fill().grabH();
        TableFactory.modify((TableViewer)this.m_editorsViewer).standard().newColumn().width(170).text(Messages.DefaultAutomaticDatabindingProvider_widgetColumn);
        TableFactory.modify((TableViewer)this.m_editorsViewer).standard().newColumn().width(150).text(Messages.DefaultAutomaticDatabindingProvider_propertyColumn);
        this.m_editorsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_editorsViewer.setLabelProvider((IBaseLabelProvider)new DescriptorTableLabelProvider());
        this.m_editorsViewer.setInput(this.m_widgetContainer.getDescriptors());
        new SingleCheckSelectionListener(this.m_editorsViewer, 0);
        if (this.m_strategyContainer != null) {
            this.m_strategiesViewer = CheckboxTableViewer.newCheckList((Composite)widgetComposite, (int)68352);
            GridDataFactory.create((Control)this.m_strategiesViewer.getControl()).fill().grab();
            this.m_strategiesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.m_strategiesViewer.setLabelProvider((IBaseLabelProvider)new DescriptorLabelProvider());
            this.m_strategiesViewer.setInput(this.m_strategyContainer.getDescriptors());
            new SingleCheckSelectionListener(this.m_strategiesViewer, 1);
        }
        this.setWidgetCompositeEnabled(false);
    }

    private void setWidgetCompositeEnabled(boolean enabled) {
        if (!enabled) {
            this.m_editorsViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
            if (this.m_strategiesViewer != null) {
                this.m_strategiesViewer.setCheckedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
        }
        this.m_editorLabel.setEnabled(enabled);
        this.m_editorsViewer.getControl().setEnabled(enabled);
        if (this.m_strategiesViewer != null) {
            this.m_strategyLabel.setEnabled(enabled);
            this.m_strategiesViewer.getControl().setEnabled(enabled);
        }
        this.m_widgetComposite.setEnabled(enabled);
    }

    @Override
    public void handlePropertyChecked(PropertyAdapter property, boolean checked) {
        AbstractDescriptor[] editorData;
        if (checked && (editorData = this.m_propertyToEditor.get(property)) == null) {
            editorData = new AbstractDescriptor[]{this.m_widgetContainer.getDefaultDescriptor(property, true), this.m_strategyContainer == null ? null : this.m_strategyContainer.getDefaultDescriptor(property, true)};
            this.m_propertyToEditor.put(property, editorData);
        }
    }

    protected void handlePropertySelection() {
        IStructuredSelection selection = UiUtils.getSelection((Viewer)this.m_propertiesViewer);
        boolean enabled = !UiUtils.isEmpty((ISelection)selection) && this.m_propertiesViewer.getChecked(selection.getFirstElement());
        this.setWidgetCompositeEnabled(enabled);
        if (enabled) {
            AbstractDescriptor[] editorData = this.m_propertyToEditor.get(selection.getFirstElement());
            this.m_editorsViewer.setCheckedElements(new Object[]{editorData[0]});
            this.m_editorsViewer.setSelection((ISelection)new StructuredSelection((Object)editorData[0]), true);
            if (this.m_strategiesViewer != null) {
                this.m_strategiesViewer.setCheckedElements(new Object[]{editorData[1]});
                this.m_strategiesViewer.setSelection((ISelection)new StructuredSelection((Object)editorData[1]), true);
            }
        }
    }

    protected void handleChangeEditor(AbstractDescriptor newValue, int index) {
        IStructuredSelection selection = UiUtils.getSelection((Viewer)this.m_propertiesViewer);
        AbstractDescriptor[] editorData = this.m_propertyToEditor.get(selection.getFirstElement());
        editorData[index] = newValue;
        this.m_pageListener.calculateFinish();
    }

    @Override
    public String calculateFinish() {
        Object[] elements;
        Object[] objectArray = elements = this.m_propertiesViewer.getCheckedElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            PropertyAdapter property = (PropertyAdapter)element;
            Object[] editorData = this.m_propertyToEditor.get(property);
            if (editorData[0] == null) {
                return MessageFormat.format(Messages.DefaultAutomaticDatabindingProvider_validateNoWidgetForProperty, property.getName());
            }
            if (this.m_strategyContainer != null && editorData[1] == null) {
                return MessageFormat.format(Messages.DefaultAutomaticDatabindingProvider_validateNoStrategyForProperty, property.getName());
            }
            ++n2;
        }
        return null;
    }

    private static class DescriptorLabelProvider
    extends LabelProvider {
        private DescriptorLabelProvider() {
        }

        public String getText(Object element) {
            AbstractDescriptor descriptor = (AbstractDescriptor)element;
            return descriptor.getName();
        }

        public Image getImage(Object element) {
            AbstractDescriptor descriptor = (AbstractDescriptor)element;
            return descriptor.getImage();
        }
    }

    private static class DescriptorTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DescriptorTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            AbstractDescriptor descriptor = (AbstractDescriptor)element;
            return descriptor.getName(columnIndex);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            AbstractDescriptor descriptor = (AbstractDescriptor)element;
            return descriptor.getImage(columnIndex);
        }
    }

    private class SingleCheckSelectionListener
    implements ICheckStateListener {
        private final CheckboxTableViewer m_viewer;
        private final int m_index;

        public SingleCheckSelectionListener(CheckboxTableViewer viewer, int index) {
            this.m_viewer = viewer;
            this.m_index = index;
            this.m_viewer.addCheckStateListener((ICheckStateListener)this);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                Object selection = event.getElement();
                Object[] elements = this.m_viewer.getCheckedElements();
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (element != selection) {
                        this.m_viewer.setChecked(element, false);
                    }
                    ++i;
                }
            }
            AbstractDescriptor descriptor = (AbstractDescriptor)event.getElement();
            DefaultAutomaticDatabindingProvider.this.handleChangeEditor(event.getChecked() ? descriptor : null, this.m_index);
        }
    }
}

