/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.wizards.autobindings;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.AbstractDescriptor;
import org.eclipse.wb.internal.core.databinding.wizards.autobindings.IImageLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DescriptorContainer {
    private final List<AbstractDescriptor> m_descriptors = new ArrayList<AbstractDescriptor>();
    private final List<AbstractDescriptor> m_defaults = new ArrayList<AbstractDescriptor>();

    public List<AbstractDescriptor> getDescriptors() {
        return this.m_descriptors;
    }

    public AbstractDescriptor getDefaultDescriptor(Object propertyDescriptor, boolean ensure) {
        if (this.m_defaults.size() == 1) {
            return this.m_defaults.get(0);
        }
        for (AbstractDescriptor descriptor : this.m_defaults) {
            if (!descriptor.isDefault(propertyDescriptor)) continue;
            return descriptor;
        }
        if (ensure) {
            if (!this.m_defaults.isEmpty()) {
                return this.m_defaults.get(0);
            }
            if (!this.m_descriptors.isEmpty()) {
                return this.m_descriptors.get(0);
            }
        }
        return null;
    }

    private void addDescriptor(AbstractDescriptor descriptor) {
        this.m_descriptors.add(descriptor);
        if (descriptor.isDefault()) {
            this.m_defaults.add(descriptor);
        }
    }

    public static Map<String, DescriptorContainer> parseDescriptors(InputStream stream, final ClassLoader classLoader, final IImageLoader imageLoader) throws Exception {
        final HashMap<String, DescriptorContainer> containers = new HashMap<String, DescriptorContainer>();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(stream, new DefaultHandler(){
            private DescriptorContainer m_container;
            private AbstractDescriptor m_descriptor;
            private Class<?> m_descriptorClass;

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                try {
                    if ("descriptors".equals(name)) {
                        this.m_container = new DescriptorContainer();
                        containers.put(attributes.getValue("name"), this.m_container);
                        this.m_descriptorClass = classLoader.loadClass(attributes.getValue("class"));
                    } else if ("descriptor".equals(name)) {
                        this.m_descriptor = (AbstractDescriptor)this.m_descriptorClass.newInstance();
                    } else if (this.m_descriptor != null) {
                        if (attributes.getLength() == 0) {
                            ReflectionUtils.invokeMethod((Object)this.m_descriptor, (String)(name + "()"), (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY);
                        } else if (name.endsWith("Image")) {
                            try {
                                ReflectionUtils.invokeMethod((Object)this.m_descriptor, (String)(name + "(org.eclipse.swt.graphics.Image)"), (Object[])new Object[]{imageLoader.getImage(attributes.getValue("value"))});
                            }
                            catch (Throwable e) {
                                DesignerPlugin.log((String)("DescriptorContainer: error load image " + attributes.getValue("value")), (Throwable)e);
                            }
                        } else {
                            ReflectionUtils.invokeMethod((Object)this.m_descriptor, (String)(name + "(java.lang.String)"), (Object[])new Object[]{attributes.getValue("value")});
                        }
                    }
                }
                catch (Exception e) {
                    throw new SAXException("startElement", e);
                }
            }

            @Override
            public void endElement(String uri, String localName, String name) throws SAXException {
                if ("descriptors".equals(name)) {
                    this.m_container = null;
                } else if ("descriptor".equals(name)) {
                    this.m_container.addDescriptor(this.m_descriptor);
                    this.m_descriptor = null;
                }
            }
        });
        return containers;
    }
}

