/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.filter.PropertyFilter;
import org.eclipse.wb.internal.core.databinding.ui.providers.ObserveDecoratingLabelProvider;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.databinding.xml.model.SynchronizeManager;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.xml.editor.AbstractXmlEditor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.IObservableFactory;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.AttributeDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.XmlObjectDecorator;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.XmlObjectDeleteManager;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetsObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.property.XmlObjectPropertiesManager;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.providers.BindingLabelProvider;

public final class DatabindingsProvider
implements IDatabindingsProvider {
    private final XmlObjectInfo m_xmlObjectRoot;
    private final List<ObserveTypeContainer> m_containers = new ArrayList<ObserveTypeContainer>();
    private final List<BindingInfo> m_bindings = new ArrayList<BindingInfo>();

    public DatabindingsProvider(XmlObjectInfo xmlObjectRoot) throws Exception {
        this.m_xmlObjectRoot = xmlObjectRoot;
        this.m_containers.add(new BeansObserveTypeContainer());
        this.m_containers.add(new WidgetsObserveTypeContainer());
        for (ObserveTypeContainer container : this.m_containers) {
            container.initialize(this);
        }
    }

    public XmlObjectInfo getXmlObjectRoot() {
        return this.m_xmlObjectRoot;
    }

    public void addWarning(String message, Throwable e) {
        this.m_xmlObjectRoot.getContext().addWarning(new EditorWarning(message, e));
    }

    public List<ObserveTypeContainer> getContainers() {
        return this.m_containers;
    }

    public ObserveTypeContainer getContainer(ObserveType type) {
        if (type == ObserveType.BEANS) {
            return this.m_containers.get(0);
        }
        if (type == ObserveType.WIDGETS) {
            return this.m_containers.get(1);
        }
        return null;
    }

    public void hookXmlObjectEvents() throws Exception {
        new SynchronizeManager((IDatabindingsProvider)this, this.m_xmlObjectRoot);
        new XmlObjectDeleteManager(this);
        new XmlObjectDecorator(this);
        new XmlObjectPropertiesManager(this);
    }

    public void configureBindingViewer(IDialogSettings settings, TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn bindingColumn = new TableColumn(table, 0);
        bindingColumn.setWidth(23);
        bindingColumn.setResizable(false);
        TableColumn targetColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"TargetColumn", (int)250);
        targetColumn.setText(Messages.DatabindingsProvider_targetColumn);
        TableColumn modelColumn = UiUtils.createSmartColumn((Table)table, (IDialogSettings)settings, (String)"ModelColumn", (int)250);
        modelColumn.setText(Messages.DatabindingsProvider_modelColumn);
        TableColumn modeColumn = new TableColumn(table, 0);
        modeColumn.setText(Messages.DatabindingsProvider_modeColumn);
        modeColumn.setWidth(100);
        viewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
    }

    public List<IBindingInfo> getBindings() {
        return CoreUtils.cast(this.m_bindings);
    }

    public List<BindingInfo> getBindings0() {
        return this.m_bindings;
    }

    public String getBindingPresentationText(IBindingInfo binding) throws Exception {
        return null;
    }

    public void gotoDefinition(IBindingInfo ibinding) {
        BindingInfo binding = (BindingInfo)ibinding;
        int position = binding.getDefinitionOffset();
        if (position != -1) {
            IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)this.m_xmlObjectRoot);
            site.openSourcePosition(position);
        }
    }

    public List<ObserveType> getTypes() {
        return ObserveType.TYPES;
    }

    public ObserveType getTargetStartType() {
        return ObserveType.WIDGETS;
    }

    public ObserveType getModelStartType() {
        return ObserveType.BEANS;
    }

    public IBaseLabelProvider createPropertiesViewerLabelProvider(TreeViewer viewer) {
        return new ObserveDecoratingLabelProvider((StructuredViewer)viewer);
    }

    public List<PropertyFilter> getObservePropertyFilters() {
        return org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider.observePropertyFilters();
    }

    public List<IObserveInfo> getObserves(ObserveType type) {
        ObserveTypeContainer container = this.getContainer(type);
        return container == null ? Collections.emptyList() : container.getObservables();
    }

    public void synchronizeObserves() throws Exception {
        for (ObserveTypeContainer container : this.m_containers) {
            container.synchronizeObserves();
        }
    }

    public List<IUiContentProvider> getContentProviders(IBindingInfo ibinding, IPageListener listener) throws Exception {
        ArrayList<IUiContentProvider> providers = new ArrayList<IUiContentProvider>();
        BindingInfo binding = (BindingInfo)ibinding;
        binding.createContentProviders(providers, listener, this);
        return providers;
    }

    public void fillExternalBindingActions(ToolBar toolBar, Menu contextMenu) {
    }

    public boolean validate(IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty) throws Exception {
        if (!(target instanceof WidgetBindableInfo)) {
            return false;
        }
        return org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider.doValidate((List)CoreUtils.cast(this.m_bindings), (IObserveInfo)target, (IObserveInfo)targetProperty, (IObserveInfo)model, (IObserveInfo)modelProperty);
    }

    public IBindingInfo createBinding(IObserveInfo target, IObserveInfo targetProperty, IObserveInfo model, IObserveInfo modelProperty) throws Exception {
        BindableInfo targetBindable = (BindableInfo)target;
        BindableInfo targetBindableProperty = (BindableInfo)targetProperty;
        IObservableFactory targetFactory = targetBindableProperty.getObservableFactory();
        BindableInfo modelBindable = (BindableInfo)model;
        BindableInfo modelBindableProperty = (BindableInfo)modelProperty;
        IObservableFactory modelFactory = modelBindableProperty.getObservableFactory();
        IObservableFactory.Type type = org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider.calculateObserveType((IObservableFactory)targetFactory, (IObservableFactory)modelFactory);
        if (type == IObservableFactory.Type.Input) {
            throw new UnsupportedOperationException();
        }
        BindingInfo binding = new BindingInfo(targetBindable, targetBindableProperty, modelBindable, modelBindableProperty);
        binding.setDocumentEditor(new AttributeDocumentEditor(binding));
        return binding;
    }

    public void addBinding(final IBindingInfo ibinding) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                binding.create();
                binding.getDocumentEditor().add();
                DatabindingsProvider.this.m_bindings.add(binding);
            }
        });
    }

    public void editBinding(final IBindingInfo ibinding) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                binding.getDocumentEditor().update();
            }
        });
    }

    public void deleteBinding(final IBindingInfo ibinding) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                BindingInfo binding = (BindingInfo)ibinding;
                binding.delete();
                binding.getDocumentEditor().delete();
                DatabindingsProvider.this.m_bindings.remove((Object)binding);
            }
        });
    }

    public void deleteAllBindings() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                for (BindingInfo binding : DatabindingsProvider.this.m_bindings) {
                    binding.delete();
                    binding.getDocumentEditor().delete();
                }
                DatabindingsProvider.this.m_bindings.clear();
            }
        });
    }

    public void deleteBindings(JavaInfo javaInfo) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean canMoveBinding(IBindingInfo binding, int targetIndex, boolean upDown) {
        return false;
    }

    public void moveBinding(IBindingInfo binding, int sourceIndex, int targetIndex, boolean upDown) {
        throw new UnsupportedOperationException();
    }

    public void setBindingPage(Object bindingPage) {
    }

    /*
     * WARNING - void declaration
     */
    public void refreshDesigner() {
        IEditorPart editor = DesignerPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart iEditorPart = editor;
        if (iEditorPart instanceof AbstractXmlEditor) {
            void xmlEditor;
            AbstractXmlEditor abstractXmlEditor = (AbstractXmlEditor)iEditorPart;
            AbstractXmlEditor cfr_ignored_0 = (AbstractXmlEditor)iEditorPart;
            xmlEditor.getDesignPage().refreshGEF();
        }
    }

    public void saveEdit() {
    }
}

