/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pshelf;

import org.eclipse.nebula.widgets.pshelf.AbstractRenderer;
import org.eclipse.nebula.widgets.pshelf.PShelf;
import org.eclipse.nebula.widgets.pshelf.PShelfItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RedmondShelfRenderer
extends AbstractRenderer {
    private Color[] initialColors;
    private int textMargin = 2;
    private int margin = 4;
    private PShelf parent;
    private int spacing = 8;
    private Font initialFont;
    private Font initialOpenFont;
    private Color gradient1;
    private Color gradient2;
    private Font font;
    private Font selectedFont;
    private Color selectedGradient1;
    private Color selectedGradient2;
    private Color hoverGradient1;
    private Color hoverGradient2;
    private Color lineColor;
    private Color selectedForeground;
    private Color hoverForeground;
    private Color foreground;

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        PShelfItem item = (PShelfItem)((Object)value);
        int h = 0;
        gc.setFont(this.font);
        h = item.getImage() == null ? gc.getFontMetrics().getHeight() + 2 * this.textMargin : Math.max(item.getImage().getBounds().height, gc.getFontMetrics().getHeight() + 2 * this.textMargin);
        gc.setFont(this.selectedFont);
        h = Math.max(h, gc.getFontMetrics().getHeight() + 2 * this.textMargin);
        if ((h += 2 * this.margin) % 2 != 0) {
            ++h;
        }
        return new Point(wHint, h);
    }

    @Override
    public void paint(GC gc, Object value) {
        int y2;
        PShelfItem item = (PShelfItem)((Object)value);
        Color fore = this.parent.getForeground();
        if (this.isSelected()) {
            gc.setForeground(this.selectedGradient1);
            gc.setBackground(this.selectedGradient2);
        } else if (this.isHover()) {
            gc.setForeground(this.hoverGradient1);
            gc.setBackground(this.hoverGradient2);
        } else {
            gc.setForeground(this.gradient1);
            gc.setBackground(this.gradient2);
        }
        gc.fillGradientRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, true);
        if ((this.parent.getStyle() & 0x40) != 0) {
            if (!this.isSelected()) {
                gc.setForeground(this.lineColor);
                gc.drawLine(0, this.getBounds().y, this.getBounds().width - 1, this.getBounds().y);
            }
        } else {
            if (this.parent.getItems()[0] != item) {
                gc.setForeground(this.lineColor);
                gc.drawLine(0, this.getBounds().y, this.getBounds().width - 1, this.getBounds().y);
            }
            if (this.isSelected()) {
                gc.setForeground(this.lineColor);
                gc.drawLine(0, this.getBounds().y + this.getBounds().height - 1, this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            }
        }
        boolean imageLeft = true;
        if ((this.parent.getStyle() & 0x40) != 0) {
            imageLeft = !this.isSelected();
        }
        int x = 6;
        if (item.getImage() != null && imageLeft) {
            y2 = (this.getBounds().height - item.getImage().getBounds().height) / 2;
            if ((this.getBounds().height - item.getImage().getBounds().height) % 2 != 0) {
                ++y2;
            }
            gc.drawImage(item.getImage(), x, this.getBounds().y + y2);
            x += item.getImage().getBounds().width + this.spacing;
        }
        if (this.isSelected()) {
            gc.setFont(this.selectedFont);
            gc.setForeground(this.selectedForeground != null ? this.selectedForeground : fore);
        } else if (this.isHover()) {
            gc.setFont(this.font);
            gc.setForeground(this.hoverForeground != null ? this.hoverForeground : fore);
        } else {
            gc.setFont(this.font);
            gc.setForeground(this.foreground != null ? this.foreground : fore);
        }
        y2 = (this.getBounds().height - gc.getFontMetrics().getHeight()) / 2;
        if ((this.getBounds().height - gc.getFontMetrics().getHeight()) % 2 != 0) {
            ++y2;
        }
        int textWidth = this.getBounds().width - 12;
        if (item.getImage() != null) {
            textWidth -= item.getImage().getBounds().width;
            textWidth -= 6;
        }
        gc.drawString(RedmondShelfRenderer.getShortString(gc, item.getText(), textWidth), x, this.getBounds().y + y2, true);
        if (item.getImage() != null && !imageLeft) {
            int y3 = (this.getBounds().height - item.getImage().getBounds().height) / 2;
            if ((this.getBounds().height - item.getImage().getBounds().height) % 2 != 0) {
                ++y3;
            }
            gc.drawImage(item.getImage(), this.getBounds().width - 6 - item.getImage().getBounds().width, this.getBounds().y + y3);
        }
        if (this.isFocus()) {
            gc.drawFocus(1, 1, this.getBounds().width - 2, this.getBounds().height - 1);
        }
    }

    @Override
    public void initialize(Control control) {
        this.parent = (PShelf)control;
        FontData fd = this.parent.getFont().getFontData()[0];
        this.initialFont = new Font((Device)this.parent.getDisplay(), fd.getName(), fd.getHeight(), 1);
        Color baseColor = this.parent.getDisplay().getSystemColor(32);
        Color color1 = RedmondShelfRenderer.createNewBlendedColor(baseColor, this.parent.getDisplay().getSystemColor(1), 30);
        baseColor = RedmondShelfRenderer.createNewBlendedColor(this.parent.getDisplay().getSystemColor(32), this.parent.getDisplay().getSystemColor(1), 80);
        Color color2 = RedmondShelfRenderer.createNewSaturatedColor(baseColor, 0.01f);
        if ((this.parent.getStyle() & 0x40) != 0) {
            this.gradient1 = color1;
            this.gradient2 = color2;
        } else {
            this.selectedGradient1 = color1;
            this.selectedGradient2 = color2;
        }
        baseColor.dispose();
        this.lineColor = RedmondShelfRenderer.createNewSaturatedColor(this.parent.getDisplay().getSystemColor(26), 0.02f);
        baseColor = this.parent.getDisplay().getSystemColor(26);
        color1 = RedmondShelfRenderer.createNewBlendedColor(baseColor, this.parent.getDisplay().getSystemColor(1), 70);
        baseColor = RedmondShelfRenderer.createNewBlendedColor(this.parent.getDisplay().getSystemColor(26), this.parent.getDisplay().getSystemColor(2), 80);
        color2 = RedmondShelfRenderer.createNewSaturatedColor(baseColor, 0.02f);
        if ((this.parent.getStyle() & 0x40) != 0) {
            this.selectedGradient1 = color1;
            this.selectedGradient2 = color2;
        } else {
            this.gradient1 = color1;
            this.gradient2 = color2;
        }
        baseColor.dispose();
        this.initialOpenFont = (this.parent.getStyle() & 0x40) != 0 ? new Font((Device)this.parent.getDisplay(), "Arial", 12, 1) : new Font((Device)this.parent.getDisplay(), this.initialFont.getFontData());
        this.font = this.initialFont;
        this.selectedFont = this.initialOpenFont;
        Color inverseColor = this.parent.getDisplay().getSystemColor(27);
        if ((this.parent.getStyle() & 0x40) != 0) {
            this.selectedForeground = inverseColor;
        } else {
            this.foreground = inverseColor;
        }
        baseColor = RedmondShelfRenderer.createNewReverseColor(this.parent.getDisplay().getSystemColor(31));
        this.hoverGradient1 = RedmondShelfRenderer.createNewBlendedColor(baseColor, this.parent.getDisplay().getSystemColor(1), 30);
        Color baseColor2 = RedmondShelfRenderer.createNewBlendedColor(baseColor, this.parent.getDisplay().getSystemColor(1), 99);
        this.hoverGradient2 = RedmondShelfRenderer.createNewSaturatedColor(baseColor2, 0.0f);
        baseColor2.dispose();
        baseColor.dispose();
        this.initialColors = new Color[]{this.gradient1, this.gradient2, this.selectedGradient1, this.selectedGradient2, this.hoverGradient1, this.hoverGradient2, this.lineColor};
    }

    @Override
    public void dispose() {
        this.initialFont.dispose();
        this.initialOpenFont.dispose();
        int i = 0;
        while (i < this.initialColors.length) {
            this.initialColors[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getGradient1() {
        return this.gradient1;
    }

    public void setGradient1(Color gradient1) {
        this.gradient1 = gradient1;
    }

    public Color getGradient2() {
        return this.gradient2;
    }

    public void setGradient2(Color gradient2) {
        this.gradient2 = gradient2;
    }

    public Color getHoverGradient1() {
        return this.hoverGradient1;
    }

    public void setHoverGradient1(Color hoverGradient1) {
        this.hoverGradient1 = hoverGradient1;
    }

    public Color getHoverGradient2() {
        return this.hoverGradient2;
    }

    public void setHoverGradient2(Color hoverGradient2) {
        this.hoverGradient2 = hoverGradient2;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font selectedFont) {
        this.selectedFont = selectedFont;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color selectedForeground) {
        this.selectedForeground = selectedForeground;
    }

    public Color getHoverForeground() {
        return this.hoverForeground;
    }

    public void setHoverForeground(Color hoverForeground) {
        this.hoverForeground = hoverForeground;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getSelectedGradient1() {
        return this.selectedGradient1;
    }

    public void setSelectedGradient1(Color selectedGradient1) {
        this.selectedGradient1 = selectedGradient1;
    }

    public Color getSelectedGradient2() {
        return this.selectedGradient2;
    }

    public void setSelectedGradient2(Color selectedGradient2) {
        this.selectedGradient2 = selectedGradient2;
    }

    private static String getShortString(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        if (t.equals("")) {
            return "";
        }
        if (width >= gc.stringExtent((String)t).x) {
            return t;
        }
        int w = gc.stringExtent((String)"...").x;
        String text = t;
        int l = text.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = text.substring(0, s);
            String s2 = text.substring(e, l);
            int l1 = gc.stringExtent((String)s1).x;
            int l2 = gc.stringExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = String.valueOf(s1) + "..." + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = String.valueOf(text.substring(0, 1)) + "..." + text.substring(l - 1, l);
        }
        return text;
    }

    private static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    private static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = RedmondShelfRenderer.blend(c1.red, c2.red, ratio);
        int g = RedmondShelfRenderer.blend(c1.green, c2.green, ratio);
        int b = RedmondShelfRenderer.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static Color createNewBlendedColor(Color c1, Color c2, int ratio) {
        Color newColor = new Color((Device)Display.getCurrent(), RedmondShelfRenderer.blend(c1.getRGB(), c2.getRGB(), ratio));
        return newColor;
    }

    private static Color createNewReverseColor(Color c) {
        Color newColor = new Color((Device)Display.getCurrent(), 255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
        return newColor;
    }

    private static RGB saturate(RGB rgb, float saturation) {
        float[] hsb = rgb.getHSB();
        hsb[1] = hsb[1] + saturation;
        if (hsb[1] > 1.0f) {
            hsb[1] = 1.0f;
        }
        if (hsb[1] < 0.0f) {
            hsb[1] = 0.0f;
        }
        hsb[0] = (float)((double)hsb[0] + 360.0 * (double)saturation);
        if (hsb[0] > 360.0f) {
            hsb[0] = 360.0f;
        }
        if (hsb[0] < 0.0f) {
            hsb[0] = 0.0f;
        }
        return new RGB(hsb[0], hsb[1], hsb[2]);
    }

    private static Color createNewSaturatedColor(Color c, float saturation) {
        RGB newRGB = RedmondShelfRenderer.saturate(c.getRGB(), saturation);
        return new Color((Device)Display.getCurrent(), newRGB);
    }
}

