/*******************************************************************************
 * Copyright (c) 2000, 2010 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.draw2d;

import org.eclipse.draw2d.geometry.Point;

/**
 * A transparent figure intended to be added exclusively to a
 * {@link LayeredPane}, who has the responsibilty of managing its layers.
 */
public class Layer extends Figure {

	/**
	 * Overridden to implement transparent behavior.
	 *
	 * @see IFigure#containsPoint(int, int)
	 *
	 */
	@Override
	public boolean containsPoint(int x, int y) {
		if (isOpaque())
			return super.containsPoint(x, y);
		Point pt = Point.SINGLETON;
		pt.setLocation(x, y);
		translateFromParent(pt);
		x = pt.x;
		y = pt.y;
		for (IFigure child : getChildren()) {
			if (child.containsPoint(x, y))
				return true;
		}
		return false;
	}

	/**
	 * Overridden to implement transparency.
	 *
	 * @see IFigure#findFigureAt(int, int, TreeSearch)
	 */
	@Override
	public IFigure findFigureAt(int x, int y, TreeSearch search) {
		if (!isEnabled())
			return null;
		if (isOpaque())
			return super.findFigureAt(x, y, search);

		IFigure f = super.findFigureAt(x, y, search);
		if (f == this)
			return null;
		return f;
	}

}
