/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.controls.flyout.MemoryFlyoutPreferences;
import org.eclipse.wb.core.controls.palette.ICategory;
import org.eclipse.wb.core.controls.palette.IEntry;
import org.eclipse.wb.core.controls.palette.IPalette;
import org.eclipse.wb.core.controls.palette.PaletteComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class PaletteTest
implements ColorConstants {
    protected Shell shell;

    public static void main(String[] args) {
        try {
            PaletteTest window = new PaletteTest();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setBounds(600, 300, 800, 600);
        this.shell.setText("SWT Application");
        this.shell.setLayout((Layout)new FillLayout());
        MemoryFlyoutPreferences preferences = new MemoryFlyoutPreferences(1, 0, 200);
        FlyoutControlComposite flyoutControlComposite = new FlyoutControlComposite((Composite)this.shell, 0, preferences);
        flyoutControlComposite.setTitleText("Palette");
        PaletteComposite paletteComposite = new PaletteComposite(flyoutControlComposite.getFlyoutParent(), 0);
        GridDataFactory.create((Control)paletteComposite).grabV().hintHC(30).fill();
        new Composite(flyoutControlComposite.getClientParent(), 2048);
        PaletteImpl palette = new PaletteImpl();
        CategoryImpl category = new CategoryImpl("First category", true);
        palette.addCategory(category);
        category.addEntry(new EntryImpl(true, this.createIcon(red), "AAAAAAAAAAA"));
        category.addEntry(new EntryImpl(false, this.createIcon(green), "BBBBB"));
        category.addEntry(new EntryImpl(true, this.createIcon(blue), "CCCCCCCCCCCCCCC"));
        category.addEntry(new EntryImpl(true, this.createIcon(yellow), "DDDDDDDDD"));
        category.addEntry(new EntryImpl(false, this.createIcon(orange), "EEEEEEEEEEE"));
        category.addEntry(new EntryImpl(true, this.createIcon(cyan), "FFFFF"));
        category = new CategoryImpl("Second category", false);
        palette.addCategory(category);
        category.addEntry(new EntryImpl(true, this.createIcon(red), "0123456789"));
        category.addEntry(new EntryImpl(true, this.createIcon(green), "012345"));
        category.addEntry(new EntryImpl(true, this.createIcon(blue), "0123456789123"));
        category = new CategoryImpl("Third category", true);
        palette.addCategory(category);
        category.addEntry(new EntryImpl(true, this.createIcon(red), "0123456789"));
        category.addEntry(new EntryImpl(true, this.createIcon(green), "012345"));
        category.addEntry(new EntryImpl(true, this.createIcon(blue), "0123456789123"));
        paletteComposite.setPalette(palette);
    }

    private final ImageDescriptor createIcon(Color color) {
        int size = 16;
        Image image = new Image((Device)this.shell.getDisplay(), size, size);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, size, size);
        gc.dispose();
        return ImageDescriptor.createFromImage((Image)image);
    }

    private static final class CategoryImpl
    implements ICategory {
        private final String m_text;
        private boolean m_open;
        private final List<IEntry> m_entries = new ArrayList<IEntry>();

        public CategoryImpl(String text, boolean open) {
            this.m_text = text;
            this.m_open = open;
        }

        public void addEntry(IEntry entry) {
            this.m_entries.add(entry);
        }

        @Override
        public String getText() {
            return this.m_text;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean isOpen() {
            return this.m_open;
        }

        @Override
        public void setOpen(boolean b) {
            this.m_open = b;
        }

        @Override
        public List<IEntry> getEntries() {
            return this.m_entries;
        }
    }

    private static final class EntryImpl
    implements IEntry {
        private final boolean m_enabled;
        private final ImageDescriptor m_icon;
        private final String m_text;

        public EntryImpl(boolean enabled, ImageDescriptor icon, String text) {
            this.m_enabled = enabled;
            this.m_icon = icon;
            this.m_text = text;
        }

        @Override
        public boolean isEnabled() {
            return this.m_enabled;
        }

        @Override
        public ImageDescriptor getIcon() {
            return this.m_icon;
        }

        @Override
        public String getText() {
            return this.m_text;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public boolean activate(boolean reload) {
            return true;
        }
    }

    private static final class PaletteImpl
    implements IPalette {
        private final List<ICategory> m_categories = new ArrayList<ICategory>();

        private PaletteImpl() {
        }

        public void addCategory(ICategory category) {
            this.m_categories.add(category);
        }

        @Override
        public List<ICategory> getCategories() {
            return this.m_categories;
        }

        @Override
        public void addPopupActions(IMenuManager menuManager, Object target, int iconType) {
        }

        @Override
        public void selectDefault() {
        }

        @Override
        public void moveCategory(ICategory category, ICategory nextCategory) {
        }

        @Override
        public void moveEntry(IEntry entry, ICategory targetCategory, IEntry nextEntry) {
        }
    }
}

