/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.position;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wb.core.gef.figure.AbstractPositionFeedback;
import org.eclipse.wb.core.gef.figure.GhostPositionFeedback;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;

public abstract class AbstractPositionLayoutEditPolicy
extends LayoutEditPolicy {
    private TextFeedback m_hintFeedback;
    private List<AbstractPositionFeedback> m_feedbacks;
    private AbstractPositionFeedback m_activeFeedback;

    @Override
    protected final void showLayoutTargetFeedback(Request request) {
        super.showLayoutTargetFeedback(request);
        if (this.m_feedbacks == null) {
            this.m_feedbacks = new ArrayList<AbstractPositionFeedback>();
            try {
                this.addFeedbacks();
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
            this.m_hintFeedback = new TextFeedback(this.getFeedbackLayer());
            this.m_hintFeedback.add();
        }
        this.m_activeFeedback = null;
        Point location = ((DropRequest)request).getLocation();
        for (AbstractPositionFeedback feedback : this.m_feedbacks) {
            if (!feedback.update(location)) continue;
            this.m_activeFeedback = feedback;
        }
        if (this.m_activeFeedback != null) {
            this.m_hintFeedback.setText(this.m_activeFeedback.getHint());
        } else {
            this.m_hintFeedback.setText("<Unknown position>");
        }
        Rectangle target = this.getHostFigure().getBounds().getCopy();
        FigureUtils.translateFigureToFigure((IFigure)this.getHostFigure(), (IFigure)this.getFeedbackLayer(), (Translatable)target);
        this.m_hintFeedback.centerHorizontallyAbove(target, 10);
    }

    @Override
    protected final void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.m_feedbacks != null) {
            for (AbstractPositionFeedback feedback : this.m_feedbacks) {
                feedback.remove();
            }
            this.m_feedbacks = null;
            this.m_hintFeedback.remove();
            this.m_hintFeedback = null;
        }
    }

    protected final void addFeedback(Rectangle bounds, String hint, Object data) {
        Layer layer = this.getFeedbackLayer();
        bounds = bounds.getCopy();
        FigureUtils.translateFigureToFigure2(this.getHostFigure(), layer, (Translatable)bounds);
        GhostPositionFeedback feedback = new GhostPositionFeedback(layer, bounds, hint);
        feedback.setData(data);
        this.m_feedbacks.add(feedback);
    }

    protected final void addFeedback(double px1, double py1, double px2, double py2, Insets insets, String hint, Object data) {
        Rectangle area = this.getHostFigure().getClientArea();
        double offset_x1 = AbstractPositionLayoutEditPolicy.getOffset(area.width, px1);
        double offset_x2 = AbstractPositionLayoutEditPolicy.getOffset(area.width, px2);
        double offset_y1 = AbstractPositionLayoutEditPolicy.getOffset(area.height, py1);
        double offset_y2 = AbstractPositionLayoutEditPolicy.getOffset(area.height, py2);
        int x1 = (int)((double)area.x + offset_x1) + insets.left;
        int y1 = (int)((double)area.y + offset_y1) + insets.top;
        int x2 = (int)((double)area.x + offset_x2) - insets.right;
        int y2 = (int)((double)area.y + offset_y2) - insets.bottom;
        this.addFeedback(new Rectangle(x1, y1, x2 - x1, y2 - y1), hint, data);
    }

    private static double getOffset(int size, double offsetPercent) {
        if (offsetPercent > 1.0) {
            return offsetPercent;
        }
        return (double)size * offsetPercent;
    }

    protected abstract void addFeedbacks() throws Exception;

    @Override
    public Command getCommand(Request request) {
        Command command;
        if (this.m_activeFeedback != null && (command = this.getCommand(request, this.m_activeFeedback.getData())) != null) {
            return command;
        }
        return super.getCommand(request);
    }

    protected Command getCommand(Request request, Object data) {
        return null;
    }

    @Override
    protected final Command getCreateCommand(CreateRequest request) {
        if (this.m_activeFeedback != null) {
            return this.getCreateCommand(request.getNewObject(), this.m_activeFeedback.getData());
        }
        return null;
    }

    protected abstract Command getCreateCommand(Object var1, Object var2);

    @Override
    protected final Command getPasteCommand(PasteRequest request) {
        if (this.m_activeFeedback != null) {
            return this.getPasteCommand(request, this.m_activeFeedback.getData());
        }
        return null;
    }

    protected abstract Command getPasteCommand(PasteRequest var1, Object var2);

    @Override
    protected final Command getMoveCommand(ChangeBoundsRequest request) {
        if (this.m_activeFeedback != null && request.getEditParts().size() == 1) {
            EditPart editPart = request.getEditParts().get(0);
            return this.getMoveCommand(editPart.getModel(), this.m_activeFeedback.getData());
        }
        return null;
    }

    protected abstract Command getMoveCommand(Object var1, Object var2);

    @Override
    protected final Command getAddCommand(ChangeBoundsRequest request) {
        if (this.m_activeFeedback != null && request.getEditParts().size() == 1) {
            EditPart editPart = request.getEditParts().get(0);
            return this.getAddCommand(editPart.getModel(), this.m_activeFeedback.getData());
        }
        return null;
    }

    protected abstract Command getAddCommand(Object var1, Object var2);
}

