/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt;

import java.awt.Image;
import java.beans.BeanInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.IDescriptionProcessor;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.editor.DisplayExpressionPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstParser;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.ImageUtils;

public final class DescriptionProcessor
implements IDescriptionProcessor {
    public static final IDescriptionProcessor INSTANCE = new DescriptionProcessor();

    private DescriptionProcessor() {
    }

    public void process(final AstEditor editor, final ComponentDescription componentDescription) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                new DescriptionProcessor_Single(editor, componentDescription);
            }
        });
    }

    private static void markFirstParameterAsParent(ParameterDescription parameter) {
        if ("false".equals(parameter.getTag("parent"))) {
            return;
        }
        parameter.setParent(true);
    }

    private static class DescriptionProcessor_Single {
        private final ComponentDescription componentDescription;
        private final EditorState editorState;
        private final ClassLoader classLoader;
        private final Class<?> componentClass;
        private final Class<?> compositeClass;
        private final AstEditor editor;

        public DescriptionProcessor_Single(AstEditor editor, ComponentDescription componentDescription) throws Exception {
            this.editor = editor;
            this.componentDescription = componentDescription;
            this.componentClass = componentDescription.getComponentClass();
            this.editorState = EditorState.get((AstEditor)editor);
            this.classLoader = this.editorState.getEditorLoader();
            this.compositeClass = this.classLoader.loadClass("org.eclipse.swt.widgets.Composite");
            this.configureConstructors();
            this.configureDefaultCreation();
            this.markCreateMethodsAsExecutable();
            this.ifHasNoLayout_then_setLayout_isNotAssociation();
            this.configureIconFromBeanInfo();
        }

        private void configureConstructors() throws Exception {
            for (ConstructorDescription constructor : this.componentDescription.getConstructors()) {
                ParameterDescription parameter_1;
                ParameterDescription parameter_0;
                List parameters = constructor.getParameters();
                if (parameters.size() < 1 || !this.isComposite((parameter_0 = (ParameterDescription)parameters.get(0)).getType())) continue;
                DescriptionProcessor.markFirstParameterAsParent(parameter_0);
                if (parameters.size() < 2 || (parameter_1 = (ParameterDescription)parameters.get(1)).getType() != Integer.TYPE) continue;
                this.ensureStylePropertyEditor(parameter_1);
            }
        }

        private void ensureStylePropertyEditor(ParameterDescription parameter) throws Exception {
            boolean hasSpecialPropertyEditor;
            boolean bl = hasSpecialPropertyEditor = parameter.getEditor() instanceof StylePropertyEditor || parameter.getEditor() instanceof DisplayExpressionPropertyEditor;
            if (!hasSpecialPropertyEditor) {
                hasSpecialPropertyEditor = this.configureStylePropertyEditor_fromBeanInfo(parameter);
            }
            if (!hasSpecialPropertyEditor) {
                ComponentDescription superComponentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.editor, this.componentClass.getSuperclass());
                for (ConstructorDescription constructor : superComponentDescription.getConstructors()) {
                    List parameters = constructor.getParameters();
                    if (parameters.size() < 2) continue;
                    ParameterDescription parameter_0 = (ParameterDescription)parameters.get(0);
                    ParameterDescription parameter_1 = (ParameterDescription)parameters.get(1);
                    if (!this.isComposite(parameter_0.getType()) || parameter_1.getType() != Integer.TYPE || !(parameter_1.getEditor() instanceof StylePropertyEditor)) continue;
                    parameter.setEditor(parameter_1.getEditor());
                    parameter.setDefaultSource(parameter_1.getDefaultSource());
                    break;
                }
            }
        }

        private boolean configureStylePropertyEditor_fromBeanInfo(ParameterDescription parameter) throws Exception {
            Object styleObject = this.componentDescription.getBeanDescriptor().getValue("org.eclipse.wb.swt.style");
            if (styleObject instanceof String[][]) {
                String[][] lines;
                TreeMap<Object, String> parameters = new TreeMap<Object, String>();
                parameters.put("class", "org.eclipse.swt.SWT");
                int selectIndex = 0;
                String[][] stringArray = lines = (String[][])styleObject;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] line = stringArray[n2];
                    if (line.length >= 3 && line[0].equals("set") && line[1] == null) {
                        Object setString = "";
                        int i = 2;
                        while (i < line.length) {
                            setString = (String)setString + " ";
                            setString = (String)setString + line[i].toUpperCase(Locale.ENGLISH);
                            ++i;
                        }
                        parameters.put("set", ((String)setString).trim());
                    }
                    if (line.length >= 5 && line[0].equals("select") && line[3] == null) {
                        String title = line[1];
                        String defaultField = line[2].toUpperCase(Locale.ENGLISH);
                        String selectString = title + " " + defaultField;
                        int i = 4;
                        while (i < line.length) {
                            selectString = selectString + " ";
                            selectString = selectString + line[i].toUpperCase(Locale.ENGLISH);
                            ++i;
                        }
                        parameters.put("select" + selectIndex, selectString.trim());
                        ++selectIndex;
                    }
                    ++n2;
                }
                StylePropertyEditor stylePropertyEditor = new StylePropertyEditor();
                stylePropertyEditor.configure(this.editorState, parameters);
                parameter.setEditor((PropertyEditor)stylePropertyEditor);
                return true;
            }
            return false;
        }

        private void configureDefaultCreation() {
            Constructor constructor = ReflectionUtils.getShortestConstructor(this.componentClass);
            if (constructor != null) {
                String source = "new " + this.componentClass.getName() + "(" + this.getConstructorArguments(constructor) + ")";
                CreationDescription creationDefault = new CreationDescription(this.componentDescription, null, null);
                creationDefault.setSource(source);
                this.componentDescription.setCreationDefault(creationDefault);
            }
        }

        private String getConstructorArguments(Constructor<?> constructor) {
            Object arguments = "";
            Class<?>[] parameters = constructor.getParameterTypes();
            boolean wasComposite = false;
            int i = 0;
            while (i < parameters.length) {
                Class<?> parameter = parameters[i];
                if (i == 0 && this.isComposite(parameter)) {
                    arguments = (String)arguments + "%parent%";
                    wasComposite = true;
                } else {
                    arguments = i == 1 && parameter == Integer.TYPE && wasComposite ? (String)arguments + "org.eclipse.swt.SWT.NONE" : (String)arguments + AstParser.getDefaultValue((String)parameter.getCanonicalName());
                }
                arguments = (String)arguments + ", ";
                ++i;
            }
            arguments = StringUtils.removeEnd((String)arguments, (String)", ");
            return arguments;
        }

        private void markCreateMethodsAsExecutable() throws Exception {
            Collection methods = ReflectionUtils.getMethods(this.componentClass).values();
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                if (ReflectionUtils.isPrivate((Method)method) || !method.getName().startsWith("create") || (parameterTypes = method.getParameterTypes()).length == 0 || !this.isComposite(parameterTypes[0])) continue;
                this.componentDescription.addMethod(method);
            }
        }

        private void ifHasNoLayout_then_setLayout_isNotAssociation() {
            if (!this.isComposite(this.componentClass)) {
                return;
            }
            if (!ObjectUtils.equals((Object)this.componentDescription.getParameter("layout.has"), (Object)"false")) {
                return;
            }
            List methods = this.componentDescription.getMethods();
            for (MethodDescription methodDescription : methods) {
                if (!methodDescription.getSignature().equals("setLayout(org.eclipse.swt.widgets.Layout)")) continue;
                methodDescription.getParameter(0).setChild(false);
                break;
            }
        }

        private void configureIconFromBeanInfo() throws Exception {
            Image awtIcon;
            BeanInfo beanInfo = this.componentDescription.getBeanInfo();
            if (beanInfo != null && (awtIcon = beanInfo.getIcon(1)) != null) {
                this.componentDescription.setIcon(ImageUtils.convertToSWT((Image)awtIcon));
            }
        }

        private boolean isComposite(Class<?> type) {
            return this.compositeClass.isAssignableFrom(type);
        }
    }
}

