/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid;

import java.util.List;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.policies.IRefreshableEditPolicy;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;
import org.eclipse.wb.internal.swt.gef.ControlsLayoutRequestValidator;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridHelper;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridSelectionEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.RowHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.layout.ColumnsLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.layout.RowsLayoutEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridRowInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class GridLayoutEditPolicy<C extends IControlInfo>
extends AbstractGridLayoutEditPolicy
implements IRefreshableEditPolicy {
    private final IGridLayoutInfo<C> m_layout;

    public GridLayoutEditPolicy(IGridLayoutInfo<C> layout) {
        super(layout.getUnderlyingModel());
        this.m_layout = layout;
        this.m_gridTargetHelper = new GridHelper((GraphicalEditPolicy)this, true);
        this.m_gridSelectionHelper = new GridHelper((GraphicalEditPolicy)this, false);
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ControlsLayoutRequestValidator.INSTANCE;
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    private boolean isControl(Object model) {
        return model instanceof IControlInfo;
    }

    private C toControl(Object model) {
        return (C)((IControlInfo)model);
    }

    protected void decorateChild(EditPart child) {
        Object model = child.getModel();
        if (this.m_layout.isManagedObject(model)) {
            C control = this.toControl(model);
            GridSelectionEditPolicy<C> selectionPolicy = new GridSelectionEditPolicy<C>(this.m_layout, control);
            child.installEditPolicy((Object)"Selection Feedback", selectionPolicy);
        }
    }

    public void refreshEditPolicy() {
        List children = this.getHost().getChildren();
        for (EditPart child : children) {
            Object model = child.getModel();
            if (!this.isControl(model)) continue;
            if (!this.m_layout.isManagedObject(model)) {
                child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new NonResizableSelectionEditPolicy());
                continue;
            }
            if (child.getEditPolicy((Object)"Selection Feedback") instanceof GridSelectionEditPolicy) continue;
            this.decorateChild(child);
        }
    }

    private boolean isValidTarget() {
        if (!this.m_target.m_valid) {
            return false;
        }
        if (!this.m_layout.canChangeDimensions()) {
            if (this.m_target.m_columnInsert || this.m_target.m_column >= this.m_layout.getColumns().size()) {
                return false;
            }
            if (this.m_target.m_rowInsert && !this.m_layout.isExplicitRow(this.m_target.m_row)) {
                return false;
            }
        }
        return true;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object newObject;
        if (this.isValidTarget() && this.isControl(newObject = request.getNewObject())) {
            C control = this.toControl(newObject);
            return new EditCommand(this.m_layout, (IControlInfo)control){
                private final /* synthetic */ IControlInfo val$control;
                {
                    this.val$control = iControlInfo;
                    super($anonymous0);
                }

                protected void executeEdit() throws Exception {
                    GridLayoutEditPolicy.this.m_layout.command_CREATE(this.val$control, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_column, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_columnInsert, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_row, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getPasteCommand(PasteRequest request) {
        List mementos = (List)request.getMemento();
        if (this.isValidTarget() && mementos.size() == 1) {
            return GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

                public void process(Object component) throws Exception {
                    GridLayoutEditPolicy.this.m_layout.command_CREATE(GridLayoutEditPolicy.this.toControl(component), ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_column, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_columnInsert, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_row, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            });
        }
        return null;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        EditPart moveEditPart;
        Object model;
        if (this.isValidTarget() && request.getEditParts().size() == 1 && this.isControl(model = (moveEditPart = (EditPart)request.getEditParts().get(0)).getModel())) {
            C control = this.toControl(model);
            return new EditCommand(this.m_layout, (IControlInfo)control){
                private final /* synthetic */ IControlInfo val$control;
                {
                    this.val$control = iControlInfo;
                    super($anonymous0);
                }

                protected void executeEdit() throws Exception {
                    GridLayoutEditPolicy.this.m_layout.command_MOVE(this.val$control, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_column, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_columnInsert, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_row, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        EditPart moveEditPart;
        Object model;
        if (this.isValidTarget() && request.getEditParts().size() == 1 && this.isControl(model = (moveEditPart = (EditPart)request.getEditParts().get(0)).getModel())) {
            C control = this.toControl(model);
            return new EditCommand(this.m_layout, (IControlInfo)control){
                private final /* synthetic */ IControlInfo val$control;
                {
                    this.val$control = iControlInfo;
                    super($anonymous0);
                }

                protected void executeEdit() throws Exception {
                    GridLayoutEditPolicy.this.m_layout.command_ADD(this.val$control, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_column, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_columnInsert, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_row, ((GridLayoutEditPolicy)GridLayoutEditPolicy.this).m_target.m_rowInsert);
                }
            };
        }
        return null;
    }

    public static int[] getInsertFeedbackParameters(Interval interval, Interval nextInterval, int minGap) {
        int b;
        int gap = nextInterval.begin() - interval.end();
        int visualGap = Math.max(gap, minGap);
        int a = interval.end();
        int x1_2 = a + (b = nextInterval.begin()) - visualGap;
        int x1 = x1_2 % 2 == 0 ? x1_2 / 2 : x1_2 / 2 - 1;
        int x2 = a + b - x1;
        if (x1 == a - 1) {
            // empty if block
        }
        return new int[]{visualGap, --x1, ++x2, x1 - minGap, x2 + minGap};
    }

    protected void updateGridTarget(Point mouseLocation) throws Exception {
        int[] parameters;
        boolean nearBegin;
        boolean nearEnd;
        boolean narrowGap;
        boolean directGap;
        int[] parameters2;
        Interval nextInterval;
        Interval interval;
        boolean isLast;
        int lastY;
        this.m_target = new AbstractGridLayoutEditPolicy.GridTarget();
        Point location = mouseLocation.getCopy();
        PolicyUtils.translateAbsoluteToModel((LayoutEditPolicy)this, (Translatable)location);
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int lastX = columnIntervals.length != 0 ? columnIntervals[columnIntervals.length - 1].end() : gridInfo.getInsets().left;
        int n = lastY = rowIntervals.length != 0 ? rowIntervals[rowIntervals.length - 1].end() : gridInfo.getInsets().top;
        if (columnIntervals.length != 0) {
            this.m_target.m_rowInsertBounds.x = columnIntervals[0].begin() - 5;
            this.m_target.m_rowInsertBounds.setRight(lastX + 5);
        } else {
            this.m_target.m_rowInsertBounds.x = 0;
            this.m_target.m_rowInsertBounds.setRight(this.getHostFigure().getSize().width);
        }
        if (rowIntervals.length != 0) {
            this.m_target.m_columnInsertBounds.y = rowIntervals[0].begin() - 5;
            this.m_target.m_columnInsertBounds.setBottom(lastY + 5);
        } else {
            this.m_target.m_columnInsertBounds.y = 0;
            this.m_target.m_columnInsertBounds.setBottom(this.getHostFigure().getSize().height);
        }
        int columnIndex = 0;
        while (columnIndex < columnIntervals.length) {
            isLast = columnIndex == columnIntervals.length - 1;
            interval = columnIntervals[columnIndex];
            Interval interval2 = nextInterval = !isLast ? columnIntervals[columnIndex + 1] : null;
            if (location.x < columnIntervals[0].begin()) {
                this.m_target.m_column = 0;
                this.m_target.m_columnInsert = true;
                parameters2 = GridLayoutEditPolicy.getInsertFeedbackParameters(new Interval(0, 0), interval, 7);
                this.m_target.m_feedbackBounds.x = parameters2[3];
                this.m_target.m_feedbackBounds.width = parameters2[4] - parameters2[3];
                this.m_target.m_columnInsertBounds.x = parameters2[1];
                this.m_target.m_columnInsertBounds.width = parameters2[2] - parameters2[1];
                break;
            }
            if (!isLast) {
                int gap = nextInterval.begin() - interval.end();
                directGap = interval.end() <= location.x && location.x < nextInterval.begin();
                narrowGap = gap < 14;
                nearEnd = Math.abs(location.x - interval.end()) < 7;
                boolean bl = nearBegin = Math.abs(location.x - nextInterval.begin()) < 7;
                if (directGap || narrowGap && (nearEnd || nearBegin)) {
                    this.m_target.m_column = columnIndex + 1;
                    this.m_target.m_columnInsert = true;
                    parameters = GridLayoutEditPolicy.getInsertFeedbackParameters(interval, nextInterval, 7);
                    this.m_target.m_feedbackBounds.x = parameters[3];
                    this.m_target.m_feedbackBounds.width = parameters[4] - parameters[3];
                    this.m_target.m_columnInsertBounds.x = parameters[1];
                    this.m_target.m_columnInsertBounds.width = parameters[2] - parameters[1];
                    break;
                }
            }
            if (interval.contains(location.x)) {
                this.m_target.m_column = columnIndex;
                this.m_target.m_feedbackBounds.x = interval.begin();
                this.m_target.m_feedbackBounds.width = interval.length() + 1;
                break;
            }
            ++columnIndex;
        }
        if (this.m_target.m_column == -1) {
            int columnGap = gridInfo.getVirtualColumnGap();
            int columnSize = gridInfo.getVirtualColumnSize();
            int newWidth = columnSize + columnGap;
            int newDelta = (location.x - lastX - columnGap / 2) / newWidth;
            this.m_target.m_column = columnIntervals.length + newDelta;
            this.m_target.m_feedbackBounds.x = lastX + columnGap + newWidth * newDelta;
            this.m_target.m_feedbackBounds.width = columnSize + 1;
        }
        int rowIndex = 0;
        while (rowIndex < rowIntervals.length) {
            isLast = rowIndex == rowIntervals.length - 1;
            interval = rowIntervals[rowIndex];
            Interval interval3 = nextInterval = !isLast ? rowIntervals[rowIndex + 1] : null;
            if (location.y < rowIntervals[0].begin()) {
                this.m_target.m_row = 0;
                this.m_target.m_rowInsert = true;
                parameters2 = GridLayoutEditPolicy.getInsertFeedbackParameters(new Interval(0, 0), interval, 5);
                this.m_target.m_feedbackBounds.y = parameters2[3];
                this.m_target.m_feedbackBounds.height = parameters2[4] - parameters2[3];
                this.m_target.m_rowInsertBounds.y = parameters2[1];
                this.m_target.m_rowInsertBounds.height = parameters2[2] - parameters2[1];
                break;
            }
            if (!isLast) {
                int gap = nextInterval.begin() - interval.end();
                directGap = interval.end() <= location.y && location.y < nextInterval.begin();
                narrowGap = gap < 10;
                nearEnd = Math.abs(location.y - interval.end()) < 5;
                boolean bl = nearBegin = Math.abs(location.y - nextInterval.begin()) < 5;
                if (directGap || narrowGap && (nearEnd || nearBegin)) {
                    this.m_target.m_row = rowIndex + 1;
                    this.m_target.m_rowInsert = true;
                    parameters = GridLayoutEditPolicy.getInsertFeedbackParameters(interval, nextInterval, 5);
                    this.m_target.m_feedbackBounds.y = parameters[3];
                    this.m_target.m_feedbackBounds.height = parameters[4] - parameters[3];
                    this.m_target.m_rowInsertBounds.y = parameters[1];
                    this.m_target.m_rowInsertBounds.height = parameters[2] - parameters[1];
                    break;
                }
            }
            if (interval.contains(location.y)) {
                this.m_target.m_row = rowIndex;
                this.m_target.m_feedbackBounds.y = interval.begin();
                this.m_target.m_feedbackBounds.height = interval.length() + 1;
                break;
            }
            ++rowIndex;
        }
        if (this.m_target.m_row == -1) {
            int rowGap = gridInfo.getVirtualRowGap();
            int rowSize = gridInfo.getVirtualRowSize();
            int newHeight = rowSize + rowGap;
            int newDelta = (location.y - lastY - rowGap / 2) / newHeight;
            this.m_target.m_row = rowIntervals.length + newDelta;
            this.m_target.m_feedbackBounds.y = lastY + rowGap + newHeight * newDelta;
            this.m_target.m_feedbackBounds.height = rowSize + 1;
        }
    }

    public LayoutEditPolicy getContainerLayoutPolicy(boolean horizontal) {
        if (horizontal) {
            return new ColumnsLayoutEditPolicy<C>(this, this.m_layout);
        }
        return new RowsLayoutEditPolicy<C>(this, this.m_layout);
    }

    public List<?> getHeaders(boolean horizontal) {
        return horizontal ? this.m_layout.getColumns() : this.m_layout.getRows();
    }

    public EditPart createHeaderEditPart(boolean horizontal, Object model) {
        if (horizontal) {
            return new ColumnHeaderEditPart<C>(this.m_layout, (GridColumnInfo)model, this.getHostFigure());
        }
        return new RowHeaderEditPart<C>(this.m_layout, (GridRowInfo)model, this.getHostFigure());
    }

    public void buildContextMenu(IMenuManager manager, boolean horizontal) {
    }

    public void handleDoubleClick(boolean horizontal) {
    }
}

