/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.dev.builder;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wb.internal.dev.Activator;
import org.eclipse.wb.internal.dev.builder.BuilderHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ComponentDescriptionValidatorHandler
implements BuilderHandler {
    private static final String MARKER_TYPE = "org.eclipse.wb.dev.wbProblem";
    private static final String WBP_COMPONENT_SCHEMA = "org.eclipse.wb.core.databinding.xsd/schema/wbp-component.xsd";
    private static boolean m_considerXSD = true;

    @Override
    public void fullBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        project.deleteMarkers(MARKER_TYPE, false, 2);
        project.accept((IResourceVisitor)new ValidatorResourceVisitor());
    }

    @Override
    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new ValidatorDeltaVisitor());
    }

    private void workspaceBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        project.getWorkspace().getRoot().accept((IResourceVisitor)new ValidatorResourceVisitor());
    }

    /*
     * WARNING - void declaration
     */
    private void checkXML(IResource resource) {
        IResource iResource;
        String resourcePathString;
        block11: {
            resourcePathString = resource.getFullPath().toPortableString();
            if (resource instanceof IFile && resourcePathString.endsWith(".xsd") && m_considerXSD) {
                try {
                    try {
                        m_considerXSD = false;
                        this.workspaceBuild(resource.getProject(), null);
                    }
                    catch (Throwable e) {
                        Activator.log(e);
                        m_considerXSD = true;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    m_considerXSD = true;
                    throw throwable;
                }
                m_considerXSD = true;
            }
        }
        if ((iResource = resource) instanceof IFile) {
            IFile e = (IFile)iResource;
            IFile cfr_ignored_0 = (IFile)iResource;
            if (resourcePathString.endsWith(".wbp-component.xml")) {
                void file;
                if (resourcePathString.contains("/bin/")) {
                    return;
                }
                this.deleteMarkers((IFile)file);
                try {
                    this.validateComponentDescription((IFile)file);
                }
                catch (Throwable e2) {
                    Activator.log(e2);
                }
            }
        }
    }

    private void validateComponentDescription(IFile file) throws SAXException, CoreException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(WBP_COMPONENT_SCHEMA));
        if (!schemaFile.exists()) {
            return;
        }
        Schema schema = factory.newSchema(new StreamSource(schemaFile.getContents(true)));
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new XmlErrorHandler(file));
        try (InputStream contents = file.getContents(true);){
            validator.validate(new StreamSource(contents));
        }
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private class ValidatorDeltaVisitor
    implements IResourceDeltaVisitor {
        private ValidatorDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    ComponentDescriptionValidatorHandler.this.checkXML(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ComponentDescriptionValidatorHandler.this.checkXML(resource);
                }
            }
            return true;
        }
    }

    private class ValidatorResourceVisitor
    implements IResourceVisitor {
        private ValidatorResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            ComponentDescriptionValidatorHandler.this.checkXML(resource);
            return true;
        }
    }

    private class XmlErrorHandler
    implements ErrorHandler {
        private final IFile file;

        public XmlErrorHandler(IFile file) {
            this.file = file;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 1);
        }

        private void addMarker(SAXParseException e, int severity) {
            ComponentDescriptionValidatorHandler.this.addMarker(this.file, e.getMessage(), e.getLineNumber(), severity);
        }
    }
}

