/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.controls.palette.IPalettePreferences;

public final class PluginPalettePreferences
implements IPalettePreferences {
    private final IPreferenceStore m_store;
    private FontDescriptor m_categoryFont;
    private FontDescriptor m_entryFont;
    private String m_categoryFontKey;
    private String m_entryFontKey;
    private String m_onlyIconsKey;
    private String m_minColumnsKey;
    private String m_layoutsKey;

    public PluginPalettePreferences(IPreferenceStore store) {
        this.m_store = store;
    }

    public void setPrefix(String prefix) {
        this.m_categoryFontKey = prefix + ".category.font";
        this.m_entryFontKey = prefix + ".entry.font";
        this.m_onlyIconsKey = prefix + ".onlyIcons";
        this.m_minColumnsKey = prefix + ".columns.min";
        this.m_layoutsKey = prefix + ".layouts.type";
        FontData[] defaultFontData = Display.getDefault().getSystemFont().getFontData()[0];
        FontData boldFontData = new FontData(defaultFontData.getName(), defaultFontData.getHeight(), 1);
        PreferenceConverter.setDefault((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey, (FontData)boldFontData);
        defaultFontData = Display.getDefault().getSystemFont().getFontData();
        PreferenceConverter.setDefault((IPreferenceStore)this.m_store, (String)this.m_entryFontKey, (FontData[])defaultFontData);
        this.m_store.setDefault(this.m_onlyIconsKey, false);
        this.m_store.setDefault(this.m_minColumnsKey, 2);
        this.m_store.setDefault(this.m_layoutsKey, 1);
    }

    public FontDescriptor getCategoryFontDescriptor() {
        if (this.m_categoryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey);
            this.m_categoryFont = FontDescriptor.createFrom((FontData[])fontDataArray);
        }
        return this.m_categoryFont;
    }

    public FontDescriptor getEntryFontDescriptor() {
        if (this.m_entryFont == null) {
            FontData[] fontDataArray = PreferenceConverter.getFontDataArray((IPreferenceStore)this.m_store, (String)this.m_entryFontKey);
            this.m_entryFont = FontDescriptor.createFrom((FontData[])fontDataArray);
        }
        return this.m_entryFont;
    }

    public boolean isOnlyIcons() {
        return this.m_store.getBoolean(this.m_onlyIconsKey);
    }

    public int getMinColumns() {
        return this.m_store.getInt(this.m_minColumnsKey);
    }

    public int getLayoutType() {
        return this.m_store.getInt(this.m_layoutsKey);
    }

    public void setCategoryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.m_store, (String)this.m_categoryFontKey, (FontData[])fontDataArray);
        this.m_categoryFont = null;
    }

    public void setEntryFont(FontData[] fontDataArray) {
        PreferenceConverter.setValue((IPreferenceStore)this.m_store, (String)this.m_entryFontKey, (FontData[])fontDataArray);
        this.m_entryFont = null;
    }

    public void setOnlyIcons(boolean onlyIcons) {
        this.m_store.setValue(this.m_onlyIconsKey, onlyIcons);
    }

    public void setMinColumns(int minColumns) {
        this.m_store.setValue(this.m_minColumnsKey, minColumns);
    }

    public void setLayoutType(int layoutTypes) {
        this.m_store.setValue(this.m_layoutsKey, layoutTypes);
    }
}

