/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.Collection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.editparts.RootTreeEditPart;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.gef.ui.parts.TreeViewerTransferDragListener;
import org.eclipse.gef.ui.parts.TreeViewerTransferDropListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeViewer
extends AbstractEditPartViewer {
    private boolean ignore = false;
    private final EventDispatcher dispatcher = new EventDispatcher();

    public TreeViewer() {
        RootTreeEditPart rep = new RootTreeEditPart();
        this.setRootEditPart(rep);
        this.addDragSourceListener(new TreeViewerTransferDragListener(this));
        this.addDropTargetListener(new TreeViewerTransferDropListener(this));
    }

    @Override
    public Control createControl(Composite parent) {
        Tree tree = new Tree(parent, 770);
        this.setControl((Control)tree);
        return tree;
    }

    public EditPart findObjectAtExcluding(Point pt, Collection exclude, EditPartViewer.Conditional condition) {
        if (this.getControl() == null) {
            return null;
        }
        Tree tree = this.getControl();
        Rectangle area = tree.getClientArea();
        if (pt.x < area.x || pt.y < area.y || pt.x >= area.x + area.width || pt.y >= area.y + area.height) {
            return null;
        }
        EditPart result = null;
        TreeItem tie = tree.getItem(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
        result = tie != null ? (EditPart)tie.getData() : (EditPart)tree.getData();
        while (result != null) {
            if ((condition == null || condition.evaluate(result)) && !exclude.contains(result)) {
                return result;
            }
            result = result.getParent();
        }
        return null;
    }

    @Override
    protected void fireSelectionChanged() {
        super.fireSelectionChanged();
        this.showSelectionInTree();
    }

    public Tree getControl() {
        return (Tree)super.getControl();
    }

    @Override
    protected void hookControl() {
        if (this.getControl() == null) {
            return;
        }
        final Tree tree = this.getControl();
        tree.addFocusListener((FocusListener)this.dispatcher);
        tree.addMouseListener((MouseListener)this.dispatcher);
        tree.addMouseMoveListener((MouseMoveListener)this.dispatcher);
        tree.addKeyListener((KeyListener)this.dispatcher);
        tree.addMouseTrackListener((MouseTrackListener)this.dispatcher);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] ties = tree.getSelection();
                Object[] newSelection = new Object[ties.length];
                int i = 0;
                while (i < ties.length) {
                    newSelection[i] = ties[i].getData();
                    ++i;
                }
                TreeViewer.this.ignore = true;
                TreeViewer.this.setSelection((ISelection)new StructuredSelection(newSelection));
                TreeViewer.this.ignore = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TreeEditPart tep = (TreeEditPart)((Object)this.getRootEditPart());
        tep.setWidget((Widget)tree);
        super.hookControl();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reveal(EditPart part) {
        void treePart;
        if (!(part instanceof TreeEditPart)) {
            return;
        }
        TreeEditPart treeEditPart = (TreeEditPart)part;
        Widget widget = treePart.getWidget();
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            this.getControl().showItem(treeItem);
        }
    }

    private void showSelectionInTree() {
        if (this.ignore || this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        TreeItem[] treeItems = (TreeItem[])this.getSelectedEditParts().stream().map(TreeEditPart.class::cast).map(TreeEditPart::getWidget).filter(TreeItem.class::isInstance).map(TreeItem.class::cast).toArray(TreeItem[]::new);
        this.getControl().setSelection(treeItems);
    }

    @Override
    protected void unhookControl() {
        if (this.getControl() == null) {
            return;
        }
        super.unhookControl();
        TreeEditPart tep = (TreeEditPart)((Object)this.getRootEditPart());
        tep.setWidget(null);
    }

    class EventDispatcher
    implements MouseListener,
    MouseMoveListener,
    KeyListener,
    MouseTrackListener,
    FocusListener {
        protected static final int ANY_BUTTON = 0x380000;

        EventDispatcher() {
        }

        public void keyPressed(KeyEvent kee) {
            TreeViewer.this.getEditDomain().keyDown(kee, TreeViewer.this);
        }

        public void keyReleased(KeyEvent kee) {
            TreeViewer.this.getEditDomain().keyUp(kee, TreeViewer.this);
        }

        public void mouseDoubleClick(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseDoubleClick(me, TreeViewer.this);
        }

        public void mouseDown(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseDown(me, TreeViewer.this);
        }

        public void mouseEnter(MouseEvent me) {
            TreeViewer.this.getEditDomain().viewerEntered(me, TreeViewer.this);
        }

        public void mouseExit(MouseEvent me) {
            TreeViewer.this.getEditDomain().viewerExited(me, TreeViewer.this);
        }

        public void mouseHover(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseHover(me, TreeViewer.this);
        }

        public void mouseMove(MouseEvent me) {
            if ((me.stateMask & 0x380000) != 0) {
                TreeViewer.this.getEditDomain().mouseDrag(me, TreeViewer.this);
            } else {
                TreeViewer.this.getEditDomain().mouseMove(me, TreeViewer.this);
            }
        }

        public void mouseUp(MouseEvent me) {
            TreeViewer.this.getEditDomain().mouseUp(me, TreeViewer.this);
        }

        public void focusGained(FocusEvent event) {
            TreeViewer.this.getEditDomain().focusGained(event, TreeViewer.this);
        }

        public void focusLost(FocusEvent event) {
            TreeViewer.this.getEditDomain().focusLost(event, TreeViewer.this);
        }
    }
}

