/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wb.tests.designer.core.TestProject;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class ResourceUtils {
    private static Bundle m_testBundle = Platform.getBundle((String)"org.eclipse.wb.tests");

    public static URL getEntry(String name) {
        return m_testBundle.getEntry(name);
    }

    public static URL getEntry(String path, String name) {
        return ResourceUtils.getEntry(path + "/" + name);
    }

    private static void createFolderStructure(IContainer container) throws CoreException {
        if (!container.exists() && container instanceof IFolder && container.getParent() != null) {
            if (container.getParent().exists()) {
                ((IFolder)container).create(true, true, null);
            } else {
                ResourceUtils.createFolderStructure(container.getParent());
            }
        }
    }

    public static void resources2project(TestProject project, String path, String[] skipEntries) throws IOException, CoreException, JavaModelException, Exception {
        Enumeration pathEntries = m_testBundle.findEntries(path, "*", true);
        Assert.assertNotNull((Object)pathEntries);
        while (pathEntries.hasMoreElements()) {
            URL entryURL = (URL)pathEntries.nextElement();
            String entryPathBase = entryURL.getPath();
            String entryPath = entryPathBase.replaceFirst(path, "");
            try {
                InputStream entryStream = entryURL.openStream();
                IFile file = project.getProject().getFile(entryPath);
                if (entryPathBase.endsWith("/CVS/" + file.getName()) || ArrayUtils.contains((Object[])skipEntries, (Object)file.getName())) continue;
                if (file.exists()) {
                    file.setContents(entryStream, true, false, null);
                    continue;
                }
                ResourceUtils.createFolderStructure(file.getParent());
                file.create(entryStream, true, null);
            }
            catch (FileNotFoundException e) {
                IFolder folder = project.getProject().getFolder(entryPath);
                if (folder.getName().equals("CVS") || folder.exists()) continue;
                folder.create(true, true, null);
            }
        }
    }

    public static void resources2project(TestProject project, String path) throws IOException, CoreException, JavaModelException, Exception {
        ResourceUtils.resources2project(project, path, new String[0]);
    }
}

