/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class BeanPropertyTagsTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    private static void assertPropertyCategory(PropertyCategory category, ComponentDescription description, String propertyId) {
        BeanPropertyTagsTest.assertSame((Object)category, (Object)description.getProperty(propertyId).getCategory());
    }

    @Test
    public void test_propertyCategory() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setA(int value) {", "  }", "  public void setB(int value) {", "  }", "  public void setC(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='A'/>", "  <properties-advanced names='B'/>", "  <properties-hidden names='C'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setA(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.ADVANCED, description, "setB(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.HIDDEN, description, "setC(int)");
    }

    @Test
    public void test_propertyCategory_normal() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject0.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject0 {", "  public void setA(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject extends MyObject0 {", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject0.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='A'/>", "</component>"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-normal names='A'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "setA(int)");
    }

    @Test
    public void test_propertyCategory_template() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setTempValue_1(int value) {", "  }", "  public void setTempValue_2(int value) {", "  }", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='tempValue*'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "setValue(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setTempValue_1(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setTempValue_2(int)");
    }

    @Test
    public void test_propertyFlags_forField() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public int foo;", "  public int value;", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='value'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "value");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "foo");
    }

    @Test
    public void test_propertyFlags_specifyExactMethod() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setText(String text) {", "  }", "  public void setText(String[] text) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='setText(java.lang.String[])'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setText(java.lang.String[])");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "setText(java.lang.String)");
    }

    @Test
    public void test_propertyFlags_methodFieldConflict_1() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public int descriptionOffset;", "  public void setDescription(String value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='description'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setDescription(java.lang.String)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "descriptionOffset");
    }

    @Test
    public void test_propertyFlags_methodFieldConflict_selectMethod() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public int value;", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='m:value'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "setValue(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "value");
    }

    @Test
    public void test_propertyFlags_methodFieldConflict_selectField() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public int value;", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-preferred names='f:value'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.NORMAL, description, "setValue(int)");
        BeanPropertyTagsTest.assertPropertyCategory(PropertyCategory.PREFERRED, description, "value");
    }

    @Test
    public void test_noDefaultValue() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public int getValueA() {", "    return 1;", "  }", "  public void setValueA(int value) {", "  }", "  public int getValueB() {", "    return 2;", "  }", "  public void setValueB(int value) {", "  }", "  public int getValueC() {", "    return 3;", "  }", "  public void setValueC(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <properties-noDefaultValue names='valueA valueB'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescription property = description.getProperty("setValueA(int)");
        BeanPropertyTagsTest.assertTrue((boolean)property.hasTrueTag("noDefaultValue"));
        property = description.getProperty("setValueB(int)");
        BeanPropertyTagsTest.assertTrue((boolean)property.hasTrueTag("noDefaultValue"));
        property = description.getProperty("setValueC(int)");
        BeanPropertyTagsTest.assertFalse((boolean)property.hasTrueTag("noDefaultValue"));
    }

    @Test
    public void test_standardPropertyTag_simple() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property-tag name='value' tag='tagName' value='tagValue'/>", "  <property-tag name='value' tag='tagName2' value='tagValue2'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescription property = description.getProperty("setValue(int)");
        BeanPropertyTagsTest.assertEquals((Object)"tagValue", (Object)property.getTag("tagName"));
        BeanPropertyTagsTest.assertEquals((Object)"tagValue2", (Object)property.getTag("tagName2"));
        BeanPropertyTagsTest.assertNull((Object)property.getTag("no-such-tag"));
    }

    @Test
    public void test_standardPropertyTag_exactMethodSignature() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setText(String text) {", "  }", "  public void setText(String[] text) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property-tag name='setText(java.lang.String)' tag='tagName' value='tagValue'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescription property = description.getProperty("setText(java.lang.String)");
        BeanPropertyTagsTest.assertEquals((Object)"tagValue", (Object)property.getTag("tagName"));
        property = description.getProperty("setText(java.lang.String[])");
        BeanPropertyTagsTest.assertNull((Object)property.getTag("tagName"));
    }

    @Test
    public void test_setTitleForProperty() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property-tag name='value' tag='title' value='MyTitle'/>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescription property = description.getProperty("setValue(int)");
        BeanPropertyTagsTest.assertEquals((Object)"MyTitle", (Object)property.getTitle());
        BeanPropertyTagsTest.assertEquals((Object)"MyTitle", (Object)property.getTag("title"));
    }

    @Test
    public void test_setTitleForProperty2() throws Exception {
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.java", BeanPropertyTagsTest.getSourceDQ("package test;", "public class MyObject {", "  public void setValue(int value) {", "  }", "}"));
        BeanPropertyTagsTest.setFileContentSrc("test/MyObject.wbp-component.xml", BeanPropertyTagsTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setValue(int)'>", "    <tag name='title' value='MyTitle'/>", "  </property>", "</component>"));
        BeanPropertyTagsTest.waitForAutoBuild();
        ComponentDescription description = this.getMyObjectDescription();
        GenericPropertyDescription property = description.getProperty("setValue(int)");
        BeanPropertyTagsTest.assertEquals((Object)"MyTitle", (Object)property.getTitle());
        BeanPropertyTagsTest.assertEquals((Object)"MyTitle", (Object)property.getTag("title"));
    }

    private ComponentDescription getMyObjectDescription() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        return ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyObject");
    }
}

