/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObjectFactories;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfiguration;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.util.predicate.AlwaysPredicate;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class FlowContainerModelTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getConfigurations_horizontal_trueByDefault() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "alwaysTrue", "%parent%.add(%child%)");
    }

    @Test
    public void test_getConfigurations_horizontal_complexExpression() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "isHorizontal()"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "isHorizontal()", "%parent%.add(%child%)");
    }

    @Test
    public void test_getConfigurations_noContainerAssociation() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "NO");
    }

    @Test
    public void test_getConfigurations_invalidInvocationChild() throws Exception {
        try {
            this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "somethingWrong"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
            FlowContainerModelTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_getConfigurations_explicitInvocationChild() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "invocationChild %parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_noComponentValidator() throws Exception {
        try {
            this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}});
            FlowContainerModelTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_getConfigurations_explicitComponentTypes() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "javax.swing.JButton javax.swing.JTextField"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "javax.swing.JButton javax.swing.JTextField", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_defaultComponent() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer.defaultComponent", "java.awt.Component"}, {"flowContainer.defaultReference", "java.awt.Component"}, {"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_componentValidatorExpression() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component-validator", "isComponentType(java.awt.Component)"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "isComponentType(java.awt.Component)", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_noReference() throws Exception {
        try {
            this.getConfigurations(true, new String[][]{{"flowContainer.defaultComponent", "java.awt.Component"}, {"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}});
            FlowContainerModelTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_getConfigurations_explicitReferenceTypes() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "javax.swing.JButton javax.swing.JTextField"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "javax.swing.JButton javax.swing.JTextField");
    }

    @Test
    public void test_getConfigurations_referenceValidatorExpression() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference-validator", "isReferenceType(java.awt.Component)"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "isReferenceType(java.awt.Component)");
    }

    @Test
    public void test_getConfigurations_referencesAsComponents() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_defaultReference() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer.defaultComponent", "java.awt.Component"}, {"flowContainer.defaultReference", "java.awt.Component"}, {"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_common() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_explicit() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer.canvas", "true"}, {"flowContainer.canvas.horizontal", "true"}, {"flowContainer.canvas.association", "%parent%.add(%child%)"}, {"flowContainer.canvas.component", "java.awt.Component"}, {"flowContainer.canvas.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
    }

    @Test
    public void test_getConfigurations_forCanvas_onlyForTree() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer.tree", "true"}, {"flowContainer.tree.horizontal", "true"}, {"flowContainer.tree.association", "%parent%.add(%child%)"}, {"flowContainer.tree.component", "java.awt.Component"}, {"flowContainer.tree.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).isEmpty();
    }

    @Test
    public void test_getConfigurations_forTree_common() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(false, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
    }

    @Test
    public void test_getConfigurations_forTree_explicit() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(false, new String[][]{{"flowContainer.tree", "true"}, {"flowContainer.tree.horizontal", "true"}, {"flowContainer.tree.association", "%parent%.add(%child%)"}, {"flowContainer.tree.component", "java.awt.Component"}, {"flowContainer.tree.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(1);
    }

    @Test
    public void test_getConfigurations_3_count() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "true"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}, {"flowContainer.1", "true"}, {"flowContainer.1.horizontal", "false"}, {"flowContainer.1.association", "%parent%.add(%child%)"}, {"flowContainer.1.component", "javax.swing.JButton"}, {"flowContainer.1.reference", "java.awt.Component"}, {"flowContainer.5", "true"}, {"flowContainer.5.horizontal", "true"}, {"flowContainer.5.association", "%parent%.add(%child%)"}, {"flowContainer.5.component", "javax.swing.JTextField"}, {"flowContainer.5.reference", "javax.swing.JTextField"}});
        Assertions.assertThat(configurations).hasSize(3);
        FlowContainerModelTest.assertConfiguration(configurations.get(0), "true", "%parent%.add(%child%)", "java.awt.Component", "java.awt.Component");
        FlowContainerModelTest.assertConfiguration(configurations.get(1), "false", "%parent%.add(%child%)", "javax.swing.JButton", "java.awt.Component");
        FlowContainerModelTest.assertConfiguration(configurations.get(2), "true", "%parent%.add(%child%)", "javax.swing.JTextField", "javax.swing.JTextField");
    }

    @Test
    public void test_getConfigurations_ignoreFalse() throws Exception {
        List<FlowContainerConfiguration> configurations = this.getConfigurations(true, new String[][]{{"flowContainer", "false"}, {"flowContainer.horizontal", "true"}, {"flowContainer.association", "%parent%.add(%child%)"}, {"flowContainer.component", "java.awt.Component"}, {"flowContainer.reference", "java.awt.Component"}});
        Assertions.assertThat(configurations).hasSize(0);
    }

    private static void assertConfiguration(FlowContainerConfiguration configuration, String horizontal, String association) throws Exception {
        FlowContainerModelTest.assertConfiguration(configuration, horizontal, association, null, null);
    }

    private static void assertConfiguration(FlowContainerConfiguration configuration, String horizontal, String association, String expectedComponentValidator, String expectedReferenceValidator) throws Exception {
        FlowContainerModelTest.assertEquals((Object)horizontal, (Object)FlowContainerModelTest.getHorizontalPredicateString(configuration));
        FlowContainerModelTest.assertEquals((Object)association, (Object)FlowContainerModelTest.getAssociationObjectString(configuration));
        if (expectedComponentValidator != null) {
            FlowContainerModelTest.assertEquals((Object)expectedComponentValidator, (Object)FlowContainerModelTest.getValidatorString(configuration.getComponentValidator()));
        }
        if (expectedReferenceValidator != null) {
            FlowContainerModelTest.assertEquals((Object)expectedReferenceValidator, (Object)FlowContainerModelTest.getValidatorString(configuration.getReferenceValidator()));
        }
    }

    private static String getValidatorString(Object validator) {
        return validator.toString();
    }

    private static String getHorizontalPredicateString(FlowContainerConfiguration configuration) {
        Predicate predicate = configuration.getHorizontalPredicate();
        if (predicate instanceof AlwaysPredicate && ReflectionUtils.getFieldBoolean((Object)predicate, (String)"m_value")) {
            return "alwaysTrue";
        }
        return predicate.toString();
    }

    private static String getAssociationObjectString(FlowContainerConfiguration configuration) throws Exception {
        return configuration.getAssociationObjectFactory().toString();
    }

    private List<FlowContainerConfiguration> getConfigurations(boolean forCanvas, String[][] parameters) throws Exception {
        String[] parameterLines = new String[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            String[] parameterPair = parameters[i];
            FlowContainerModelTest.assertEquals((long)2L, (long)parameterPair.length);
            parameterLines[i] = MessageFormat.format("    <parameter name=''{0}''>{1}</parameter>", parameterPair[0], parameterPair[1]);
            ++i;
        }
        FlowContainerModelTest.setFileContentSrc("test/FlowPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class FlowPanel extends Container {", "  public FlowPanel() {", "  }", "}"));
        FlowContainerModelTest.setFileContentSrc("test/FlowPanel.wbp-component.xml", FlowContainerModelTest.getSource3(new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <parameters>"}, parameterLines, new String[]{"  </parameters>", "</component>"}));
        FlowContainerModelTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends FlowPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        return new FlowContainerFactory((JavaInfo)panel, forCanvas).getConfigurations();
    }

    @Test
    public void test_duckTyping() throws Exception {
        JavaInfo component = (JavaInfo)Mockito.mock(JavaInfo.class);
        JavaInfo nextComponent = (JavaInfo)Mockito.mock(JavaInfo.class);
        MyFlowContainer container = (MyFlowContainer)((Object)Mockito.mock(MyFlowContainer.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{component, nextComponent, container});
        FlowContainerConfigurable flowContainer = new FlowContainerConfigurable((JavaInfo)container, new FlowContainerConfiguration(o -> true, o -> false, null, ContainerObjectValidators.alwaysTrue(), ContainerObjectValidators.alwaysTrue(), ""));
        flowContainer.command_CREATE((Object)component, (Object)nextComponent);
        ((MyFlowContainer)((Object)inOrder.verify((Object)container))).command_CREATE(component, nextComponent);
        ((MyFlowContainer)((Object)inOrder.verify((Object)container))).command_CREATE_after(component, nextComponent);
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new MyFlowContainer[]{container});
        flowContainer.command_MOVE((Object)component, (Object)nextComponent);
        ((MyFlowContainer)((Object)inOrder.verify((Object)container))).command_MOVE(component, nextComponent);
        ((MyFlowContainer)((Object)inOrder.verify((Object)container))).command_MOVE_after(component, nextComponent);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_duckTyping_useMostSpecific() throws Exception {
        JavaInfo component = (JavaInfo)Mockito.mock(JavaInfo.class);
        JavaInfo nextComponent = (JavaInfo)Mockito.mock(JavaInfo.class);
        MyFlowContainer_useMostSpecific container = (MyFlowContainer_useMostSpecific)((Object)Mockito.mock(MyFlowContainer_useMostSpecific.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{component, nextComponent, container});
        FlowContainerConfigurable flowContainer = new FlowContainerConfigurable((JavaInfo)container, new FlowContainerConfiguration(o -> true, o -> false, null, ContainerObjectValidators.alwaysTrue(), ContainerObjectValidators.alwaysTrue(), ""));
        flowContainer.command_CREATE((Object)component, (Object)nextComponent);
        ((MyFlowContainer_useMostSpecific)((Object)inOrder.verify((Object)container))).command_CREATE(component, (Object)nextComponent);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_validateMethods() throws Exception {
        JavaInfo container = (JavaInfo)Mockito.mock(JavaInfo.class);
        JavaInfo component = (JavaInfo)Mockito.mock(JavaInfo.class);
        JavaInfo reference = (JavaInfo)Mockito.mock(JavaInfo.class);
        FlowContainerConfiguration configuration = (FlowContainerConfiguration)Mockito.mock(FlowContainerConfiguration.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{container, component, reference, configuration});
        FlowContainerConfigurable flowContainer = new FlowContainerConfigurable(container, configuration);
        Mockito.when((Object)configuration.getHorizontalPredicate()).thenReturn(o -> true);
        FlowContainerModelTest.assertTrue((boolean)flowContainer.isHorizontal());
        ((FlowContainerConfiguration)inOrder.verify((Object)configuration)).getHorizontalPredicate();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new FlowContainerConfiguration[]{configuration});
        Mockito.when((Object)configuration.getComponentValidator()).thenReturn((Object)ContainerObjectValidators.alwaysTrue());
        FlowContainerModelTest.assertTrue((boolean)flowContainer.validateComponent((Object)component));
        ((FlowContainerConfiguration)inOrder.verify((Object)configuration)).getComponentValidator();
        inOrder.verifyNoMoreInteractions();
        Mockito.clearInvocations((Object[])new FlowContainerConfiguration[]{configuration});
        Mockito.when((Object)configuration.getReferenceValidator()).thenReturn((Object)ContainerObjectValidators.alwaysTrue());
        FlowContainerModelTest.assertTrue((boolean)flowContainer.validateReference((Object)reference));
        ((FlowContainerConfiguration)inOrder.verify((Object)configuration)).getReferenceValidator();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void test_CREATE() throws Exception {
        FlowContainerModelTest.prepareFlowPanel();
        ContainerInfo panel = this.parseContainer("class Test extends FlowPanel {", "  Test() {", "    {", "      JButton button_0 = new JButton();", "      add(button_0);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
        FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory((JavaInfo)panel, true).get().get(0);
        ComponentInfo newButton = FlowContainerModelTest.createJButton();
        FlowContainerModelTest.assertTrue((boolean)flowContainer.isHorizontal());
        FlowContainerModelTest.assertTrue((boolean)flowContainer.validateComponent((Object)newButton));
        FlowContainerModelTest.assertTrue((boolean)flowContainer.validateReference((Object)button_0));
        flowContainer.command_CREATE((Object)newButton, (Object)button_0);
        this.assertEditor("class Test extends FlowPanel {", "  Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton button_0 = new JButton();", "      add(button_0);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_twoTimes() throws Exception {
        FlowContainerModelTest.prepareFlowPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends FlowPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        FlowContainer flowContainer = (FlowContainer)new FlowContainerFactory((JavaInfo)panel, true).get().get(0);
        ComponentInfo newButton = FlowContainerModelTest.createJButton();
        flowContainer.command_CREATE((Object)newButton, null);
        newButton.delete();
        newButton = FlowContainerModelTest.createJButton();
        flowContainer.command_CREATE((Object)newButton, null);
        this.assertEditor("// filler filler filler", "public class Test extends FlowPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE() throws Exception {
        FlowContainerModelTest.prepareFlowPanel();
        ContainerInfo panel = this.parseContainer("class Test extends FlowPanel {", "  Test() {", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        FlowContainerConfigurable flowContainer = new FlowContainerConfigurable((JavaInfo)panel, new FlowContainerConfiguration(o -> true, o -> false, AssociationObjectFactories.invocationChild((String)"%parent%.add(%child%)", (boolean)false), ContainerObjectValidators.alwaysTrue(), ContainerObjectValidators.alwaysTrue(), ""));
        flowContainer.command_MOVE((Object)button_2, (Object)button_1);
        this.assertEditor("class Test extends FlowPanel {", "  Test() {", "    {", "      JButton button_2 = new JButton();", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1);", "    }", "  }", "}");
    }

    static void prepareFlowPanel() throws Exception {
        FlowContainerModelTest.prepareFlowPanel_classes();
        AbstractJavaProjectTest.setFileContentSrc("test/FlowPanel.wbp-component.xml", FlowContainerModelTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='add'>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <parameters>", "    <parameter name='flowContainer'>true</parameter>", "    <parameter name='flowContainer.horizontal'>true</parameter>", "    <parameter name='flowContainer.association'>%parent%.add(%child%)</parameter>", "    <parameter name='flowContainer.component'>java.awt.Component</parameter>", "    <parameter name='flowContainer.reference'>java.awt.Component</parameter>", "  </parameters>", "</component>"));
        FlowContainerModelTest.waitForAutoBuild();
    }

    static void prepareFlowPanel_classes() throws Exception {
        FlowContainerModelTest.setFileContentSrc("test/MyLayout.java", FlowContainerModelTest.getSource("package test;", "import java.awt.*;", "public class MyLayout implements LayoutManager {", "  public void addLayoutComponent(String name, Component comp) {", "  }", "  public  void removeLayoutComponent(Component comp) {", "  }", "  public Dimension preferredLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public Dimension minimumLayoutSize(Container parent) {", "    return new Dimension(200, 100);", "  }", "  public void layoutContainer(Container parent) {", "    int nmembers = parent.getComponentCount();", "    for (int i = 0 ; i < nmembers ; i++) {", "      Component m = parent.getComponent(i);", "      m.setBounds(25 + 100 * i, 10, 90, 50);", "    }", "  }", "}"));
        FlowContainerModelTest.setFileContentSrc("test/FlowPanel.java", FlowContainerModelTest.getSource("package test;", "import java.awt.*;", "public class FlowPanel extends Container {", "  public FlowPanel() {", "    setLayout(new MyLayout());", "  }", "}"));
    }

    public static class MyFlowContainer
    extends JavaInfo {
        public MyFlowContainer(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public void command_CREATE(Object component, Object nextComponent) {
        }

        public void command_CREATE_after(Object component, Object nextComponent) {
        }

        public void command_MOVE(Object component, Object nextComponent) {
        }

        public void command_MOVE_after(Object component, Object nextComponent) {
        }
    }

    public static class MyFlowContainer_useMostSpecific
    extends JavaInfo {
        public MyFlowContainer_useMostSpecific(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public void command_CREATE(Object component, Object nextComponent) {
        }

        public void command_CREATE(JavaInfo component, Object nextComponent) {
        }
    }
}

