/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.ByteObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ByteObjectPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    private static final ByteObjectPropertyEditor EDITOR = ByteObjectPropertyEditor.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        ByteObjectPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        ByteObjectPropertyEditorTest.assert_getText("null", (TextDisplayPropertyEditor)EDITOR, null);
        ByteObjectPropertyEditorTest.assert_getText("123", (TextDisplayPropertyEditor)EDITOR, (byte)123);
    }

    @Test
    public void test_getEditorText() throws Exception {
        ByteObjectPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        ByteObjectPropertyEditorTest.assert_getEditorText("null", (TextDisplayPropertyEditor)EDITOR, null);
        ByteObjectPropertyEditorTest.assert_getEditorText("123", (TextDisplayPropertyEditor)EDITOR, (byte)123);
    }

    @Test
    public void test_setEditorText_value() throws Exception {
        this.prepareBytePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ByteObjectPropertyEditorTest.setTextEditorText(property, "123");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((byte) 123);", "  }", "}");
    }

    @Test
    public void test_setEditorText_null() throws Exception {
        this.prepareBytePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ByteObjectPropertyEditorTest.setTextEditorText(property, "null");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((Byte) null);", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareBytePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((byte) 123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ByteObjectPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareBytePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((byte) 123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ByteObjectPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareBytePanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ByteObjectPropertyEditorTest.setTextEditorText(property, "notByte");
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("foo");
                context.clickButton("OK");
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareBytePanel() throws Exception {
        ByteObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Byte foo) {", "  }", "}"));
        ByteObjectPropertyEditorTest.waitForAutoBuild();
    }
}

