/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.ShortObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;

public class ShortObjectPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    private static final ShortObjectPropertyEditor EDITOR = ShortObjectPropertyEditor.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        ShortObjectPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        ShortObjectPropertyEditorTest.assert_getText("null", (TextDisplayPropertyEditor)EDITOR, null);
        ShortObjectPropertyEditorTest.assert_getText("123", (TextDisplayPropertyEditor)EDITOR, (short)123);
    }

    @Test
    public void test_getEditorText() throws Exception {
        ShortObjectPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        ShortObjectPropertyEditorTest.assert_getEditorText("null", (TextDisplayPropertyEditor)EDITOR, null);
        ShortObjectPropertyEditorTest.assert_getEditorText("123", (TextDisplayPropertyEditor)EDITOR, (short)123);
    }

    @Test
    public void test_setEditorText_value() throws Exception {
        this.prepareShortPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ShortObjectPropertyEditorTest.setTextEditorText(property, "123");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((short) 123);", "  }", "}");
    }

    @Test
    public void test_setEditorText_null() throws Exception {
        this.prepareShortPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ShortObjectPropertyEditorTest.setTextEditorText(property, "null");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((Short) null);", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareShortPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((short) 123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ShortObjectPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareShortPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((short) 123);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        ShortObjectPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareShortPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                ShortObjectPropertyEditorTest.setTextEditorText(property, "notShort");
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("foo");
                context.clickButton("OK");
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareShortPanel() throws Exception {
        ShortObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Short foo) {", "  }", "}"));
        ShortObjectPropertyEditorTest.waitForAutoBuild();
    }
}

