/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util.generic;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class CopyPropertyTopChildTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_copyExisting() throws Exception {
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void addStack(String stackText, Component component) {", "    add(component);", "  }", "}"));
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.wbp-component.xml", CopyPropertyTopChildTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- METHODS -->", "  <methods>", "    <method name='addStack'>", "      <parameter type='java.lang.String'/>", "      <parameter type='java.awt.Component' child='true'/>", "    </method>", "  </methods>", "  <!-- PARAMETERS -->", "  <parameters>", "    <parameter name='copyChildPropertyTop from=Association/stackText to=StackText category=normal'/>", "  </parameters>", "</component>"));
        CopyPropertyTopChildTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    addStack('My text', new JButton());", "  }", "}");
        panel.refresh();
        CopyPropertyTopChildTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("StackText");
        CopyPropertyTopChildTest.assertNotNull((Object)property);
        CopyPropertyTopChildTest.assertSame((Object)PropertyCategory.NORMAL, (Object)property.getCategory());
        CopyPropertyTopChildTest.assertEquals((Object)"My text", (Object)property.getValue());
        CopyPropertyTopChildTest.assertSame((Object)property, (Object)button.getPropertyByTitle("StackText"));
    }

    @Test
    public void test_ignoreNotExisting() throws Exception {
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.wbp-component.xml", CopyPropertyTopChildTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <!-- PARAMETERS -->", "  <parameters>", "    <parameter name='copyChildPropertyTop from=noSuchProperty to=anyTitle'/>", "  </parameters>", "</component>"));
        CopyPropertyTopChildTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        panel.refresh();
        CopyPropertyTopChildTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property property = button.getPropertyByTitle("anyTitle");
        CopyPropertyTopChildTest.assertNull((Object)property);
    }

    @Test
    public void test_noParameter_from() throws Exception {
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.wbp-component.xml", CopyPropertyTopChildTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='copyChildPropertyTop to=fooBar'/>", "  </parameters>", "</component>"));
        CopyPropertyTopChildTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'from'"});
    }

    @Test
    public void test_noParameter_to() throws Exception {
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "}"));
        CopyPropertyTopChildTest.setFileContentSrc("test/MyPanel.wbp-component.xml", CopyPropertyTopChildTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='copyChildPropertyTop from=fooBar'/>", "  </parameters>", "</component>"));
        CopyPropertyTopChildTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'to'"});
    }
}

