/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentHandler;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.utils.xml.DocumentTextNode;
import org.eclipse.wb.internal.core.utils.xml.FileDocumentEditContext;
import org.eclipse.wb.internal.core.utils.xml.Model;
import org.eclipse.wb.internal.core.utils.xml.parser.QException;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.core.util.xml.SpecialDocumentNode;
import org.eclipse.wb.tests.designer.core.util.xml.TestDocumentHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class XmlDocumentTest
extends AbstractJavaProjectTest {
    private boolean m_removeTrailingEOL = false;
    private AbstractDocumentEditContext context;
    private DocumentElement rootElement;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            XmlDocumentTest.do_projectCreate();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.context != null) {
            this.context.disconnect();
            this.context = null;
        }
        super.tearDown();
    }

    private void prepareContext(String ... lines) throws Exception {
        String source = this.getXMLSource(lines);
        Document document = new Document(source);
        this.context = new DocumentEditContext((IDocument)document){

            protected AbstractDocumentHandler createDocumentHandler() {
                return new TestDocumentHandler();
            }
        };
        this.rootElement = this.context.getRoot();
        this.assertOffsets();
    }

    private String getXMLSource(String ... lines) {
        String source = XmlDocumentTest.getSourceDQ(lines);
        if (this.m_removeTrailingEOL) {
            source = StringUtils.chomp((String)source);
        }
        return source;
    }

    private void assertContext(String ... lines) throws Exception {
        String source = this.getXMLSource(lines);
        XmlDocumentTest.assertEquals((Object)source, (Object)this.context.getText());
        this.assertOffsets();
    }

    private void assertOffsets() {
        this.rootElement.accept(new DocumentModelVisitor(){

            public void endVisit(DocumentElement element) {
                String tag = element.getTag();
                if (element.isClosed()) {
                    offset = element.getOffset();
                    length = element.getLength();
                    text = XmlDocumentTest.this.context.getText(offset, length);
                    Assertions.assertThat((String)text).startsWith((CharSequence)("<" + tag));
                    Assertions.assertThat((String)text).endsWith((CharSequence)"/>");
                } else {
                    offset = element.getOpenTagOffset();
                    length = element.getOpenTagLength();
                    text = XmlDocumentTest.this.context.getText(offset, length);
                    Assertions.assertThat((String)text).startsWith((CharSequence)("<" + tag));
                    Assertions.assertThat((String)text).endsWith((CharSequence)">");
                    offset = element.getCloseTagOffset();
                    length = element.getCloseTagLength();
                    text = XmlDocumentTest.this.context.getText(offset, length);
                    XmlDocumentTest.assertEquals((Object)text, (Object)("</" + tag + ">"));
                    offset = element.getOffset();
                    length = element.getLength();
                    text = XmlDocumentTest.this.context.getText(offset, length);
                    Assertions.assertThat((String)text).startsWith((CharSequence)("<" + tag));
                    Assertions.assertThat((String)text).endsWith((CharSequence)("</" + tag + ">"));
                }
                for (DocumentAttribute attribute : element.getDocumentAttributes()) {
                    this.validateAttribute(element, attribute);
                }
                this.validateTextNode(element);
            }

            private void validateAttribute(DocumentElement element, DocumentAttribute attribute) {
                XmlDocumentTest.assertSame((Object)element, (Object)attribute.getEnclosingElement());
                XmlDocumentTest.assertSame((Object)element.getModel(), (Object)attribute.getModel());
                int offset = attribute.getNameOffset();
                int length = attribute.getNameLength();
                String text = XmlDocumentTest.this.context.getText(offset, length);
                XmlDocumentTest.assertEquals((Object)text, (Object)attribute.getName());
                offset = attribute.getValueOffset();
                length = attribute.getValueLength();
                text = XmlDocumentTest.this.context.getText(offset, length);
                XmlDocumentTest.assertEquals((Object)text, (Object)attribute.getValue());
            }

            private void validateTextNode(DocumentElement element) {
                DocumentTextNode textNode = element.getTextNode();
                if (textNode == null) {
                    return;
                }
                XmlDocumentTest.assertSame((Object)element, (Object)textNode.getEnclosingElement());
                XmlDocumentTest.assertSame((Object)element.getModel(), (Object)textNode.getModel());
                String text = XmlDocumentTest.this.context.getText(textNode.getOffset(), textNode.getLength());
                if (textNode.isCDATA()) {
                    XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getRawText());
                    ((AbstractStringAssert)Assertions.assertThat((String)text).startsWith((CharSequence)"<![CDATA[")).endsWith((CharSequence)"]]>");
                    Assertions.assertThat((String)text).contains(new CharSequence[]{textNode.getText()});
                } else {
                    XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getRawText());
                    XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
                }
            }
        });
    }

    @Test
    public void test_parse_error() throws Exception {
        try {
            this.prepareContext("bad");
            XmlDocumentTest.fail();
        }
        catch (Throwable e) {
            Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)e);
            XmlDocumentTest.assertInstanceOf(QException.class, (Object)rootCause);
        }
    }

    @Test
    public void test_parse() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <first/>", "</root>");
        Model model = this.rootElement.getModel();
        XmlDocumentTest.assertNotNull((Object)model);
        XmlDocumentTest.assertSame(null, (Object)this.rootElement.getParent());
        XmlDocumentTest.assertEquals((Object)"root", (Object)this.rootElement.getTag());
        XmlDocumentTest.assertFalse((boolean)this.rootElement.isClosed());
        List attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).hasSize(1);
        DocumentAttribute attribute = this.rootElement.getDocumentAttribute("name");
        XmlDocumentTest.assertSame((Object)attribute, attributes.get(0));
        XmlDocumentTest.assertEquals((Object)"name", (Object)attribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)attribute.getValue());
        XmlDocumentTest.assertEquals((Object)"value", (Object)this.rootElement.getAttribute("name"));
        XmlDocumentTest.assertEquals(null, (Object)this.rootElement.getAttribute("name1"));
        List rootChildren = this.rootElement.getChildren();
        Assertions.assertThat((List)rootChildren).hasSize(1);
        DocumentElement firstElement = (DocumentElement)rootChildren.get(0);
        XmlDocumentTest.assertNotNull((Object)firstElement);
        XmlDocumentTest.assertSame((Object)model, (Object)firstElement.getModel());
        XmlDocumentTest.assertSame((Object)this.rootElement, (Object)firstElement.getParent());
        XmlDocumentTest.assertEquals((Object)"first", (Object)firstElement.getTag());
        XmlDocumentTest.assertTrue((boolean)firstElement.isClosed());
        List attributes2 = firstElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes2).isEmpty();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <first/>", "</root>");
    }

    @Test
    public void test_getRoot() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <first/>", "</root>");
        XmlDocumentTest.assertSame((Object)this.rootElement, (Object)this.rootElement.getRoot());
        DocumentElement child = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertSame((Object)this.rootElement, (Object)child.getRoot());
    }

    @Test
    public void test_getTagLocal() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root xmlns:wbp='someValue'>", "  <first/>", "  <wbp:second/>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals((Object)"first", (Object)element.getTag());
        XmlDocumentTest.assertEquals((Object)"first", (Object)element.getTagLocal());
        element = this.rootElement.getChildAt(1);
        XmlDocumentTest.assertEquals((Object)"wbp:second", (Object)element.getTag());
        XmlDocumentTest.assertEquals((Object)"second", (Object)element.getTagLocal());
    }

    @Test
    public void test_getTagNS() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root xmlns:wbp='someValue'>", "  <first/>", "  <wbp:second/>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals((Object)"first", (Object)element.getTag());
        XmlDocumentTest.assertEquals((Object)"", (Object)element.getTagNS());
        element = this.rootElement.getChildAt(1);
        XmlDocumentTest.assertEquals((Object)"wbp:second", (Object)element.getTag());
        XmlDocumentTest.assertEquals((Object)"wbp:", (Object)element.getTagNS());
    }

    @Test
    public void test_getChild_byTag() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <first/>", "  <second/>", "</root>");
        DocumentElement first = this.rootElement.getChildAt(0);
        DocumentElement second = this.rootElement.getChildAt(1);
        XmlDocumentTest.assertSame(null, (Object)this.rootElement.getChild("noSuch", false));
        XmlDocumentTest.assertSame((Object)first, (Object)this.rootElement.getChild("first", false));
        XmlDocumentTest.assertSame((Object)second, (Object)this.rootElement.getChild("second", false));
        XmlDocumentTest.assertSame(null, (Object)this.rootElement.getChild("First", false));
        XmlDocumentTest.assertSame((Object)first, (Object)this.rootElement.getChild("First", true));
    }

    @Test
    public void test_getDirectChild() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <parent>", "    <directChild>", "      <indirectChild/>", "    </directChild>", "  </parent>", "  <notChild/>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        DocumentElement directChild = parent.getChildAt(0);
        DocumentElement indirectChild = directChild.getChildAt(0);
        DocumentElement notChild = this.rootElement.getChildAt(1);
        XmlDocumentTest.assertSame((Object)directChild, (Object)parent.getDirectChild(directChild));
        XmlDocumentTest.assertSame((Object)directChild, (Object)parent.getDirectChild(indirectChild));
        XmlDocumentTest.assertSame(null, (Object)parent.getDirectChild(notChild));
        XmlDocumentTest.assertSame(null, (Object)parent.getDirectChild(this.rootElement));
    }

    @Test
    public void test_textNode_parse() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "  <source><![CDATA[Some source]]></source>", "</root>");
        List children = this.rootElement.getChildren();
        Assertions.assertThat((List)children).hasSize(2);
        DocumentElement descriptionElement = (DocumentElement)children.get(0);
        XmlDocumentTest.assertEquals((Object)"description", (Object)descriptionElement.getTag());
        DocumentTextNode textNode = descriptionElement.getTextNode();
        XmlDocumentTest.assertSame((Object)descriptionElement, (Object)textNode.getEnclosingElement());
        XmlDocumentTest.assertFalse((boolean)textNode.isCDATA());
        XmlDocumentTest.assertEquals((Object)"Some text", (Object)textNode.getText());
        DocumentElement sourceElement = (DocumentElement)children.get(1);
        XmlDocumentTest.assertEquals((Object)"source", (Object)sourceElement.getTag());
        textNode = sourceElement.getTextNode();
        XmlDocumentTest.assertSame((Object)sourceElement, (Object)textNode.getEnclosingElement());
        XmlDocumentTest.assertTrue((boolean)textNode.isCDATA());
        XmlDocumentTest.assertEquals((Object)"Some source", (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "  <source><![CDATA[Some source]]></source>", "</root>");
    }

    @Test
    public void test_textNode_edit() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        DocumentTextNode textNode = parent.getTextNode();
        XmlDocumentTest.assertFalse((boolean)textNode.isCDATA());
        XmlDocumentTest.assertEquals((Object)"Some text", (Object)textNode.getText());
        String text = "Other text";
        textNode.setText(text);
        XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Other text</description>", "</root>");
        text = "First line\nSecond line";
        textNode.setText(text);
        XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>First line\nSecond line</description>", "</root>");
        text = "";
        textNode.setText(text);
        XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description></description>", "</root>");
        text = "the text";
        textNode.setText(text);
        XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>the text</description>", "</root>");
        parent.removeTextNode();
        XmlDocumentTest.assertSame(null, (Object)parent.getTextNode());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
    }

    @Test
    public void test_textNode_edit_CDATA() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description><![CDATA[Some text]]></description>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        DocumentTextNode textNode = parent.getTextNode();
        XmlDocumentTest.assertTrue((boolean)textNode.isCDATA());
        XmlDocumentTest.assertEquals((Object)"Some text", (Object)textNode.getText());
        String text = "Other text";
        textNode.setText(text);
        XmlDocumentTest.assertEquals((Object)text, (Object)textNode.getText());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description><![CDATA[Other text]]></description>", "</root>");
        parent.removeTextNode();
        XmlDocumentTest.assertSame(null, (Object)parent.getTextNode());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
    }

    @Test
    public void test_textNode_edit_CDATA2() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description><![CDATA[Some text]]></description>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        DocumentTextNode textNode = parent.getTextNode();
        XmlDocumentTest.assertTrue((boolean)textNode.isCDATA());
        XmlDocumentTest.assertEquals((Object)"Some text", (Object)textNode.getText());
        textNode.setCDATA(false);
        XmlDocumentTest.assertFalse((boolean)textNode.isCDATA());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
    }

    @Test
    public void test_textNode_add_whenOpen() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description></description>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals(null, (Object)parent.getTextNode());
        DocumentTextNode textNode = new DocumentTextNode(false);
        textNode.setText("Some text");
        parent.setTextNode(textNode);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
    }

    @Test
    public void test_textNode_add_whenClosed() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals(null, (Object)parent.getTextNode());
        DocumentTextNode textNode = new DocumentTextNode(false);
        textNode.setText("Some text");
        parent.setTextNode(textNode);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
    }

    @Test
    public void test_textNode_add_CDATA() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description></description>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals(null, (Object)parent.getTextNode());
        DocumentTextNode textNode = new DocumentTextNode(false);
        textNode.setCDATA(true);
        textNode.setText("Some text");
        parent.setTextNode(textNode);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description><![CDATA[Some text]]></description>", "</root>");
    }

    @Test
    public void test_textNode_setText_new() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals(null, (Object)element.getTextNode());
        element.setText("Some text", false);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
    }

    @Test
    public void test_textNode_setText_new_CDATA() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals(null, (Object)element.getTextNode());
        element.setText("Some text", true);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description><![CDATA[Some text]]></description>", "</root>");
    }

    @Test
    public void test_textNode_setText_replace() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Old text</description>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        element.setText("New text", false);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>New text</description>", "</root>");
    }

    @Test
    public void test_textNode_setText_remove() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description>Some text</description>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        element.setText(null, false);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <description/>", "</root>");
    }

    @Test
    public void test_attribute_addFirst() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
        Assertions.assertThat((List)this.rootElement.getDocumentAttributes()).isEmpty();
        DocumentAttribute newAttribute = this.rootElement.setAttribute("name", "value");
        XmlDocumentTest.assertEquals((Object)"name", (Object)newAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)newAttribute.getValue());
        List attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).containsOnly((Object[])new DocumentAttribute[]{newAttribute});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'/>");
    }

    @Test
    public void test_attribute_addSecond() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root other='attr'/>");
        Assertions.assertThat((List)this.rootElement.getDocumentAttributes()).hasSize(1);
        DocumentAttribute newAttribute = this.rootElement.setAttribute("name", "value");
        XmlDocumentTest.assertEquals((Object)"name", (Object)newAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)newAttribute.getValue());
        List attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).contains((Object[])new DocumentAttribute[]{newAttribute});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root other='attr' name='value'/>");
    }

    @Test
    public void test_attribute_addThird() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root a='1' b='2'/>");
        Assertions.assertThat((List)this.rootElement.getDocumentAttributes()).hasSize(2);
        DocumentAttribute newAttribute = this.rootElement.setAttribute("name", "value");
        XmlDocumentTest.assertEquals((Object)"name", (Object)newAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)newAttribute.getValue());
        List attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).contains((Object[])new DocumentAttribute[]{newAttribute});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root a='1' b='2' name='value'/>");
    }

    @Test
    public void test_attribute_addNullValue() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
        Assertions.assertThat((List)this.rootElement.getDocumentAttributes()).isEmpty();
        DocumentAttribute newAttribute = this.rootElement.setAttribute("name", null);
        XmlDocumentTest.assertNull((Object)newAttribute);
        Assertions.assertThat((List)this.rootElement.getDocumentAttributes()).isEmpty();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
    }

    @Test
    public void test_attribute_charset() throws Exception {
        String rusValue = "\u0410\u0411\u0412";
        this.prepareContext("<!-- ==================================== -->", "<!-- ==================================== -->", "<root/>");
        this.rootElement.setAttribute("name", "\n ' \" < > &");
        this.assertContext("<!-- ==================================== -->", "<!-- ==================================== -->", "<root name='&#10; &apos; &quot; &lt; &gt; &amp;'/>");
        XmlDocumentTest.assertEquals(null, (Object)this.rootElement.getModel().getCharset());
        this.rootElement.setAttribute("name", rusValue);
        this.assertContext("<!-- ==================================== -->", "<!-- ==================================== -->", "<root name='&#1040;&#1041;&#1042;'/>");
        this.rootElement.getModel().setCharset("UTF-8");
        this.rootElement.setAttribute("name", rusValue);
        this.assertContext("<!-- ==================================== -->", "<!-- ==================================== -->", "<root name='\u0410\u0411\u0412'/>");
        this.rootElement.getModel().setCharset("ISO-8859-1");
        this.rootElement.setAttribute("name", rusValue);
        this.assertContext("<!-- ==================================== -->", "<!-- ==================================== -->", "<root name='&#1040;&#1041;&#1042;'/>");
    }

    @Test
    public void test_attribute_edit() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'/>");
        DocumentAttribute rootAttribute = this.rootElement.getDocumentAttribute("name");
        XmlDocumentTest.assertNotNull((Object)rootAttribute);
        XmlDocumentTest.assertEquals((Object)"name", (Object)rootAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)rootAttribute.getValue());
        XmlDocumentTest.assertSame((Object)rootAttribute, (Object)this.rootElement.setAttribute("name", "newValue"));
        XmlDocumentTest.assertEquals((Object)"name", (Object)rootAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"newValue", (Object)rootAttribute.getValue());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='newValue'/>");
    }

    @Test
    public void test_attribute_setValue() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'/>");
        DocumentAttribute rootAttribute = this.rootElement.getDocumentAttribute("name");
        XmlDocumentTest.assertNotNull((Object)rootAttribute);
        XmlDocumentTest.assertEquals((Object)"name", (Object)rootAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"value", (Object)rootAttribute.getValue());
        rootAttribute.setValue("newValue");
        XmlDocumentTest.assertEquals((Object)"name", (Object)rootAttribute.getName());
        XmlDocumentTest.assertEquals((Object)"newValue", (Object)rootAttribute.getValue());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='newValue'/>");
    }

    @Test
    public void test_attribute_deleteAsObject() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'/>");
        List attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).hasSize(1);
        DocumentAttribute attribute = this.rootElement.getDocumentAttribute("name");
        XmlDocumentTest.assertNotNull((Object)attribute);
        XmlDocumentTest.assertSame((Object)attribute, attributes.get(0));
        this.rootElement.removeDocumentAttribute(attribute);
        attributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)attributes).hasSize(0);
        XmlDocumentTest.assertNull((Object)this.rootElement.getDocumentAttribute("name"));
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
    }

    @Test
    public void test_attribute_deleteAsValue() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'/>");
        this.rootElement.setAttribute("name", null);
        List nodeAttributes = this.rootElement.getDocumentAttributes();
        Assertions.assertThat((List)nodeAttributes).isEmpty();
        XmlDocumentTest.assertNull((Object)this.rootElement.getDocumentAttribute("name"));
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
    }

    @Test
    public void test_element_add_whenClosed() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <parent/>", "</root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals((Object)"parent", (Object)parent.getTag());
        XmlDocumentTest.assertTrue((boolean)parent.isClosed());
        DocumentElement newChild = new DocumentElement();
        newChild.setTag("child");
        parent.addChild(newChild);
        XmlDocumentTest.assertSame((Object)parent, (Object)newChild.getParent());
        Assertions.assertThat((List)parent.getChildren()).contains((Object[])new DocumentElement[]{newChild});
        XmlDocumentTest.assertTrue((boolean)newChild.isClosed());
        XmlDocumentTest.assertFalse((boolean)parent.isClosed());
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <parent>", "    <child/>", "  </parent>", "</root>");
    }

    @Test
    public void test_element_add_whenSecond() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "</root>");
        DocumentElement newChild = new DocumentElement("second");
        this.rootElement.addChild(newChild);
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "  <second/>", "</root>");
    }

    @Test
    public void test_element_add_whenOnSameLine() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root> <parent></parent> </root>");
        DocumentElement parent = this.rootElement.getChildAt(0);
        DocumentElement newChild = new DocumentElement();
        newChild.setTag("child");
        parent.addChild(newChild);
        m_getSource_ignoreSpaces = true;
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root> <parent>", " \t<child/></parent> </root>");
    }

    @Test
    public void test_element_add_whenSingleLine_whenClosed() throws Exception {
        this.m_removeTrailingEOL = true;
        this.prepareContext("<root/>");
        DocumentElement newChild = new DocumentElement();
        newChild.setTag("child");
        this.rootElement.addChild(newChild);
        this.assertContext("<root>\n\t<child/>\n</root>");
    }

    @Test
    public void test_element_add_whenSingleLine_whenOpen() throws Exception {
        this.m_removeTrailingEOL = true;
        this.prepareContext("<root></root>");
        DocumentElement newChild = new DocumentElement();
        newChild.setTag("child");
        this.rootElement.addChild(newChild);
        this.assertContext("<root><child/></root>");
    }

    @Test
    public void test_element_removeFirst() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "  <second/>", "</root>");
        DocumentElement first = this.rootElement.getChildAt(0);
        first.remove();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <second/>", "</root>");
    }

    @Test
    public void test_element_removeSecond() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "  <second/>", "</root>");
        DocumentElement second = this.rootElement.getChildAt(1);
        second.remove();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "</root>");
    }

    @Test
    public void test_element_removeLast() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <last/>", "</root>");
        DocumentElement second = this.rootElement.getChildAt(0);
        second.remove();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
        XmlDocumentTest.assertTrue((boolean)this.rootElement.isClosed());
    }

    @Test
    public void test_element_remove_parentHasText() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  text <first/>", "</root>");
        DocumentElement first = this.rootElement.getChildAt(0);
        first.remove();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  text ", "</root>");
    }

    @Test
    public void test_element_removeChildren() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <first/>", "  <second/>", "</root>");
        this.rootElement.removeChildren();
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root/>");
    }

    @Test
    public void test_element_setTag() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <tag attrA='1'>", "    <inner attrB='2'/>", "  </tag>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        XmlDocumentTest.assertEquals((Object)"tag", (Object)element.getTag());
        element.setTag("newTag");
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <newTag attrA='1'>", "    <inner attrB='2'/>", "  </newTag>", "</root>");
    }

    @Test
    public void test_element_setTagLocal() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root xmlns:wbp='someValue'>", "  <first/>", "  <wbp:second/>", "</root>");
        DocumentElement element = this.rootElement.getChildAt(0);
        element.setTagLocal("newFirst");
        element = this.rootElement.getChildAt(1);
        element.setTagLocal("newSecond");
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root xmlns:wbp='someValue'>", "  <newFirst/>", "  <wbp:newSecond/>", "</root>");
    }

    @Test
    public void test_element_move_newParent() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element/>", "  </source>", "  <target>", "  </target>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = this.rootElement.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source/>", "  <target>", "    <element/>", "  </target>", "</root>");
    }

    @Test
    public void test_element_move_newParent_oldHasText() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    Some text <element/>", "  </source>", "  <target>", "  </target>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = this.rootElement.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    Some text ", "  </source>", "  <target>", "    <element/>", "  </target>", "</root>");
    }

    @Test
    public void test_element_move_newParent_newIndentation() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element/>", "    <target>", "    </target>", "  </source>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = source.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <target>", "      <element/>", "    </target>", "  </source>", "</root>");
    }

    @Test
    public void test_element_move_reorder_asFirst() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <first/>", "    <element/>", "    <second/>", "  </source>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(1);
        source.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)source, (Object)element.getParent());
        Assertions.assertThat((List)source.getChildren()).contains((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element/>", "    <first/>", "    <second/>", "  </source>", "</root>");
    }

    @Test
    public void test_element_move_reorder_asLast() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <first/>", "    <element/>", "    <second/>", "  </source>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(1);
        source.moveChild(element, 3);
        XmlDocumentTest.assertSame((Object)source, (Object)element.getParent());
        Assertions.assertThat((List)source.getChildren()).contains((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <first/>", "    <second/>", "    <element/>", "  </source>", "</root>");
    }

    @Test
    public void test_element_move_reorder_asLast2() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <first/>", "    <element/>", "    <second/>", "  </source>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(1);
        source.moveChild(element, -1);
        XmlDocumentTest.assertSame((Object)source, (Object)element.getParent());
        Assertions.assertThat((List)source.getChildren()).contains((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <first/>", "    <second/>", "    <element/>", "  </source>", "</root>");
    }

    @Test
    public void test_element_move_closedElement() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element attr='value'/>", "  </source>", "  <target>", "  </target>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = this.rootElement.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source/>", "  <target>", "    <element attr='value'/>", "  </target>", "</root>");
    }

    @Test
    public void test_element_move_closedTarget() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element attr='value'/>", "  </source>", "  <target/>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = this.rootElement.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source/>", "  <target>", "    <element attr='value'/>", "  </target>", "</root>");
    }

    @Test
    public void test_element_move_openWithText() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source>", "    <element attr='value'>Some text</element>", "  </source>", "  <target>", "  </target>", "</root>");
        DocumentElement source = this.rootElement.getChildAt(0);
        DocumentElement element = source.getChildAt(0);
        DocumentElement target = this.rootElement.getChildAt(1);
        target.moveChild(element, 0);
        XmlDocumentTest.assertSame((Object)target, (Object)element.getParent());
        Assertions.assertThat((List)target.getChildren()).contains((Object[])new DocumentElement[]{element});
        Assertions.assertThat((List)source.getChildren()).doesNotContain((Object[])new DocumentElement[]{element});
        this.assertContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root>", "  <source/>", "  <target>", "    <element attr='value'>Some text</element>", "  </target>", "</root>");
    }

    @Test
    public void test_visitor() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<!-- ==================================== -->", "<root name='value'>", "  <tag name2='222'/>", "</root>");
        XmlDocumentTest.assertNotNull((Object)this.rootElement);
        this.rootElement.accept(new DocumentModelVisitor());
        final ArrayList visitObjects = new ArrayList();
        this.rootElement.accept(new DocumentModelVisitor(){

            public boolean visit(DocumentElement element) {
                visitObjects.add(element);
                return true;
            }

            public void visit(DocumentAttribute attribute) {
                visitObjects.add(attribute);
            }

            public void visit(DocumentTextNode node) {
                visitObjects.add(node);
            }

            public void endVisit(DocumentElement element) {
                visitObjects.add(element);
            }
        });
        Assertions.assertThat(visitObjects).hasSize(6);
        XmlDocumentTest.assertSame((Object)this.rootElement, visitObjects.get(0));
        XmlDocumentTest.assertSame((Object)this.rootElement.getDocumentAttribute("name"), visitObjects.get(1));
        XmlDocumentTest.assertSame((Object)this.rootElement.getChildAt(0), visitObjects.get(2));
        XmlDocumentTest.assertSame((Object)this.rootElement.getChildAt(0).getDocumentAttribute("name2"), visitObjects.get(3));
        XmlDocumentTest.assertSame((Object)this.rootElement.getChildAt(0), visitObjects.get(4));
        XmlDocumentTest.assertSame((Object)this.rootElement, visitObjects.get(5));
        visitObjects.clear();
        this.rootElement.accept(new DocumentModelVisitor(){

            public boolean visit(DocumentElement element) {
                visitObjects.add(element);
                return false;
            }

            public void visit(DocumentAttribute attribute) {
                visitObjects.add(attribute);
            }

            public void visit(DocumentTextNode node) {
                visitObjects.add(node);
            }

            public void endVisit(DocumentElement element) {
                visitObjects.add(element);
            }
        });
        Assertions.assertThat(visitObjects).containsExactly((Object[])new AbstractDocumentObject[]{this.rootElement});
    }

    @Test
    public void test_getElements() throws Exception {
        this.prepareContext("<?xml version='1.0' encoding='UTF-8'?>", "<root>", "  <special name='A'/>", "  <someOther/>", "  <special name='B'/>", "</root>");
        List specials = this.rootElement.getChildren(SpecialDocumentNode.class);
        Assertions.assertThat((List)specials).hasSize(2);
        XmlDocumentTest.assertEquals((Object)"A", (Object)((SpecialDocumentNode)((Object)specials.get(0))).getAttribute("name"));
        XmlDocumentTest.assertEquals((Object)"B", (Object)((SpecialDocumentNode)((Object)specials.get(1))).getAttribute("name"));
    }

    @Test
    public void test_toString_rootWithoutChildren() throws Exception {
        String content = XmlDocumentTest.getDoubleQuotes2("<root/>");
        this.prepareContext(content);
        XmlDocumentTest.assertEquals((Object)content, (Object)this.rootElement.toString());
    }

    @Test
    public void test_toString_rootWithAttributes() throws Exception {
        String content = XmlDocumentTest.getDoubleQuotes2("<root name='value'/>");
        this.prepareContext(content);
        XmlDocumentTest.assertEquals((Object)content, (Object)this.rootElement.toString());
    }

    @Test
    public void test_toString_rootOnlyText() throws Exception {
        String content = XmlDocumentTest.getDoubleQuotes2("<root>aaa bbb</root>");
        this.prepareContext(content);
        XmlDocumentTest.assertEquals((Object)content, (Object)this.rootElement.toString());
    }

    @Test
    public void test_toString_twoLevels() throws Exception {
        String content = XmlDocumentTest.getDoubleQuotes2("<root>", "  <firstLevelElement>", "    <secondLevelElement/>", "  </firstLevelElement>", "</root>");
        this.prepareContext(content);
        XmlDocumentTest.assertEquals((Object)content, (Object)this.rootElement.toString());
    }

    @Test
    public void test_writeShort_rootWithAttributes() throws Exception {
        this.prepareContext("<root name='value'/>");
        XmlDocumentTest.assertEquals((Object)XmlDocumentTest.getSourceDQ("<root name='value'>"), (Object)XmlDocumentTest.writeShort(this.rootElement));
    }

    @Test
    public void test_writeShort_twoLevels() throws Exception {
        this.prepareContext("<root>", "  <firstLevelElement>", "    <secondLevelElement/>", "  </firstLevelElement>", "</root>");
        XmlDocumentTest.assertEquals((Object)"<root>", (Object)XmlDocumentTest.writeShort(this.rootElement));
    }

    private static String writeShort(DocumentElement element) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        element.writeShort(writer);
        writer.close();
        return stringWriter.toString();
    }

    @Test
    public void test_fileContext() throws Exception {
        String filePath = "test/1.xml";
        IFile file = XmlDocumentTest.setFileContentSrc(filePath, "<root/>");
        file.setCharset("UTF-8", null);
        FileDocumentEditContext editContext = new FileDocumentEditContext(file){

            protected AbstractDocumentHandler createDocumentHandler() {
                return new TestDocumentHandler();
            }
        };
        this.rootElement = editContext.getRoot();
        XmlDocumentTest.assertEquals((Object)"UTF-8", (Object)this.rootElement.getModel().getCharset());
        try {
            this.rootElement.setTag("newTag");
            XmlDocumentTest.assertEquals((Object)"<root/>", (Object)XmlDocumentTest.getFileContentSrc(filePath));
            editContext.commit();
            XmlDocumentTest.assertEquals((Object)"<newTag/>", (Object)XmlDocumentTest.getFileContentSrc(filePath));
        }
        finally {
            editContext.disconnect();
        }
    }
}

