/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.validator;

import org.apache.commons.lang3.ObjectUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.gef.policy.validator.BorderOfChildLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.CachingLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.CompatibleLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.ComponentClassLayoutRequestValidator;
import org.eclipse.wb.core.gef.policy.validator.LayoutRequestValidators;
import org.eclipse.wb.core.gef.policy.validator.ModelClassLayoutRequestValidator;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.editor.validator.AbstractLayoutRequestValidatorTest;
import org.junit.Test;

public class LayoutRequestValidatorsTest
extends AbstractLayoutRequestValidatorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_TRUE() throws Exception {
        ILayoutRequestValidator validator = ILayoutRequestValidator.TRUE;
        LayoutRequestValidatorsTest.assertTrue(validator);
    }

    @Test
    public void test_FALSE() throws Exception {
        ILayoutRequestValidator validator = ILayoutRequestValidator.FALSE;
        LayoutRequestValidatorsTest.assertFalse(validator);
    }

    @Test
    public void test_finalize() throws Exception {
        ILayoutRequestValidator specificValidator = ILayoutRequestValidator.TRUE;
        ILayoutRequestValidator validator = LayoutRequestValidators.finalize((ILayoutRequestValidator)specificValidator);
        Assertions.assertThat((Object[])LayoutRequestValidatorsTest.getValidators(validator)).contains((Object[])new ILayoutRequestValidator[]{specificValidator});
        LayoutRequestValidatorsTest.assertHas_Compatible(validator);
        LayoutRequestValidatorsTest.assertHas_BorderOfChild(validator);
    }

    @Test
    public void test_modelType() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.modelType(ContainerInfo.class);
        LayoutRequestValidatorsTest.assertHas_ModelType(validator, ContainerInfo.class);
        LayoutRequestValidatorsTest.assertHas_Compatible(validator);
        LayoutRequestValidatorsTest.assertHas_BorderOfChild(validator);
    }

    @Test
    public void test_componentType() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.componentType((String)"javax.swing.JButton");
        LayoutRequestValidatorsTest.assertHas_ComponentType(validator, "javax.swing.JButton");
        LayoutRequestValidatorsTest.assertHas_Compatible(validator);
        LayoutRequestValidatorsTest.assertHas_BorderOfChild(validator);
    }

    private static void assertHas_Compatible(ILayoutRequestValidator compoundValidator) {
        ILayoutRequestValidator[] validators;
        ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators = LayoutRequestValidatorsTest.getValidators(compoundValidator);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
            if (validator instanceof CompatibleLayoutRequestValidator) {
                return;
            }
            ++n2;
        }
        LayoutRequestValidatorsTest.fail((String)"Can not find Compatible_LayoutRequestValidator");
    }

    private static void assertHas_BorderOfChild(ILayoutRequestValidator compoundValidator) {
        ILayoutRequestValidator[] validators;
        ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators = LayoutRequestValidatorsTest.getValidators(compoundValidator);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
            if (validator instanceof BorderOfChildLayoutRequestValidator) {
                return;
            }
            ++n2;
        }
        LayoutRequestValidatorsTest.fail((String)"Can not find Compatible_LayoutRequestValidator");
    }

    private static void assertHas_ModelType(ILayoutRequestValidator compoundValidator, Class<?> requiredModelClass) {
        ILayoutRequestValidator[] validators;
        ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators = LayoutRequestValidatorsTest.getValidators(compoundValidator);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
            if (validator instanceof ModelClassLayoutRequestValidator && ObjectUtils.equals((Object)ReflectionUtils.getFieldObject((Object)validator, (String)"m_requiredModelClass"), requiredModelClass)) {
                return;
            }
            ++n2;
        }
        LayoutRequestValidatorsTest.fail((String)("Can not find ModelClass_LayoutRequestValidator " + String.valueOf(requiredModelClass)));
    }

    private static void assertHas_ComponentType(ILayoutRequestValidator compoundValidator, String requiredComponentClass) {
        ILayoutRequestValidator[] validators;
        ILayoutRequestValidator[] iLayoutRequestValidatorArray = validators = LayoutRequestValidatorsTest.getValidators(compoundValidator);
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutRequestValidator validator = iLayoutRequestValidatorArray[n2];
            if (validator instanceof ComponentClassLayoutRequestValidator && ObjectUtils.equals((Object)ReflectionUtils.getFieldObject((Object)validator, (String)"m_requiredClass"), (Object)requiredComponentClass)) {
                return;
            }
            ++n2;
        }
        LayoutRequestValidatorsTest.fail((String)("Can not find ComponentClass_LayoutRequestValidator " + requiredComponentClass));
    }

    private static ILayoutRequestValidator[] getValidators(ILayoutRequestValidator compoundValidator) {
        ILayoutRequestValidator[] validators = (ILayoutRequestValidator[])ReflectionUtils.getFieldObject((Object)compoundValidator, (String)"val$validators");
        LayoutRequestValidatorsTest.stripCaching(validators);
        return validators;
    }

    private static void stripCaching(ILayoutRequestValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            ILayoutRequestValidator validator = validators[i];
            if (validator instanceof CachingLayoutRequestValidator) {
                validators[i] = (ILayoutRequestValidator)ReflectionUtils.getFieldObject((Object)validator, (String)"m_validator");
            }
            ++i;
        }
    }

    @Test
    public void test_Compound_and_true() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.and((ILayoutRequestValidator[])new ILayoutRequestValidator[]{ILayoutRequestValidator.TRUE, ILayoutRequestValidator.TRUE});
        LayoutRequestValidatorsTest.assertTrue(validator);
    }

    @Test
    public void test_Compound_and_false() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.and((ILayoutRequestValidator[])new ILayoutRequestValidator[]{ILayoutRequestValidator.TRUE, ILayoutRequestValidator.FALSE});
        LayoutRequestValidatorsTest.assertFalse(validator);
    }

    @Test
    public void test_Compound_or_true() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.or((ILayoutRequestValidator[])new ILayoutRequestValidator[]{ILayoutRequestValidator.TRUE, ILayoutRequestValidator.FALSE});
        LayoutRequestValidatorsTest.assertTrue(validator);
    }

    @Test
    public void test_Compound_or_false() throws Exception {
        ILayoutRequestValidator validator = LayoutRequestValidators.or((ILayoutRequestValidator[])new ILayoutRequestValidator[]{ILayoutRequestValidator.FALSE, ILayoutRequestValidator.FALSE});
        LayoutRequestValidatorsTest.assertFalse(validator);
    }
}

